/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.udriver.googlesheets;

import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.AddSheetRequest;
import com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetRequest;
import com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetResponse;
import com.google.api.services.sheets.v4.model.DeleteSheetRequest;
import com.google.api.services.sheets.v4.model.Request;
import com.google.api.services.sheets.v4.model.Response;
import com.google.api.services.sheets.v4.model.SheetProperties;
import com.google.api.services.sheets.v4.model.ValueRange;
import com.stambia.jdbc.common.TableMetaData;
import com.stambia.jdbc.common.parser.Parser;
import com.stambia.jdbc.common.parser.SelectMetaData;
import com.stambia.udriver.googlesheets.GSheetsConnection;
import com.stambia.udriver.googlesheets.GSheetsDatabaseMetaData;
import com.stambia.udriver.googlesheets.GSheetsResultSet;
import com.stambia.udriver.googlesheets.GSheetsWhereVisitor;
import com.stambia.udriver.googlesheets.Messages;
import com.stambia.udriver.jdbc.ResultSetMetaDataImpl;
import com.stambia.udriver.jdbc.StatementImpl;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class GSheetsStatement
extends StatementImpl {
    private GSheetsConnection conn;
    private GSheetsResultSet resultSet;
    private int fetchSize = 1000;
    private String spreadsheetId;
    private Integer tempSheetId;

    public GSheetsStatement(GSheetsConnection conn) {
        this.conn = conn;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        Parser parser = new Parser(sql);
        SelectMetaData select = parser.getSelectMetaData(new GSheetsWhereVisitor((GSheetsDatabaseMetaData)this.getConnection().getMetaData()));
        if (select != null) {
            this.spreadsheetId = select.getTableFrom().get(0).getSchemaName();
            try {
                if (select.getWhereString() != null && !select.getWhereString().isEmpty()) {
                    this.executeFilteredQuery(select);
                } else {
                    this.executeQuery(select);
                }
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
            return true;
        }
        TableMetaData truncateTable = parser.getTruncateParser();
        if (truncateTable != null) {
            this.spreadsheetId = truncateTable.getSchemaName();
            this.executeTruncate(truncateTable);
            return false;
        }
        return false;
    }

    private void executeTruncate(TableMetaData truncateTable) throws SQLException {
        String sheetName = truncateTable.getTableName();
        String range = this.conn.getSheetDataRange(this.spreadsheetId, sheetName);
        if (range != null) {
            try {
                this.getService().spreadsheets().values().clear(this.spreadsheetId, range, null).execute();
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
    }

    protected Sheets getService() {
        return this.conn.getService();
    }

    private ResultSet executeQuery(SelectMetaData select) throws IOException, SQLException {
        List<TableMetaData> tables = select.getTableFrom();
        if (tables.size() == 0) {
            throw new SQLException(Messages.getString("GSheetsStatement.0"));
        }
        if (tables.size() > 1) {
            throw new SQLException(Messages.getString("GSheetsStatement.1"));
        }
        TableMetaData table = tables.get(0);
        this.spreadsheetId = table.getSchemaName();
        if (this.spreadsheetId == null) {
            throw new SQLException(Messages.getString("GSheetsStatement.2"));
        }
        String tableName = table.getTableName();
        List<String> _cols = select.isAllColumns() ? null : select.getLstStringColumns();
        Map<String, String> aliases = select.isAllColumns() ? null : select.getAliasesColumn();
        GSheetsResultSet rs = new GSheetsResultSet(this.conn, this.spreadsheetId, tableName);
        GSheetsDatabaseMetaData dmd = (GSheetsDatabaseMetaData)this.getConnection().getMetaData();
        ResultSetMetaDataImpl rsmi = new ResultSetMetaDataImpl();
        List<String> cols = dmd.getListColumns(this.spreadsheetId, tableName);
        if (_cols == null) {
            int i = 0;
            while (i < cols.size()) {
                ResultSetMetaDataImpl.ColumnMetadata colmd = new ResultSetMetaDataImpl.ColumnMetadata();
                colmd.catalogName = this.spreadsheetId;
                colmd.columnName = cols.get(i);
                colmd.columnLabel = cols.get(i);
                colmd.tableName = tableName;
                colmd.position = i++;
                rsmi.addColumn(colmd);
            }
        } else {
            for (int i = 0; i < _cols.size(); ++i) {
                ResultSetMetaDataImpl.ColumnMetadata colmd = new ResultSetMetaDataImpl.ColumnMetadata();
                colmd.catalogName = this.spreadsheetId;
                colmd.columnName = aliases.get(_cols.get(i));
                colmd.columnLabel = _cols.get(i);
                colmd.tableName = tableName;
                colmd.position = cols.indexOf(aliases.get(_cols.get(i)));
                rsmi.addColumn(colmd);
            }
        }
        rs.setFetchSize(this.fetchSize);
        rs.setMetadata(rsmi);
        this.resultSet = rs;
        return rs;
    }

    private Integer createTemporarySheet(String originalTableName, String tempSheetName) throws SQLException, IOException {
        AddSheetRequest sr = new AddSheetRequest();
        SheetProperties sourceSheetProps = this.conn.getSheetProperties(this.spreadsheetId, originalTableName);
        SheetProperties sheetProps = new SheetProperties().setTitle(tempSheetName).setGridProperties(sourceSheetProps.getGridProperties());
        sr.setProperties(sheetProps);
        BatchUpdateSpreadsheetRequest batchUpdate = new BatchUpdateSpreadsheetRequest();
        batchUpdate.setRequests(Collections.singletonList(new Request().setAddSheet(sr)));
        BatchUpdateSpreadsheetResponse resp = (BatchUpdateSpreadsheetResponse)this.getService().spreadsheets().batchUpdate(this.spreadsheetId, batchUpdate).execute();
        return ((Response)resp.getReplies().get(0)).getAddSheet().getProperties().getSheetId();
    }

    private ResultSet executeFilteredQuery(SelectMetaData select) throws SQLException, IOException {
        List<TableMetaData> tables = select.getTableFrom();
        if (tables.size() == 0) {
            throw new SQLException(Messages.getString("GSheetsStatement.3"));
        }
        if (tables.size() > 1) {
            throw new SQLException(Messages.getString("GSheetsStatement.4"));
        }
        TableMetaData table = select.getTableFrom().get(0);
        this.spreadsheetId = table.getSchemaName();
        String tableName = table.getTableName();
        String tempSheetName = UUID.randomUUID().toString();
        this.tempSheetId = this.createTemporarySheet(tableName, tempSheetName);
        String query = "=QUERY('" + table.getTableName() + "'!A1:ZZZ;\"select * where " + select.getWhereString() + "\";-1)";
        this.querySheet(tempSheetName, query);
        table.setTableName(tempSheetName);
        ResultSet rs = this.executeQuery(select);
        return rs;
    }

    private void deleteTempSheet(Integer tempSheetId) throws IOException {
        BatchUpdateSpreadsheetRequest batchUpdate = new BatchUpdateSpreadsheetRequest();
        DeleteSheetRequest dsr = new DeleteSheetRequest().setSheetId(tempSheetId);
        batchUpdate.setRequests(Collections.singletonList(new Request().setDeleteSheet(dsr)));
        this.getService().spreadsheets().batchUpdate(this.spreadsheetId, batchUpdate).execute();
    }

    private void querySheet(String sheetName, String query) throws IOException {
        ValueRange body = new ValueRange().setValues(Collections.singletonList(Collections.singletonList(query)));
        this.getService().spreadsheets().values().append(this.spreadsheetId, sheetName + "!A1", body).setValueInputOption("USER_ENTERED").execute();
    }

    @Override
    public ResultSet executeQuery(String arg0) throws SQLException {
        Parser _parser = new Parser(arg0);
        SelectMetaData parser = _parser.getSelectMetaData(new GSheetsWhereVisitor((GSheetsDatabaseMetaData)this.getConnection().getMetaData()));
        if (parser == null) {
            throw new SQLException(Messages.getString("GSheetsStatement.5"));
        }
        try {
            if (parser.getWhereString() != null && !parser.getWhereString().isEmpty()) {
                return this.executeFilteredQuery(parser);
            }
            return this.executeQuery(parser);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public int executeUpdate(String query) throws SQLException {
        this.execute(query);
        return 1;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.resultSet;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (this.tempSheetId != null) {
            try {
                this.deleteTempSheet(this.tempSheetId);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
    }
}

