/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.udriver.googlesheets;

import com.stambia.jdbc.common.TableMetaData;
import com.stambia.jdbc.common.parser.IWhereVisitor;
import com.stambia.jdbc.common.parser.SelectMetaData;
import com.stambia.jdbc.common.parser.WhereVisitor;
import com.stambia.udriver.googlesheets.GSheetsDatabaseMetaData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.schema.Column;

public class GSheetsWhereVisitor
extends WhereVisitor
implements IWhereVisitor {
    private SelectMetaData selectMd;
    private List<String> columnNames;
    private GSheetsDatabaseMetaData dbmd;

    public GSheetsWhereVisitor(GSheetsDatabaseMetaData dbmd) {
        this.dbmd = dbmd;
    }

    @Override
    public void visit(Column arg0) {
        String columnName = "";
        for (int i = 0; i < this.columnNames.size(); ++i) {
            if (!arg0.getColumnName().replace("\"", "").equalsIgnoreCase(this.columnNames.get(i))) continue;
            columnName = GSheetsWhereVisitor.columnAdress(i + 1);
        }
        this.whereClauseReplacement.put(arg0.getWholeColumnName(), columnName);
    }

    @Override
    public void visit(StringValue arg0) {
        this.whereClauseReplacement.put(arg0.toString(), "'" + arg0.getValue() + "'");
    }

    public static String columnAdress(int col) {
        if (col <= 26) {
            return String.valueOf((char)(col + 64));
        }
        int div = col / 26;
        int mod = col % 26;
        if (mod == 0) {
            mod = 26;
            --div;
        }
        return GSheetsWhereVisitor.columnAdress(div) + GSheetsWhereVisitor.columnAdress(mod);
    }

    @Override
    public void setSelectMetaData(SelectMetaData selectMd) {
        this.selectMd = selectMd;
        TableMetaData table = selectMd.getTableFrom().get(0);
        try {
            this.columnNames = this.dbmd.getListColumns(table.getSchemaName(), table.getTableName());
        }
        catch (IOException e) {
            this.columnNames = new ArrayList<String>();
        }
    }

    @Override
    public boolean isLeftCol() {
        return false;
    }

    @Override
    public boolean isRightCol() {
        return false;
    }

    @Override
    public String getLeftExpression() {
        return null;
    }

    @Override
    public String getRightExpression() {
        return null;
    }
}

