/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.udriver.googlesheets.oauth;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.stambia.udriver.googlesheets.oauth.Messages;
import com.stambia.udriver.googlesheets.oauth.OAuth2Metadata;
import com.stambia.udriver.googlesheets.oauth.OAuth2TokenKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class OAuth2 {
    static Map<OAuth2TokenKey, Token> map = new HashMap<OAuth2TokenKey, Token>();

    private OAuth2() {
        throw new IllegalStateException("Utility class");
    }

    static Map<String, String> parseResponse(InputStream is, boolean getRefreshToken) throws Exception {
        String refreshToken;
        HashMap<String, String> prop = new HashMap<String, String>();
        String content = CharStreams.toString((Readable)new InputStreamReader(is, Charsets.UTF_8));
        Closeables.closeQuietly((InputStream)is);
        String accessToken = OAuth2.parseParamter(content, "access_token", false);
        if (getRefreshToken && (refreshToken = OAuth2.parseParamter(content, "refresh_token", false)) != null) {
            prop.put("refresh_token", refreshToken);
        }
        String expires_in = OAuth2.parseParamter(content, "expires_in", true);
        prop.put("access_token", accessToken);
        if (expires_in != null && !expires_in.isEmpty()) {
            prop.put("expires_in", expires_in);
        }
        return prop;
    }

    static String parseParamter(String json, String name, boolean numeric) {
        String _name = "\"" + name + "\"";
        int index = json.indexOf(_name);
        if (index == -1) {
            return null;
        }
        String value = json.substring(index + _name.length());
        if (!numeric) {
            index = value.indexOf("\"");
            value = value.substring(index + 1);
            index = value.indexOf("\"");
            value = value.substring(0, index);
        } else {
            index = value.indexOf(":");
            if ((index = (value = value.substring(index + 1).trim()).indexOf(",")) == -1) {
                index = value.indexOf("}");
            }
            if (index == -1) {
                index = value.indexOf("\n");
            }
            if (index == -1) {
                index = value.indexOf(" ");
            }
            value = value.substring(0, index);
            value = value.trim();
        }
        return value;
    }

    public static String getAuthEndPointUrl(OAuth2Metadata md) throws MalformedURLException, UnsupportedEncodingException {
        URLBuilder urlWrapper = new URLBuilder();
        urlWrapper.parameters.put("client_id", md.clientId);
        urlWrapper.parameters.put("redirect_uri", md.redirectEndpoint);
        urlWrapper.parameters.put("scope", md.scope);
        urlWrapper.parameters.put("response_type", "code");
        return urlWrapper.getQuery(true, md.authEndpoint);
    }

    public static Map<String, String> refreshToken(OAuth2Metadata md) throws IOException, Exception {
        if (md.refreshToken == null) {
            throw new RuntimeException(Messages.getString("OAuth2.0"));
        }
        URLBuilder urlWrapper = new URLBuilder();
        urlWrapper.parameters.put("client_secret", md.clientSecret);
        urlWrapper.parameters.put("client_id", md.clientId);
        urlWrapper.parameters.put("refresh_token", md.refreshToken);
        urlWrapper.parameters.put("grant_type", "refresh_token");
        String query2 = urlWrapper.getQuery(true, null);
        URL url = new URL(md.tokenEndpoint);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (md.connectionTimeout > -1) {
            conn.setConnectTimeout(md.connectionTimeout);
        }
        if (md.readTimeout > -1) {
            conn.setReadTimeout(md.readTimeout);
        }
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestMethod("POST");
        OutputStreamWriter osw = new OutputStreamWriter(conn.getOutputStream());
        osw.write(query2);
        osw.close();
        Map<String, String> ret = OAuth2.parseResponse(conn.getInputStream(), false);
        conn.disconnect();
        return ret;
    }

    public static Map<String, String> getNewToken(OAuth2Metadata md) throws Exception {
        URLBuilder urlWrapper = new URLBuilder();
        urlWrapper.parameters.put("code", md.code);
        urlWrapper.parameters.put("client_secret", md.clientSecret);
        urlWrapper.parameters.put("client_id", md.clientId);
        urlWrapper.parameters.put("redirect_uri", md.redirectEndpoint);
        urlWrapper.parameters.put("grant_type", "authorization_code");
        String query2 = urlWrapper.getQuery(true, null);
        URL url = new URL(md.tokenEndpoint);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (md.connectionTimeout > -1) {
            conn.setConnectTimeout(md.connectionTimeout);
        }
        if (md.readTimeout > -1) {
            conn.setReadTimeout(md.readTimeout);
        }
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestMethod("POST");
        OutputStreamWriter osw = new OutputStreamWriter(conn.getOutputStream());
        osw.write(query2);
        osw.close();
        return OAuth2.parseResponse(conn.getInputStream(), true);
    }

    public static void addAccessToken(HttpURLConnection conn, String tokenType, String accessToken) throws Exception {
        conn.setRequestProperty("Authorization", tokenType + " " + accessToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getToken(OAuth2Metadata _new) throws IOException, Exception {
        if (_new.refreshToken == null) {
            return _new.accessToken;
        }
        Map<OAuth2TokenKey, Token> map = OAuth2.map;
        synchronized (map) {
            long currentTime;
            OAuth2TokenKey auth2TokenKey = new OAuth2TokenKey(_new);
            Token token = OAuth2.map.get(auth2TokenKey);
            if (token == null) {
                token = new Token();
                OAuth2.map.put(auth2TokenKey, token);
            }
            if (token.expireTime < (currentTime = System.currentTimeMillis())) {
                String str;
                String accessToken;
                Map<String, String> ret = null;
                int i = 0;
                do {
                    try {
                        ret = OAuth2.refreshToken(_new);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (++i < _new.numberOfAttempts) continue;
                        throw new Exception(Messages.getString("OAuth2.5") + i, e);
                    }
                } while (ret == null);
                token.accessToken = accessToken = ret.get("access_token");
                token.expireTime = _new.expiresIn > 0L ? currentTime + _new.expiresIn * 1000L : ((str = ret.get("expires_in")) != null ? currentTime + Long.parseLong(str) * 1000L : currentTime);
                return token.accessToken;
            }
            return token.accessToken;
        }
    }

    private static class URLBuilder {
        Map<String, String> parameters = new HashMap<String, String>();

        private URLBuilder() {
        }

        String getQuery(boolean encode, String url) throws MalformedURLException, UnsupportedEncodingException {
            int i = 0;
            Object _url = "";
            if (url != null) {
                _url = url;
            }
            for (String key : this.parameters.keySet()) {
                _url = i == 0 && !((String)_url).isEmpty() ? (String)_url + "?" : (String)_url + "&";
                _url = (String)_url + key + "=";
                _url = encode ? (String)_url + URLEncoder.encode(this.parameters.get(key), "UTF-8") : (String)_url + this.parameters.get(key);
                ++i;
            }
            return _url;
        }
    }

    private static class Token {
        String accessToken;
        long expireTime;

        private Token() {
        }
    }
}

