/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.udriver.googlesheets.oauth;

import com.stambia.udriver.googlesheets.oauth.OAuth2Metadata;
import java.util.Objects;

public class OAuth2TokenKey {
    private final String refreshToken;
    private final String clientSecret;
    private final String clientId;
    private final String tokenEndpoint;
    private final String scope;
    private final String authEndpoint;
    private final String redirectEndpoint;
    private final String code;
    private final int numberOfAttempts;
    private final int connectionTimeout;
    private final int readTimeout;

    public OAuth2TokenKey(OAuth2Metadata oAuth2Metadata) {
        this.refreshToken = oAuth2Metadata.refreshToken;
        this.clientSecret = oAuth2Metadata.clientSecret;
        this.clientId = oAuth2Metadata.clientId;
        this.tokenEndpoint = oAuth2Metadata.tokenEndpoint;
        this.readTimeout = oAuth2Metadata.readTimeout;
        this.scope = oAuth2Metadata.scope;
        this.authEndpoint = oAuth2Metadata.authEndpoint;
        this.redirectEndpoint = oAuth2Metadata.redirectEndpoint;
        this.code = oAuth2Metadata.code;
        this.numberOfAttempts = oAuth2Metadata.numberOfAttempts;
        this.connectionTimeout = oAuth2Metadata.connectionTimeout;
    }

    public int hashCode() {
        return Objects.hash(this.authEndpoint, this.clientId, this.clientSecret, this.code, this.connectionTimeout, this.numberOfAttempts, this.readTimeout, this.redirectEndpoint, this.refreshToken, this.scope, this.tokenEndpoint);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OAuth2TokenKey other = (OAuth2TokenKey)obj;
        return Objects.equals(this.authEndpoint, other.authEndpoint) && Objects.equals(this.clientId, other.clientId) && Objects.equals(this.clientSecret, other.clientSecret) && Objects.equals(this.code, other.code) && this.connectionTimeout == other.connectionTimeout && this.numberOfAttempts == other.numberOfAttempts && this.readTimeout == other.readTimeout && Objects.equals(this.redirectEndpoint, other.redirectEndpoint) && Objects.equals(this.refreshToken, other.refreshToken) && Objects.equals(this.scope, other.scope) && Objects.equals(this.tokenEndpoint, other.tokenEndpoint);
    }
}

