/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.udriver.googlesheets.oauth;

import com.stambia.udriver.googlesheets.GSheetsConnection;
import com.stambia.udriver.googlesheets.oauth.Messages;
import com.stambia.udriver.googlesheets.oauth.OAuth2;
import com.stambia.udriver.googlesheets.oauth.OAuth2Metadata;
import com.stambia.udriver.googlesheets.security.EncryptDecrypt;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.util.Map;

public class Oauth2Tool {
    public static void main(String[] args) throws Exception {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        OAuth2Metadata oauth2 = new OAuth2Metadata();
        oauth2.authEndpoint = "https://accounts.google.com/o/oauth2/auth";
        oauth2.tokenEndpoint = "https://accounts.google.com/o/oauth2/token";
        oauth2.redirectEndpoint = "http://localhost:1";
        int scopeType = 2;
        System.out.println(Messages.getString("Oauth2Tool.0"));
        oauth2.clientId = in.readLine();
        System.out.println();
        System.out.println(Messages.getString("Oauth2Tool.1"));
        oauth2.clientSecret = in.readLine();
        System.out.println();
        System.out.println(Messages.getString("Oauth2Tool.2"));
        scopeType = Integer.valueOf(in.readLine());
        System.out.println();
        if (scopeType != 1 && scopeType != 2) {
            System.out.println(Messages.getString("Oauth2Tool.3"));
            System.exit(1);
        }
        if (scopeType == 1) {
            oauth2.scope = "https://spreadsheets.google.com/feeds/ https://www.googleapis.com/auth/drive.readonly";
        } else {
            System.out.println(Messages.getString("Oauth2Tool.4"));
            oauth2.scope = in.readLine();
            System.out.println();
        }
        String url = OAuth2.getAuthEndPointUrl(oauth2);
        System.out.println(Messages.getString("Oauth2Tool.5"));
        System.out.println(url);
        System.out.println();
        System.out.print(Messages.getString("Oauth2Tool.6"));
        oauth2.code = in.readLine();
        System.out.println();
        System.out.println(Messages.getString("Oauth2Tool.7"));
        Map<String, String> ret = OAuth2.getNewToken(oauth2);
        System.out.println();
        System.out.println(Messages.getString("Oauth2Tool.8"));
        oauth2.accessToken = ret.get("access_token");
        System.out.println(oauth2.accessToken);
        System.out.println();
        System.out.println(Messages.getString("Oauth2Tool.9"));
        oauth2.refreshToken = ret.get("refresh_token");
        System.out.println(oauth2.refreshToken);
        System.out.println();
        if (scopeType == 1) {
            System.out.println(Messages.getString("Oauth2Tool.10"));
            GSheetsConnection conn = new GSheetsConnection(null, oauth2);
            System.out.println(Messages.getString("Oauth2Tool.11"));
            System.out.println(Messages.getString("Oauth2Tool.12"));
            String encrypt = EncryptDecrypt.encrypt(oauth2.clientSecret);
            System.out.println(String.format("jdbc:semarchy:google:spreadsheet?oauth2RefreshToken=%s&oauth2ClientId=%s&oauth2EncryptedClientSecret=%s", oauth2.refreshToken, oauth2.clientId, URLEncoder.encode(encrypt, "UTF-8")));
            System.out.println(Messages.getString("Oauth2Tool.13"));
            System.out.println(String.format("jdbc:semarchy:google:spreadsheet?oauth2AccessToken=%s", oauth2.accessToken));
        }
    }
}

