/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.module.classloader;

import com.indy.engine.core.module.classloader.Messages;
import com.indy.engine.core.module.classloader.StambiaClassLoaderRegistry;

public class ClassLoaderServiceProvider {
    public static ClassLoaderServiceProvider INSTANCE = new ClassLoaderServiceProvider();

    private ClassLoaderServiceProvider() {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(ClassLoaderServiceProvider.class.getClassLoader());
                StambiaClassLoaderRegistry stambiaClassLoaderRegistry = StambiaClassLoaderRegistry.INSTANCE;
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        catch (Throwable r) {
            r.printStackTrace();
        }
    }

    public ClassLoader getClassLoader(String classLoaderName) throws ClassLoaderServiceException {
        return StambiaClassLoaderRegistry.INSTANCE.getClassLoader(classLoaderName);
    }

    public ClassLoader getClassLoader(String classLoaderName, String className) throws ClassLoaderServiceException, ClassNotFoundException {
        if (className != null && !className.isEmpty()) {
            ClassLoader cl;
            if (classLoaderName == null || classLoaderName.isEmpty()) {
                cl = this.getClassLoader("default");
                if (!this.hasClass(cl, className) && !this.hasClass(cl = this.getClassLoader("internal"), className)) {
                    throw new ClassLoaderServiceException(String.valueOf(Messages.getString("ClassLoaderServiceProvider.0")) + className + Messages.getString("ClassLoaderServiceProvider.1") + "internal" + Messages.getString("ClassLoaderServiceProvider.2"));
                }
            } else {
                cl = this.getClassLoader(classLoaderName);
                if (!this.hasClass(cl, className)) {
                    throw new ClassLoaderServiceException(String.valueOf(Messages.getString("ClassLoaderServiceProvider.3")) + className + Messages.getString("ClassLoaderServiceProvider.4") + classLoaderName);
                }
            }
            return cl;
        }
        return this.getClassLoader(classLoaderName);
    }

    private boolean hasClass(ClassLoader cl, String className) {
        try {
            cl.loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static class ClassLoaderServiceException
    extends Exception {
        public ClassLoaderServiceException(String message, Throwable cause) {
            super(message, cause);
        }

        public ClassLoaderServiceException(String message) {
            super(message);
        }
    }
}

