/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.module.classloader;

import com.indy.engine.core.module.IModuleService;
import com.indy.engine.core.module.classloader.Messages;
import com.indy.engine.core.module.impl.ModuleServiceImpl;
import com.indy.engine.core.module.utils.StambiaJavaVersion;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DevModuleClassLoaderProvider {
    ClassLoaderLevel root = new ClassLoaderLevel();
    static boolean debug = false;
    Map<String, ClassLoader> map = new HashMap<String, ClassLoader>();
    Map<String, ClassLoaderLevel> map2 = new HashMap<String, ClassLoaderLevel>();
    ClassLoader parentCL;
    private ModuleServiceImpl libService;
    boolean b = false;

    static {
        try {
            debug = System.getProperty("stambia.classpath.debug").equals("true");
        }
        catch (NullPointerException ne) {
            debug = false;
        }
        if (debug) {
            DevModuleClassLoaderProvider.debug("debug mode enable");
        }
    }

    private static void fillStack(File file, List<File> stack) {
        if (file != null) {
            DevModuleClassLoaderProvider.fillStack(file.getParentFile(), stack);
            stack.add(file);
        }
    }

    public void updateLibrary(String name, URL moduleDescriptorURL, Collection<URL> contentURL) {
        if (moduleDescriptorURL != null) {
            try {
                this.libService.addDevModeLib(name, moduleDescriptorURL, contentURL);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String replaceWildCharsWithGroups(String wild) {
        StringBuffer buffer = new StringBuffer();
        char[] chars = wild.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '*') {
                buffer.append("(.*)");
            } else if (chars[i] == '?') {
                buffer.append("(.)");
            } else if ("+()^$.{}[]|\\".indexOf(chars[i]) != -1) {
                buffer.append('\\').append(chars[i]);
            } else {
                buffer.append(chars[i]);
            }
            ++i;
        }
        return buffer.toString();
    }

    private static boolean j11Exclude(File dir) {
        return StambiaJavaVersion.getJavaSpecificationVersion() < 1011 && dir.getName().equals("j11");
    }

    private static void getAllRecursDir(File dir, List<File> list, List<File> excludes) {
        if (!(!dir.isDirectory() || DevModuleClassLoaderProvider.j11Exclude(dir) || excludes != null && excludes.contains(dir))) {
            list.add(dir);
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                DevModuleClassLoaderProvider.getAllRecursDir(child, list, excludes);
                ++n2;
            }
        }
    }

    private static void fillList2(File parentRealFile, Level parentLevel, List<File> list, int index, boolean recursive, List<File> excludes) {
        if (parentRealFile == null) {
            ++index;
            for (Level child : parentLevel.level.values()) {
                DevModuleClassLoaderProvider.fillList2(child.file, child, list, index, recursive, excludes);
            }
            return;
        }
        if (excludes != null && excludes.contains(parentRealFile)) {
            return;
        }
        if (!parentRealFile.exists()) {
            return;
        }
        if (parentLevel.isLeaf) {
            list.add(parentRealFile);
            return;
        }
        if (!parentLevel.isLeaf && parentRealFile.isDirectory()) {
            for (Level childLevel : parentLevel.level.values()) {
                File childRealFile = new File(parentRealFile, childLevel.file.getName());
                String name = childRealFile.getName();
                if (name.equals("**")) {
                    ArrayList<File> allDirs = new ArrayList<File>();
                    DevModuleClassLoaderProvider.getAllRecursDir(parentRealFile, allDirs, excludes);
                    for (File dir : allDirs) {
                        DevModuleClassLoaderProvider.fillList2(dir, childLevel, list, index, true, excludes);
                    }
                    continue;
                }
                if (name.indexOf(42) > -1 || name.indexOf(63) > -1) {
                    String pattern = DevModuleClassLoaderProvider.replaceWildCharsWithGroups(name);
                    File[] fileArray = parentRealFile.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File _file = fileArray[n2];
                        if (_file.getName().matches(pattern)) {
                            DevModuleClassLoaderProvider.fillList2(_file, childLevel, list, index, recursive, excludes);
                        }
                        ++n2;
                    }
                    continue;
                }
                DevModuleClassLoaderProvider.fillList2(childRealFile, childLevel, list, index, recursive, excludes);
            }
        }
    }

    private static void fillRoot(Level root, List<List<File>> stacks) {
        for (List<File> stack : stacks) {
            Level current = root;
            int i = -1;
            for (File fi : stack) {
                Level l;
                ++i;
                String fileName = fi.getName();
                if (fileName.isEmpty()) {
                    fileName = fi.getAbsolutePath();
                }
                if ((l = current.level.get(fileName)) == null) {
                    l = new Level();
                    l.file = fi;
                    if (i + 1 == stack.size()) {
                        l.isLeaf = true;
                    }
                    current.level.put(fileName, l);
                }
                current = l;
            }
        }
    }

    private static List<File> getFile(File parentDir, String ... mask) {
        ArrayList<List<File>> stacks = new ArrayList<List<File>>();
        ArrayList<List<File>> excludes = new ArrayList<List<File>>();
        String[] stringArray = mask;
        int n = mask.length;
        int n2 = 0;
        while (n2 < n) {
            String _mask = stringArray[n2];
            boolean exclude = _mask.startsWith("exclude::");
            if (exclude) {
                _mask = _mask.substring(9);
            }
            ArrayList<File> stack = new ArrayList<File>();
            File f = parentDir != null ? new File(parentDir, _mask) : new File(_mask);
            DevModuleClassLoaderProvider.fillStack(f, stack);
            if (exclude) {
                excludes.add(stack);
            } else {
                stacks.add(stack);
            }
            ++n2;
        }
        Level root = new Level();
        DevModuleClassLoaderProvider.fillRoot(root, stacks);
        Level rootExclude = new Level();
        DevModuleClassLoaderProvider.fillRoot(rootExclude, excludes);
        ArrayList<File> _excludes = new ArrayList<File>();
        DevModuleClassLoaderProvider.fillList2(null, rootExclude, _excludes, -1, false, null);
        ArrayList<File> list = new ArrayList<File>();
        DevModuleClassLoaderProvider.fillList2(null, root, list, -1, false, _excludes);
        return list;
    }

    public DevModuleClassLoaderProvider(ModuleServiceImpl libService, ClassLoader paramClassLoader) throws Exception {
        this.parentCL = paramClassLoader;
        this.libService = libService;
        this.initLoaders();
    }

    public static List<URL> getURL(File parentDir, String ... mask) throws MalformedURLException {
        ArrayList<URL> list = new ArrayList<URL>();
        for (File file : DevModuleClassLoaderProvider.getFile(parentDir, mask)) {
            if (file.getName().equals("indyEngineLauncher.jar")) continue;
            list.add(file.toURI().normalize().toURL());
        }
        return list;
    }

    private void createHierar(String name) {
        String[] split = name.split("\\.");
        ClassLoaderLevel parent = null;
        String path = null;
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            ClassLoaderLevel o = this.map2.get(path = path == null ? n3 : String.valueOf(path) + "." + n3);
            if (o == null) {
                o = new ClassLoaderLevel();
                o.name = path;
                if (parent != null) {
                    o.parent = parent;
                    parent.addChildren(o);
                }
                this.map2.put(o.name, o);
            }
            parent = o;
            ++n2;
        }
    }

    private void initLoaders() throws Exception {
        if (!this.b) {
            DevModuleClassLoaderProvider.debug("parse properties");
            Properties prop = System.getProperties();
            Enumeration<Object> enu = prop.keys();
            while (enu.hasMoreElements()) {
                String value;
                String name;
                Object o = enu.nextElement();
                if (!(o instanceof String) || !((String)o).startsWith("stambia.classpath.v1.") || (name = ((String)o).substring("stambia.classpath.v1.".length())).equals("stambia.classpath.v1.core") || name.equals("stambia.classpath.v1.internal") || (value = System.getProperty((String)o)) == null) continue;
                try {
                    ClassLoaderLevel lvl = new ClassLoaderLevel();
                    lvl.name = name;
                    lvl.paths.addAll(Arrays.asList(value.split(";")));
                    this.map2.put(name, lvl);
                    lvl.computeCl();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new RuntimeException(String.valueOf(Messages.getString("DevModuleClassLoaderProvider.4")) + name + "=" + value, ex);
                }
            }
            if (!this.map2.isEmpty()) {
                ClassLoaderLevel lvl = this.map2.values().iterator().next();
                while (lvl.parent != null) {
                    lvl = lvl.parent;
                }
                lvl.computeCl();
            }
            this.b = true;
        }
    }

    private static void debug(String message) {
        if (debug) {
            System.out.println("StambiaSystemClassLoader: " + message);
        }
    }

    public ClassLoader getClassLoader(String name) {
        ClassLoader cl = this.map.get(name);
        if (cl != null) {
            return cl;
        }
        return null;
    }

    public void appendToClassPathForInstrumentation(String param) {
    }

    class ClassLoaderLevel {
        Set<String> paths = new HashSet<String>();
        String name;
        ClassLoader cl;
        ClassLoaderLevel parent;
        Map<String, ClassLoaderLevel> children = new HashMap<String, ClassLoaderLevel>();
        public File dir;
        boolean compute;
        Map<String, Class> cache = new HashMap<String, Class>();

        ClassLoaderLevel() {
        }

        public String toString() {
            return "ClassLoaderLevel [name=" + this.name + ", paths=" + this.paths + "]";
        }

        public void computeCl() {
            if (!this.compute) {
                block9: {
                    this.compute = true;
                    DevModuleClassLoaderProvider.debug("Compute ClassLoader: " + this.name);
                    ArrayList<URL> list = new ArrayList<URL>();
                    if (this.cl == null && this.paths != null && this.paths.size() > 0) {
                        try {
                            List<URL> _list = DevModuleClassLoaderProvider.getURL(this.dir, this.paths.toArray(new String[this.paths.size()]));
                            list.addAll(_list);
                            DevModuleClassLoaderProvider.debug("Add URLS to ClassLoader: " + this.name + " URLs: " + list);
                            this.cl = this.parent != null ? new LocalClassLoader(this.name, list.toArray(new URL[list.size()]), this.parent.cl) : new LocalClassLoader(this.name, list.toArray(new URL[list.size()]), DevModuleClassLoaderProvider.this.parentCL);
                            if (DevModuleClassLoaderProvider.this.map.get(this.name) == null) {
                                IModuleService.IModule m;
                                DevModuleClassLoaderProvider.this.map.put(this.name, this.cl);
                                if (DevModuleClassLoaderProvider.this.libService != null && (m = DevModuleClassLoaderProvider.this.libService.getModule(this.name)) != null) {
                                    File f = DevModuleClassLoaderProvider.this.libService.getModule(this.name).getInstallationFolder();
                                    DevModuleClassLoaderProvider.this.updateLibrary(this.name, new File(f, "module_descriptor.properties").toURL(), _list);
                                }
                                break block9;
                            }
                            throw new RuntimeException(String.valueOf(Messages.getString("DevModuleClassLoaderProvider.0")) + this.name + Messages.getString("DevModuleClassLoaderProvider.1"));
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    this.cl = this.parent != null ? new LocalClassLoader(this.name, new URL[0], this.parent.cl) : new LocalClassLoader(this.name, new URL[0], DevModuleClassLoaderProvider.this.parentCL);
                    if (DevModuleClassLoaderProvider.this.map.get(this.name) == null) {
                        DevModuleClassLoaderProvider.this.map.put(this.name, this.cl);
                    } else {
                        throw new RuntimeException(String.valueOf(Messages.getString("DevModuleClassLoaderProvider.2")) + this.name + Messages.getString("DevModuleClassLoaderProvider.3"));
                    }
                }
                for (ClassLoaderLevel cll : this.children.values()) {
                    cll.computeCl();
                }
            }
        }

        void addChildren(ClassLoaderLevel cl) {
            cl.parent = this;
            this.children.put(cl.name, cl);
        }

        Enumeration<URL> findResources(String name) throws IOException {
            return ((URLClassLoader)this.cl).findResources(name);
        }

        URL findResource(String name) {
            return ((URLClassLoader)this.cl).findResource(name);
        }

        Class loadClass(String name) throws ClassNotFoundException {
            return this.cl.loadClass(name);
        }
    }

    static class Level {
        Map<String, Level> level = new HashMap<String, Level>();
        File file;
        boolean isLeaf;

        Level() {
        }
    }

    static class LocalClassLoader
    extends URLClassLoader {
        String name;

        public LocalClassLoader(String name, URL[] paramArrayOfURL, ClassLoader paramClassLoader) {
            super(paramArrayOfURL, paramClassLoader);
            this.name = name;
        }

        @Override
        public Class<?> loadClass(String paramString) throws ClassNotFoundException {
            return super.loadClass(paramString);
        }

        public String toString() {
            return this.name;
        }
    }
}

