/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.module.classloader;

import com.indy.engine.core.module.IModuleService;
import com.indy.engine.core.module.classloader.ClassLoaderServiceProvider;
import com.indy.engine.core.module.classloader.DevModuleClassLoaderProvider;
import com.indy.engine.core.module.classloader.Messages;
import com.indy.engine.core.module.configuration.RuntimeConfiguration;
import com.indy.engine.core.module.impl.ModuleServiceImpl;
import com.indy.engine.core.module.utils.StambiaJavaVersion;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public enum StambiaClassLoaderRegistry {
    INSTANCE;

    public static final String CORE = "core";
    static final String PROP_PREFIX = "stambia.classpath.v1.";
    static final String PROP_CORE_CL = "stambia.classpath.v1.core";
    static final String PROP_INTERNAL_CL = "stambia.classpath.v1.internal";
    URLClassLoader nullCL = new URLClassLoader(new URL[0]);
    private ClassLoader mainClassLoader;
    private ClassLoader apiClassLoader;
    private ClassLoader runtimeClassLoader;
    private ModuleServiceImpl moduleService;
    private DevModuleClassLoaderProvider devModuleClassLoaderRegistry;
    private Map<String, ClassLoader> classLoaders = Collections.synchronizedMap(new HashMap());
    private RuntimeConfiguration config;

    private String getRuntimeInstallFolder() {
        String runtimeInstallFolder = System.getProperty("com.indy.engine.installation.folder");
        if (runtimeInstallFolder == null) {
            runtimeInstallFolder = "";
        } else if (!(runtimeInstallFolder = runtimeInstallFolder.replace("\\", "/")).isEmpty() && !runtimeInstallFolder.endsWith("/")) {
            runtimeInstallFolder = String.valueOf(runtimeInstallFolder) + "/";
        }
        return runtimeInstallFolder;
    }

    public List<URL> initializeCoreClassLoader() {
        List<URL> l = null;
        String v = System.getProperty(PROP_CORE_CL);
        List<URL> jythonJarsURLs = null;
        String jythonVersion = null;
        if (this.config != null) {
            jythonVersion = this.config.jythonVersion();
            String runtimeInstallFolder = this.getRuntimeInstallFolder();
            try {
                jythonJarsURLs = DevModuleClassLoaderProvider.getURL(null, String.valueOf(runtimeInstallFolder) + "lib/jython/" + jythonVersion + "/*.jar");
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(Messages.getString("StambiaClassLoaderRegistry.3"), e);
            }
        }
        if (v != null) {
            try {
                l = DevModuleClassLoaderProvider.getURL(null, v.split(";"));
                if (StambiaJavaVersion.getJavaSpecificationVersion() < 1009) {
                    l = this.removeJ11libs(l);
                }
                if (this.config != null && jythonVersion != null && jythonVersion.equals(this.config.defaultJythonVersion())) {
                    l.addAll(jythonJarsURLs);
                }
                this.apiClassLoader = new NamedURLClassLoader(CORE, l.toArray(new URL[l.size()]), this.mainClassLoader);
            }
            catch (Exception ex) {
                throw new RuntimeException(String.valueOf(Messages.getString("StambiaClassLoaderRegistry.4")) + PROP_CORE_CL + "=" + v, ex);
            }
        } else {
            this.apiClassLoader = this.mainClassLoader;
        }
        this.classLoaders.put(CORE, this.apiClassLoader);
        return jythonJarsURLs;
    }

    public void init(RuntimeConfiguration config) {
        if (this.runtimeClassLoader != null) {
            throw new RuntimeException(Messages.getString("StambiaClassLoaderRegistry.2"));
        }
        this.config = config;
        this.mainClassLoader = Thread.currentThread().getContextClassLoader();
        String jythonVersion = config == null ? null : config.jythonVersion();
        List<URL> jythonJarsURLs = this.initializeCoreClassLoader();
        Thread.currentThread().setContextClassLoader(this.apiClassLoader);
        String v = System.getProperty(PROP_INTERNAL_CL);
        if (v != null) {
            List<URL> l = null;
            try {
                l = DevModuleClassLoaderProvider.getURL(null, v.split(";"));
                if (config != null && !jythonVersion.equals(config.defaultJythonVersion())) {
                    l.addAll(jythonJarsURLs);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(String.valueOf(Messages.getString("StambiaClassLoaderRegistry.5")) + PROP_INTERNAL_CL + "=" + v, ex);
            }
            this.runtimeClassLoader = new NamedURLClassLoader("internal", l.toArray(new URL[l.size()]), this.apiClassLoader);
        } else {
            this.runtimeClassLoader = this.mainClassLoader;
        }
        this.classLoaders.put("internal", this.runtimeClassLoader);
    }

    public void setModuleService(ModuleServiceImpl moduleService) throws Exception {
        if (this.runtimeClassLoader == null) {
            throw new RuntimeException(Messages.getString("StambiaClassLoaderRegistry.6"));
        }
        this.moduleService = moduleService;
        try {
            this.devModuleClassLoaderRegistry = new DevModuleClassLoaderProvider(moduleService, this.apiClassLoader);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(Messages.getString("StambiaClassLoaderRegistry.7"), ex);
        }
    }

    private List<URL> removeJ11libs(List<URL> l) {
        Iterator<URL> iterator = l.iterator();
        while (iterator.hasNext()) {
            URL url = iterator.next();
            if (!url.getFile().contains("j11")) continue;
            iterator.remove();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader(String classLoaderName) throws ClassLoaderServiceProvider.ClassLoaderServiceException {
        if (this.runtimeClassLoader == null) {
            throw new RuntimeException(Messages.getString("StambiaClassLoaderRegistry.8"));
        }
        ClassLoader cl = this.classLoaders.get(classLoaderName);
        if (cl == this.nullCL) {
            throw new ClassLoaderServiceProvider.ClassLoaderServiceException(String.valueOf(Messages.getString("StambiaClassLoaderRegistry.9")) + classLoaderName + Messages.getString("StambiaClassLoaderRegistry.10"));
        }
        if (cl != null) {
            return cl;
        }
        Map<String, ClassLoader> map = this.classLoaders;
        synchronized (map) {
            cl = this.classLoaders.get(classLoaderName);
            if (cl == null) {
                IModuleService.IModule lib;
                cl = this.devModuleClassLoaderRegistry.getClassLoader(classLoaderName);
                if (cl == null && (lib = this.moduleService.getModule(classLoaderName)) != null) {
                    try {
                        Collection<URL> urls = lib.getURLs();
                        cl = new NamedURLClassLoader(classLoaderName, urls.toArray(new URL[urls.size()]), this.apiClassLoader);
                        this.classLoaders.put(classLoaderName, cl);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (cl == null) {
                    cl = this.nullCL;
                }
                this.classLoaders.put(classLoaderName, cl);
            }
            if (cl == this.nullCL) {
                throw new ClassLoaderServiceProvider.ClassLoaderServiceException(String.valueOf(Messages.getString("StambiaClassLoaderRegistry.11")) + classLoaderName + Messages.getString("StambiaClassLoaderRegistry.12"));
            }
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean closeClassLoader(String classLoaderName) {
        if (this.runtimeClassLoader == null) {
            throw new RuntimeException(Messages.getString("StambiaClassLoaderRegistry.13"));
        }
        Map<String, ClassLoader> map = this.classLoaders;
        synchronized (map) {
            ClassLoader cl = this.classLoaders.get(classLoaderName);
            if (cl == null) return true;
            if (!(cl instanceof NamedURLClassLoader)) {
                this.classLoaders.remove(classLoaderName);
                return false;
            }
            try {
                if (!CORE.equals(classLoaderName)) {
                    ((NamedURLClassLoader)cl).close();
                }
                this.classLoaders.remove(classLoaderName);
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public IModuleService getModuleService() {
        return this.moduleService;
    }

    public void release() {
        this.runtimeClassLoader = null;
        this.mainClassLoader = null;
        this.apiClassLoader = null;
        this.classLoaders.clear();
    }

    public static class NamedURLClassLoader
    extends URLClassLoader {
        private String name;
        private boolean hasLoadedJNILibs = false;

        public NamedURLClassLoader(String name, URL[] urls, ClassLoader parent) {
            super(urls, parent);
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }

        @Override
        protected String findLibrary(String libname) {
            String s = super.findLibrary(libname);
            if (s == null) {
                URL[] uRLArray = this.getURLs();
                int n = uRLArray.length;
                int n2 = 0;
                while (n2 < n) {
                    URL u = uRLArray[n2];
                    String fName = null;
                    try {
                        fName = URLDecoder.decode(u.toString(), "UTF-8");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        fName = u.toString();
                    }
                    fName = fName.substring(fName.lastIndexOf("/") + 1);
                    if (fName.startsWith(String.valueOf(libname) + ".")) {
                        this.hasLoadedJNILibs = true;
                        try {
                            return URLDecoder.decode(u.getFile(), "UTF-8");
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            return u.getFile();
                        }
                    }
                    ++n2;
                }
            }
            return s;
        }

        @Override
        public void close() throws IOException {
            Object cl = null;
            if (this.hasLoadedJNILibs) {
                throw new IOException(String.valueOf(Messages.getString("StambiaClassLoaderRegistry.0")) + this.getName() + Messages.getString("StambiaClassLoaderRegistry.1"));
            }
            super.close();
        }
    }
}

