/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.module.impl;

import com.indy.engine.core.module.IModuleService;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;

public class InternalModule
implements IModuleService.IModule,
IModuleService.IModuleDescriptor,
IModuleService.IBaseModuleInfo {
    private Collection<URL> contentURL = null;
    private Collection<String> internalFileNames = null;
    private String moduleName;

    public InternalModule(String moduleName, File ... runtimeFolder) throws Exception {
        this.moduleName = moduleName;
        HashSet contentURL = new HashSet();
        HashSet internalFileNames = new HashSet();
        Arrays.stream(runtimeFolder).forEach(f -> {
            try {
                contentURL.add(f.toURI().toURL());
                internalFileNames.add(f.getName());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        });
        this.contentURL = Collections.unmodifiableSet(contentURL);
        this.internalFileNames = Collections.unmodifiableSet(internalFileNames);
    }

    @Override
    public String getName() {
        return this.moduleName;
    }

    @Override
    public Collection<URL> getURLs() throws Exception {
        return this.contentURL;
    }

    @Override
    public IModuleService.IModuleDescriptor getDescriptor() {
        return this;
    }

    @Override
    public File getInstallationFolder() {
        return null;
    }

    @Override
    public IModuleService.IBaseModuleInfo getBaseModuleInfo() {
        return this;
    }

    @Override
    public Properties getModuleProperties() {
        return new Properties();
    }

    @Override
    public String getModuleName() {
        return this.getName();
    }

    @Override
    public Collection<String> getFileNames() {
        return this.internalFileNames;
    }

    @Override
    public IModuleService.IBaseModuleInfo getBaseModuleExtensionInfo() {
        return null;
    }

    @Override
    public String getBundleProviderId() {
        return "com.indy.engine.core.module";
    }

    @Override
    public String getBundleProviderVersion() {
        return "1.0.0";
    }

    @Override
    public Integer getVersion() {
        return 1;
    }

    @Override
    public String getId() {
        return "com.indy.baseModule.generic";
    }

    @Override
    public String getComponentBundle() {
        return null;
    }
}

