/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.sql.editors;

import com.indy.ui.custom.out.Activator;
import com.indy.ui.sql.IConnectionProvider;
import com.indy.ui.sql.editors.Messages;
import com.stambia.md.MdNode;
import java.sql.Connection;
import java.sql.SQLException;
import javax.inject.Inject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;

class Controler {
    @Inject
    private IConnectionProvider connectionManager;
    private MdNode serverNode;
    private Connection connection;
    private Bean datas;

    Controler(MdNode serverNode) {
        this.serverNode = serverNode;
        IEclipseContext ctx = EclipseContextFactory.getServiceContext((BundleContext)Activator.getDefault().getBundle().getBundleContext());
        ContextInjectionFactory.inject((Object)this, (IEclipseContext)ctx);
        this.datas = new Bean();
    }

    public void changeAutocommit() {
        this.datas.autocommit = !this.datas.autocommit;
        this.dispose();
    }

    public void setMaxRows(int max) {
        this.datas.maxRows = max;
    }

    public void dispose() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.connection = null;
        }
    }

    Connection getConnection(boolean autocommit) throws Exception {
        if (this.connection == null || this.connection.isClosed()) {
            IConnectionProvider.IConnectionDescriptor desc = this.connectionManager.getConnectionDescriptor(this.serverNode);
            this.connection = this.connectionManager.createJDBCConnection(desc);
            try {
                this.connection.setAutoCommit(autocommit);
            }
            catch (Exception ex) {
                StatusManager.getManager().handle((IStatus)new Status(2, "com.indy.ui.sql", Messages.Controler_0, (Throwable)ex), 1);
            }
        } else {
            boolean wasAutocommit = false;
            try {
                wasAutocommit = this.connection.getAutoCommit();
                if (wasAutocommit != autocommit) {
                    this.connection.close();
                    this.connection = null;
                    return this.getConnection(autocommit);
                }
            }
            catch (Exception ex) {
                this.connection.close();
                this.connection = null;
                return this.getConnection(autocommit);
            }
        }
        return this.connection;
    }

    public boolean isAutocommit() {
        return this.datas.autocommit;
    }

    public int getMaxRows() {
        return this.datas.maxRows;
    }

    class Bean {
        private boolean autocommit = true;
        private int maxRows = 100;

        Bean() {
        }
    }
}

