/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.sql.editors;

import com.indy.engine.common.sql.SqlUtils;
import com.indy.ui.sql.IResultModel;
import com.indy.ui.sql.ISQLDictionary;
import com.indy.ui.sql.ISQLEditorInput;
import com.indy.ui.sql.SQLDictionary;
import com.indy.ui.sql.editors.Controler;
import com.indy.ui.sql.editors.Messages;
import com.indy.ui.sql.editors.QueryBuilder;
import com.indy.ui.sql.editors.QueryExecutor;
import com.indy.ui.sql.editors.ResultUI;
import com.indy.ui.sql.editors.SQLTextViewerConfiguration;
import com.indy.ui.sql.internal.Activator;
import com.indy.ui.sql.internal.ITransactionalModeManager;
import com.indy.ui.sql.internal.QueryResult;
import com.stambia.md.MdNode;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class SQLEditor
extends EditorPart
implements ITransactionalModeManager.ITransactionalModeListener {
    public static final String CONTEXT_ID = "com.indy.ui.sql.SQLEditorContext";
    static Font font = new Font((Device)Display.getCurrent(), new FontData("Courier New", 10, 0));
    static ImageDescriptor IMG_RUN;
    private SourceViewer fSourceViewer;
    private ResultUI resultUI;
    private Controler controler;
    private EditorContribution mainContribution;

    static {
        try {
            IMG_RUN = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.debug.ui/icons/full/etool16/run_exc.png"));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void executeSQL() {
        this.mainContribution.executeSQL();
    }

    public IResultModel getResultModel() {
        return this.resultUI.getResultModel();
    }

    public void createPartControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        ToolBar toolbar = this.createToolbar(main);
        toolbar.setLayoutData((Object)new GridData(4, 1, true, false));
        SashForm sash = new SashForm(main, 512);
        sash.setLayout((Layout)new FillLayout());
        sash.setLayoutData((Object)new GridData(1808));
        this.createViewer((Composite)sash);
        this.configureViewer();
        this.resultUI = new ResultUI();
        this.resultUI.createUI((Composite)sash);
        sash.setWeights(new int[]{50, 50});
        try {
            ((IContextService)this.getSite().getService(IContextService.class)).activateContext(CONTEXT_ID);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setFocus() {
        this.fSourceViewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.controler != null) {
            this.controler.dispose();
        }
        super.dispose();
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (input instanceof IAdaptable) {
            this.controler = new Controler((MdNode)input.getAdapter(MdNode.class));
        }
        this.setPartName(input.getName());
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == ITransactionalModeManager.ITransactionalModeListener.class) {
            return adapter.cast(this);
        }
        return (T)super.getAdapter(adapter);
    }

    private ToolBar createToolbar(Composite main) {
        ToolBarManager tbm = new ToolBarManager();
        tbm.setStyle(131392);
        this.mainContribution = new EditorContribution(String.valueOf(SQLEditor.class.getName()) + ".maxRows");
        this.mainContribution.fillToolbar(tbm);
        tbm.add((IContributionItem)this.mainContribution);
        return tbm.createControl(main);
    }

    private void createViewer(Composite parent) {
        CompositeRuler ruler = new CompositeRuler();
        ruler.addDecorator(0, (IVerticalRulerColumn)new AnnotationRulerColumn(0));
        DefaultMarkerAnnotationAccess access = new DefaultMarkerAnnotationAccess();
        LineNumberRulerColumn lineNumberRuler = new LineNumberRulerColumn();
        lineNumberRuler.setForeground(Display.getCurrent().getSystemColor(15));
        ruler.addDecorator(1, (IVerticalRulerColumn)lineNumberRuler);
        OverviewRuler overviewRuler = new OverviewRuler((IAnnotationAccess)access, 12, EditorsPlugin.getDefault().getSharedTextColors());
        this.fSourceViewer = new SourceViewer(parent, (IVerticalRuler)ruler, (IOverviewRuler)overviewRuler, true, 2818);
        this.fSourceViewer.getTextWidget().setFont(font);
    }

    private void configureViewer() {
        ISQLDictionary dictionary = null;
        Document doc = new Document();
        if (this.getEditorInput() instanceof ISQLEditorInput) {
            dictionary = ((ISQLEditorInput)this.getEditorInput()).getDictionary();
            doc.set(((ISQLEditorInput)this.getEditorInput()).getSQL());
        } else {
            dictionary = new SQLDictionary();
        }
        SQLTextViewerConfiguration conf = new SQLTextViewerConfiguration(dictionary);
        doc.setDocumentPartitioner(conf.getPartitioner());
        conf.getPartitioner().connect((IDocument)doc);
        this.fSourceViewer.configure((SourceViewerConfiguration)conf);
        this.fSourceViewer.setDocument((IDocument)doc);
        TextViewerUndoManager undoManager = new TextViewerUndoManager(50);
        undoManager.connect((ITextViewer)this.fSourceViewer);
        UndoActionHandler undoAction = new UndoActionHandler(this.getSite(), undoManager.getUndoContext());
        undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
        this.getEditorSite().getActionBars().setGlobalActionHandler(ITextEditorActionConstants.UNDO, (IAction)undoAction);
        RedoActionHandler redoAction = new RedoActionHandler(this.getSite(), undoManager.getUndoContext());
        redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
        this.getEditorSite().getActionBars().setGlobalActionHandler(ITextEditorActionConstants.REDO, (IAction)redoAction);
        this.fSourceViewer.getTextWidget().setCaretOffset(this.fSourceViewer.getTextWidget().getText().length());
    }

    @Override
    public void handleEnablementExecution(boolean enabled) {
        this.mainContribution.setEnabled(enabled);
    }

    private class EditorContribution
    extends ControlContribution {
        private boolean enabledLimit;
        private int max;
        private Composite control;
        private boolean enabled;
        Action executeAction;

        protected EditorContribution(String id) {
            super(id);
            this.enabledLimit = true;
            this.max = 100;
            this.enabled = true;
        }

        public void fillToolbar(ToolBarManager mgr) {
            this.executeAction = new Action(Messages.SQLEditor_0){

                public void run() {
                    Point selection = SQLEditor.this.fSourceViewer.getSelectedRange();
                    String toExecute = SQLEditor.this.fSourceViewer.getDocument().get();
                    if (selection.y > 0) {
                        toExecute = toExecute.substring(selection.x, selection.x + selection.y);
                    }
                    if (SQLEditor.this.controler.getMaxRows() == -1 && !MessageDialog.openQuestion((Shell)SQLEditor.this.getSite().getShell(), (String)Messages.SQLEditor_1, (String)Messages.SQLEditor_2)) {
                        return;
                    }
                    ExecuteSQLJob job = new ExecuteSQLJob(toExecute);
                    job.schedule();
                }
            };
            this.executeAction.setToolTipText(Messages.SQLEditor_3);
            this.executeAction.setImageDescriptor(IMG_RUN);
            ActionContributionItem openViewItem = new ActionContributionItem((IAction)this.executeAction);
            openViewItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
            mgr.add((IContributionItem)openViewItem);
        }

        private void warnAboutTransaction(Event e) {
            if (e.button == 1) {
                if (((Button)e.widget).getSelection()) {
                    if (!MessageDialog.openQuestion((Shell)e.display.getActiveShell(), (String)Messages.SQLEditor_4, (String)Messages.SQLEditor_5)) {
                        e.doit = false;
                        return;
                    }
                    ((Button)e.widget).setSelection(false);
                }
                SQLEditor.this.controler.changeAutocommit();
                Activator.getInstance().getTransactionalModeManager().enableTransactionalModeState((ISQLEditorInput)SQLEditor.this.getEditorInput(), !SQLEditor.this.controler.isAutocommit());
            }
        }

        protected Control createControl(Composite parent) {
            GridData gd = null;
            GridLayout gl = null;
            Composite main = new Composite(parent, 0);
            gl = new GridLayout(3, false);
            main.setLayout((Layout)gl);
            gl.verticalSpacing = 0;
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            gl.marginTop = 0;
            gl.marginBottom = 0;
            gl.marginRight = 5;
            gl.marginLeft = 5;
            gl.horizontalSpacing = 5;
            gl.verticalSpacing = 0;
            gd = new GridData(4, 3, true, false);
            main.setLayoutData((Object)gd);
            gd.verticalIndent = 0;
            gd.horizontalIndent = 0;
            Button autocommit = new Button(main, 32);
            autocommit.setText(Messages.SQLEditor_6);
            autocommit.setLayoutData((Object)new GridData());
            autocommit.addListener(3, e -> this.warnAboutTransaction(e));
            autocommit.setSelection(SQLEditor.this.controler.isAutocommit());
            Button b = new Button(main, 32);
            b.setText(Messages.SQLEditor_7);
            b.setLayoutData((Object)new GridData());
            b.setSelection(true);
            final Text limit = new Text(main, 2048);
            gd = new GridData(4, 1, true, false);
            limit.setLayoutData((Object)gd);
            gd.minimumWidth = 80;
            limit.setText(String.valueOf(this.max));
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditorContribution.this.enabledLimit = !EditorContribution.this.enabledLimit;
                    limit.setEnabled(EditorContribution.this.enabledLimit);
                    if (!EditorContribution.this.enabledLimit) {
                        SQLEditor.this.controler.setMaxRows(-1);
                    } else {
                        SQLEditor.this.controler.setMaxRows(EditorContribution.this.max);
                    }
                }
            });
            limit.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    try {
                        EditorContribution.this.max = Integer.valueOf(limit.getText());
                        SQLEditor.this.controler.setMaxRows(EditorContribution.this.max);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            ITransactionalModeManager.TransactionalModeStatus status = Activator.getInstance().getTransactionalModeManager().getTransactionalModeStatus((ISQLEditorInput)SQLEditor.this.getEditorInput());
            this.enabled = !status.isTransactionModeActive() || status.isCurrentTransaction();
            this.control = main;
            Stream.of(this.control.getChildren()).forEach(c -> c.setEnabled(this.enabled));
            this.executeAction.setEnabled(this.enabled);
            return main;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            Stream.of(this.control.getChildren()).forEach(c -> c.setEnabled(this.enabled));
            this.executeAction.setEnabled(this.enabled);
        }

        public void executeSQL() {
            this.executeAction.run();
        }
    }

    private class ExecuteSQLJob
    extends Job {
        private String sql;
        private QueryExecutor executor;

        public ExecuteSQLJob(String sql) {
            super(Messages.SQLEditor_9);
            this.sql = sql;
            this.executor = new QueryExecutor();
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                List queries = SqlUtils.splitSqlScript((String)this.sql, (String)";", (String[])new String[]{"--|\n", "/\\*|\\*/", "'"});
                if (queries.isEmpty()) {
                    queries.add(this.sql);
                }
                AtomicReference<IResultModel> m = new AtomicReference<IResultModel>();
                monitor.beginTask(Messages.SQLEditor_14, queries.size());
                for (String sql : queries) {
                    QueryExecutor.IQuery currentQuery = new QueryBuilder().buildQuery(sql);
                    if (monitor.isCanceled()) break;
                    try {
                        m.set(this.executor.executeQuery(SQLEditor.this.controler.getConnection(SQLEditor.this.controler.isAutocommit()), currentQuery, SQLEditor.this.controler.getMaxRows()));
                    }
                    catch (Throwable e) {
                        m.set(new QueryResult(currentQuery.getSQL(), e));
                    }
                    monitor.worked(1);
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                SQLEditor.this.getSite().getShell().getDisplay().asyncExec(() -> SQLEditor.this.resultUI.setData((IResultModel)m.get()));
                monitor.done();
                return Status.OK_STATUS;
            }
            catch (Exception ex) {
                return new Status(4, "com.indy.ui.sql", Messages.SQLEditor_15, (Throwable)ex);
            }
        }

        protected void canceling() {
            super.canceling();
            try {
                this.executor.cancel();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

