/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.sql.internal;

import com.indy.ui.sql.ISQLEditorInput;
import com.indy.ui.sql.editors.SQLEditor;
import com.indy.ui.sql.internal.ITransactionalModeManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class TransactionalModeHandler
implements IPartListener,
ITransactionalModeManager {
    private Map<String, ConnectionInfo> editorPerConnections = new HashMap<String, ConnectionInfo>();
    private IPartService partService;
    private Map<ISQLEditorInput, ITransactionalModeManager.ITransactionalModeListener> listeners = new HashMap<ISQLEditorInput, ITransactionalModeManager.ITransactionalModeListener>();

    public TransactionalModeHandler() {
        this.partService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService();
    }

    public void activate() {
        this.partService.addPartListener((IPartListener)this);
    }

    public void deactivate() {
        this.partService.removePartListener((IPartListener)this);
    }

    private ConnectionInfo getEditors(String connectionId) {
        ConnectionInfo editors = this.editorPerConnections.get(connectionId);
        if (editors == null) {
            editors = new ConnectionInfo();
            this.editorPerConnections.put(connectionId, editors);
        }
        return editors;
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        IEditorInput input;
        if (part instanceof SQLEditor && (input = ((SQLEditor)part).getEditorInput()) instanceof ISQLEditorInput) {
            ConnectionInfo info = this.getEditors(((ISQLEditorInput)input).getConnectionId());
            info.remove((ISQLEditorInput)input);
            this.listeners.remove(input);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        IEditorInput input;
        if (part instanceof SQLEditor && (input = ((SQLEditor)part).getEditorInput()) instanceof ISQLEditorInput) {
            ConnectionInfo info = this.getEditors(((ISQLEditorInput)input).getConnectionId());
            info.inputs.add((ISQLEditorInput)input);
            ITransactionalModeManager.ITransactionalModeListener l = (ITransactionalModeManager.ITransactionalModeListener)part.getAdapter(ITransactionalModeManager.ITransactionalModeListener.class);
            if (l != null) {
                this.listeners.put((ISQLEditorInput)input, l);
            }
        }
    }

    @Override
    public void enableTransactionalModeState(ISQLEditorInput input, boolean enable) {
        ConnectionInfo info = this.getEditors(input.getConnectionId());
        if (enable) {
            info.setCurrent(input);
        } else {
            info.setCurrent(null);
        }
    }

    @Override
    public ITransactionalModeManager.TransactionalModeStatus getTransactionalModeStatus(ISQLEditorInput input) {
        ConnectionInfo info = this.getEditors(input.getConnectionId());
        return new ITransactionalModeManager.TransactionalModeStatus(info.currentActiveTransaction != null, info.currentActiveTransaction == input);
    }

    private class ConnectionInfo {
        Set<ISQLEditorInput> inputs = new HashSet<ISQLEditorInput>();
        ISQLEditorInput currentActiveTransaction = null;

        private ConnectionInfo() {
        }

        public void setCurrent(ISQLEditorInput current) {
            this.currentActiveTransaction = current;
            for (ISQLEditorInput in : TransactionalModeHandler.this.listeners.keySet()) {
                boolean enabled = current == null || current == in;
                ((ITransactionalModeManager.ITransactionalModeListener)TransactionalModeHandler.this.listeners.get(in)).handleEnablementExecution(enabled);
            }
        }

        public void remove(ISQLEditorInput input) {
            this.inputs.remove(input);
            if (input == this.currentActiveTransaction) {
                this.setCurrent(null);
            }
            if (this.inputs.isEmpty()) {
                TransactionalModeHandler.this.editorPerConnections.remove(input.getConnectionId());
            }
        }
    }
}

