/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine;

import com.indy.engine.core.common.objects2.IVariable;
import java.util.Map;

public class ClientVariable
implements IVariable {
    private String name = null;
    private String value = null;
    private String type = null;
    private boolean realTimeReport = false;
    private String source = null;
    private Object cumulativeValue = null;
    private long longValue;
    private long precLongValue;
    private String shortName;
    private String actionName;
    private String oldValue;
    boolean isCumulative = false;
    boolean toUpdate = false;

    public long getLongValue() {
        return this.longValue;
    }

    public ClientVariable(Map<String, Object> map) {
        this.cumulativeValue = map.get("cumulativeValue");
        this.name = (String)map.get("name");
        this.realTimeReport = (Boolean)map.get("realTimeReport");
        this.source = (String)map.get("source");
        this.type = (String)map.get("type");
        this.value = (String)map.get("value");
    }

    public ClientVariable() {
        this.realTimeReport = false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public Object getTypedValue() {
        try {
            if (this.getType().equals("Integer")) {
                return Integer.valueOf(this.value);
            }
            if (this.getType().equals("Long")) {
                return Long.valueOf(this.value);
            }
            if (this.getType().equals("Float")) {
                return Double.valueOf(this.value);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void cumulValue() {
        if (this.value != null) {
            try {
                if (this.cumulativeValue == null) {
                    if (this.type.equals("Integer")) {
                        this.cumulativeValue = Integer.valueOf(this.value);
                    } else if (this.type.equals("Long")) {
                        this.cumulativeValue = Long.valueOf(this.value);
                    } else if (this.type.equals("Float")) {
                        this.cumulativeValue = Double.valueOf(this.value);
                    }
                } else if (this.type.equals("Integer")) {
                    this.cumulativeValue = (Integer)this.cumulativeValue + Integer.valueOf(this.value);
                } else if (this.type.equals("Long")) {
                    this.cumulativeValue = (Long)this.cumulativeValue + Long.valueOf(this.value);
                } else if (this.type.equals("Float")) {
                    this.cumulativeValue = (Double)this.cumulativeValue + Double.valueOf(this.value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setValue(String pValue, boolean cumulative) {
        this.isCumulative = cumulative;
        this.setValue(pValue);
    }

    public void setValue(String pValue) {
        this.source = pValue;
        this.setValueOnly(pValue);
    }

    public void setValueOnly(String pValue) {
        this.value = pValue;
        if (this.isCumulative) {
            this.cumulValue();
        }
        this.setLongValue();
    }

    private void setLongValue() {
        if (this.isNumeric()) {
            this.precLongValue = this.longValue;
            this.longValue = this.getLongvalue();
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isRealTimeReport() {
        return this.realTimeReport;
    }

    public void setRealTimeReport(boolean realTimeReport) {
        this.realTimeReport = realTimeReport;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Object getCumulativeValue() {
        return this.cumulativeValue;
    }

    public void setValue(String lastValue, Object cumulativeValue) {
        if (cumulativeValue == null) {
            this.setValue(lastValue);
        } else {
            this.isCumulative = true;
            this.source = lastValue;
            this.value = lastValue;
            this.cumulativeValue = cumulativeValue;
            this.setLongValue();
        }
    }

    public void clear() throws Exception {
        this.name = null;
        this.value = null;
        this.type = null;
        this.source = null;
        this.cumulativeValue = null;
        this.shortName = null;
        this.actionName = null;
    }

    public String toString() {
        String ret = null;
        ret = "Variable : \tName:" + this.name + "\n" + "\tValue:" + this.value + "\n" + "\tType:" + this.type + "\n";
        return ret;
    }

    public static IVariable getVariable(Map<String, Object> map) {
        if (map != null) {
            return new ClientVariable(map);
        }
        return null;
    }

    public String getShortName() {
        if (this.shortName == null) {
            int index = this.name.lastIndexOf(47);
            this.shortName = index > -1 ? this.name.substring(index + 1) : this.name;
        }
        return this.shortName;
    }

    public String getActionName() {
        int index;
        if (this.actionName == null && (index = this.getName().lastIndexOf(47)) > -1) {
            this.actionName = this.getName().substring(0, index);
        }
        return this.actionName;
    }

    public boolean isCore() {
        return this.getShortName().startsWith("CORE_");
    }

    public boolean isNumeric() {
        return this.getType() != null && (this.getType().equals("Integer") || this.getType().equals("Long"));
    }

    private long getLongvalue() {
        if (this.value != null) {
            Object value = null;
            if (this.isCumulative) {
                try {
                    value = this.getCumulativeValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (value == null) {
                value = this.getTypedValue();
            }
            if (value != null) {
                if (this.getType().equals("Integer")) {
                    return ((Integer)value).longValue();
                }
                if (this.getType().equals("Long")) {
                    return (Long)value;
                }
            }
        }
        return 0L;
    }

    public Map<String, Object> toMap() {
        return null;
    }
}

