/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine;

import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.common.FunctionType;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.core.common.objects2.ActionDataExchange;
import com.indy.engine.core.common.objects2.IActionDataExchange;
import com.indy.engine.core.common.objects2.IIdDataExchange;
import com.indy.engine.core.common.objects2.ISessionDataExchange;
import com.indy.engine.core.common.objects2.IVariable;
import com.indy.engine.core.common.objects2.SessionDataExchange;
import com.indy.ui.custom.out.services.IEngineConnection;
import com.indy.ui.engine.Messages;
import com.indy.ui.engine.session.SessionsMonitorState;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EngineServerWrapper
implements IEngineConnection {
    public static final String _JVM = Messages.EngineServerWrapper_0;
    public static final String _JVM_UPTIME = Messages.EngineServerWrapper_1;
    public static final String _JVM_VENDOR = Messages.EngineServerWrapper_2;
    public static final String _JVM_CPU_TIME = Messages.EngineServerWrapper_3;
    public static final String _JVM_NAME = Messages.EngineServerWrapper_4;
    public static final String _JVM_COMPILER = Messages.EngineServerWrapper_5;
    public static final String _JVM_COMPILE_TIME = Messages.EngineServerWrapper_6;
    public static final String _JVM_THREADS_LIVE = Messages.EngineServerWrapper_7;
    public static final String _JVM_THREADS_STARTED = Messages.EngineServerWrapper_8;
    public static final String _JVM_THREADS_PEAK = Messages.EngineServerWrapper_9;
    public static final String _JVM_THREADS_DEAMON = Messages.EngineServerWrapper_10;
    public static final String _JVM_CLASSES_TOTAL_LOADED = Messages.EngineServerWrapper_11;
    public static final String _JVM_CLASSES_CURRENT_LOADED = Messages.EngineServerWrapper_12;
    public static final String _JVM_CURRENT_HEAP = Messages.EngineServerWrapper_13;
    public static final String _JVM_COMMITED_MEMORY = Messages.EngineServerWrapper_14;
    public static final String _JVM_MAXIMUM_HEAP = Messages.EngineServerWrapper_15;
    public static final String _JVM_PENDING_FINALIZATION = Messages.EngineServerWrapper_16;
    public static final String _JVM_GC_1 = Messages.EngineServerWrapper_17;
    public static final String _JVM_GC_2 = Messages.EngineServerWrapper_18;
    public static final String _OS = Messages.EngineServerWrapper_19;
    public static final String _OS_COMMITED_VIRTUAL_MEMORY = Messages.EngineServerWrapper_20;
    public static final String _SYSTEM_ACRHITECTURE = Messages.EngineServerWrapper_21;
    public static final String _SYSTEM_TOTAL_MEMORY = Messages.EngineServerWrapper_22;
    public static final String _SYSTEM_PROCESSORS = Messages.EngineServerWrapper_23;
    public static final String _SYSTEM_FREE_MEMORY = Messages.EngineServerWrapper_24;
    public static final String _SYSTEM_FREE_SWAP_MEMORY = Messages.EngineServerWrapper_25;
    public static final String _SYSTEM_TOTAL_SWAP = Messages.EngineServerWrapper_26;
    public static final String[] _OS_INFOS = new String[]{_OS, _OS_COMMITED_VIRTUAL_MEMORY};
    public static final String[] _SYSTEM_INFOS = new String[]{_SYSTEM_ACRHITECTURE, _SYSTEM_TOTAL_MEMORY, _SYSTEM_PROCESSORS, _SYSTEM_FREE_MEMORY, _SYSTEM_FREE_SWAP_MEMORY, _SYSTEM_TOTAL_SWAP};
    public static final String[] _JVM_INFOS = new String[]{_JVM, _JVM_UPTIME, _JVM_VENDOR, _JVM_CPU_TIME, _JVM_NAME, _JVM_COMPILER, _JVM_COMPILE_TIME, _JVM_THREADS_LIVE, _JVM_THREADS_STARTED, _JVM_THREADS_PEAK, _JVM_THREADS_DEAMON, _JVM_CLASSES_TOTAL_LOADED, _JVM_CLASSES_CURRENT_LOADED, _JVM_CURRENT_HEAP, _JVM_COMMITED_MEMORY, _JVM_MAXIMUM_HEAP, _JVM_PENDING_FINALIZATION, _JVM_GC_1, _JVM_GC_2};
    IEngineClient engine;
    Map<String, SessionCached> cache = new HashMap<String, SessionCached>();
    private long lastSessionGatheringDuration = -1L;
    private Date lastSessionGatheringDate = null;
    private Collection<Map<String, Object>> lastSessionGatheredDatas = null;
    private String engineVersion;
    ActionCached EMPTY_ACTION_CACHED = new ActionCached((IActionDataExchange)new ActionDataExchange());

    public EngineServerWrapper(IEngineClient _engine) {
        this.engine = _engine;
        SessionsMonitorState.getInstance().setSessionTimeTooLong(false);
    }

    public Collection<Map<String, Object>> aggregateVariables(String sessionId, String actionId, List<String> variableName, int function) throws Exception {
        Collection<Map<String, Object>> col;
        long l = System.currentTimeMillis();
        ActionCached action = this.getActionCachedById(sessionId, actionId);
        if (action == this.EMPTY_ACTION_CACHED) {
            return null;
        }
        String name = String.valueOf(function) + ":" + variableName;
        if (action != null && (col = action.statistic.get(String.valueOf(function))) != null) {
            return col;
        }
        Map var = this.engine.aggregateVariables(sessionId, actionId, variableName, function, "./");
        if (action != null) {
            if (var == null) {
                action.statistic.put(String.valueOf(function), Collections.EMPTY_LIST);
            } else {
                action.statistic.put(String.valueOf(function), var.values());
            }
        }
        if (var != null) {
            return var.values();
        }
        return null;
    }

    public int deleteSession(String sessionId) throws Exception {
        return this.engine.deleteSession(sessionId);
    }

    public int executeSession(String sessionId) throws Exception {
        return this.engine.executeSession(sessionId);
    }

    public String getActionId(String sessionId, String name) throws Exception {
        ActionCached action = this.getActionCachedByName(sessionId, name);
        if (action != null && action.action != null) {
            return action.action.getId();
        }
        long l = System.currentTimeMillis();
        String ret = this.engine.getActionId(sessionId, name);
        return ret;
    }

    private ActionCached getActionCachedById(String sessionId, String actionId) throws Exception {
        SessionCached sess = this.cache.get(sessionId);
        if (sess != null) {
            ActionCached action = sess.actionsById.get(actionId);
            if (action != null) {
                return action;
            }
            Map obj = this.engine.getActionInfo(sessionId, actionId);
            ActionDataExchange _action = obj != null ? new ActionDataExchange(obj) : null;
            action = _action == null ? this.EMPTY_ACTION_CACHED : new ActionCached((IActionDataExchange)_action);
            sess.putAction(action, actionId);
            return action;
        }
        return null;
    }

    public String getActionGeneratedCode(String sessionId, String actionId) throws Exception {
        ActionCached _action = this.getActionCachedById(sessionId, actionId);
        if (_action == this.EMPTY_ACTION_CACHED) {
            return null;
        }
        if (_action != null && _action.generatedCode != null) {
            return _action.generatedCode;
        }
        String tmp = this.engine.getActionCode(sessionId, actionId);
        if (_action != null) {
            _action.generatedCode = tmp == null ? "" : tmp;
            return _action.generatedCode;
        }
        return tmp;
    }

    private ActionCached getActionCachedByName(String sessionId, String name) throws Exception {
        ActionCached action;
        SessionCached sess = this.cache.get(sessionId);
        if (sess != null && (action = sess.actionsByName.get(name)) != null) {
            return action;
        }
        return null;
    }

    public Map<String, IIdDataExchange> getActionAltId(String sessionId, String actionId) throws Exception, NumberFormatException {
        ActionCached _action = this.getActionCachedById(sessionId, actionId);
        if (_action != null && _action.altIdsIsSet) {
            return _action.altIds;
        }
        Map altIds = null;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("sessionId", sessionId);
        parameters.put("actionId", actionId);
        parameters.put("getAltIds", Boolean.TRUE);
        try {
            ActionDataExchange ade = new ActionDataExchange(this.engine.getActionInfo(parameters));
            altIds = ade.getAltIds();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (_action != null) {
            _action.altIdsIsSet = true;
            _action.altIds = altIds;
        }
        return altIds;
    }

    public IActionDataExchange getActionInfo(String sessionId, String actionId) throws Exception {
        ActionCached _action = this.getActionCachedById(sessionId, actionId);
        if (_action != null) {
            return _action.action;
        }
        long l = System.currentTimeMillis();
        Map obj = this.engine.getActionInfo(sessionId, actionId);
        ActionDataExchange action = obj != null ? new ActionDataExchange(obj) : null;
        return action;
    }

    public Map<String, Map<String, Object>> getActionLstVariables(String sessionId, String actionId) throws Exception {
        ActionCached action = this.getActionCachedById(sessionId, actionId);
        if (action == this.EMPTY_ACTION_CACHED) {
            return null;
        }
        if (action != null && action.variables != null) {
            return action.variables;
        }
        long l = System.currentTimeMillis();
        Map variables = this.engine.getActionLstVariables(sessionId, actionId);
        if (action != null) {
            action.variables = variables;
        }
        return variables;
    }

    public int getActionStatus(String sessionId, String actionId) throws Exception {
        ActionCached action = this.getActionCachedById(sessionId, actionId);
        if (action == this.EMPTY_ACTION_CACHED) {
            return -6000;
        }
        if (action != null && action.action != null) {
            return action.action.getState();
        }
        long l = System.currentTimeMillis();
        int ret = this.engine.getActionStatus(sessionId, actionId);
        return ret;
    }

    public String getApiVersion() throws Exception {
        return this.engine.getApiVersion();
    }

    public String getSchedulerVersion() throws Exception {
        return (String)this.engine.getVersion().get("scheduler");
    }

    public String getCommonVersion() throws Exception {
        return (String)this.engine.getVersion().get("common");
    }

    public String getActionVersion() throws Exception {
        return (String)this.engine.getVersion().get("action");
    }

    public String getEngineVersion() throws Exception {
        if (this.engineVersion == null) {
            this.engineVersion = (String)this.engine.getVersion().get("branding.engine");
            if (this.engineVersion == null) {
                this.engineVersion = this.engine.getEngineVersion();
            }
        }
        return this.engineVersion;
    }

    public List<String> getLstChildIds(String sessionId, String actionId) throws Exception {
        ActionCached action = this.getActionCachedById(sessionId, actionId);
        if (action == this.EMPTY_ACTION_CACHED) {
            return null;
        }
        if (action != null && action.lstChildsIds != null) {
            return action.lstChildsIds;
        }
        long l = System.currentTimeMillis();
        List result = this.engine.getLstChildIds(sessionId, actionId);
        if (action != null) {
            action.lstChildsIds = result;
        }
        return result;
    }

    public Map<String, Map<String, Object>> getLstInstanciatedIds(String sessionId, String actionId) throws Exception {
        SessionCached sess = this.cache.get(sessionId);
        if (sess != null) {
            Map altIds;
            if (sess.altIds == null) {
                sess.altIds = new HashMap<String, Map<String, Map<String, Object>>>();
            }
            if ((altIds = sess.altIds.get(actionId)) == null) {
                altIds = this.engine.getLstInstanciatedIds(sessionId, actionId);
            }
            return altIds;
        }
        return this.engine.getLstInstanciatedIds(sessionId, actionId);
    }

    public Map<String, Map<String, Object>> getLstRootSessionVariables(String sessionId) throws Exception {
        SessionCached sess = this.cache.get(sessionId);
        if (sess != null && sess.rootVariables != null) {
            return sess.rootVariables;
        }
        long l = System.currentTimeMillis();
        Map result = this.engine.getLstRootSessionVariables(sessionId);
        if (sess != null) {
            sess.rootVariables = result;
        }
        return result;
    }

    public EngineIterator getLstSession(Map<String, Object> criteria) throws Exception {
        Date start = new Date();
        if (this.lastSessionGatheredDatas == null || this.lastSessionGatheringDuration < start.getTime() - this.lastSessionGatheringDate.getTime()) {
            try {
                this.lastSessionGatheredDatas = this.engine.getLstSession(criteria).values();
                EngineIterator engineIterator = new EngineIterator(this, this.lastSessionGatheredDatas){};
                return engineIterator;
            }
            finally {
                Date end = new Date();
                this.lastSessionGatheringDuration = end.getTime() - start.getTime();
                this.lastSessionGatheringDate = end;
                SessionsMonitorState.getInstance().setSessionTimeTooLong(false);
            }
        }
        SessionsMonitorState.getInstance().setSessionTimeTooLong(true);
        return new EngineIterator(this, this.lastSessionGatheredDatas){};
    }

    public Map<String, Map<String, Object>> getLstSessionErrors(String sessionId) throws Exception {
        SessionCached sess = this.cache.get(sessionId);
        if (sess != null && sess.errors != null) {
            return sess.errors;
        }
        long l = System.currentTimeMillis();
        Map result = this.engine.getLstSessionErrors(sessionId);
        if (result != null) {
            for (String varId : result.keySet()) {
                Map<String, Object> stack;
                String actionName;
                String id;
                Map<String, Map<String, Object>> vars;
                Map map = (Map)result.get(varId);
                String value = (String)map.get("value");
                String varName = (String)map.get("name");
                if (value.equals("Error in process") || (vars = this.getActionLstVariables(sessionId, id = this.getActionId(sessionId, actionName = varName.substring(0, varName.lastIndexOf("/"))))) == null || (stack = vars.get(String.valueOf(actionName) + "/CORE_STACK_TRACE")) == null) continue;
                map.put("value", stack.get("value"));
            }
        }
        if (sess != null) {
            sess.errors = result;
        }
        return result;
    }

    public Map<String, Map<String, Object>> getLstSessionWarnings(String sessionId) throws Exception {
        SessionCached sess = this.cache.get(sessionId);
        if (sess != null && sess.warnings != null) {
            return sess.warnings;
        }
        long l = System.currentTimeMillis();
        Map result = this.engine.getLstSessionWarnings(sessionId);
        if (result != null) {
            for (String varId : result.keySet()) {
                Map<String, Object> stack;
                String actionName;
                String id;
                Map<String, Map<String, Object>> vars;
                Map map = (Map)result.get(varId);
                String value = (String)map.get("value");
                String varName = (String)map.get("name");
                if (value.equals("Error in process") || (vars = this.getActionLstVariables(sessionId, id = this.getActionId(sessionId, actionName = varName.substring(0, varName.lastIndexOf("/"))))) == null || (stack = vars.get(String.valueOf(actionName) + "/CORE_STACK_TRACE")) == null) continue;
                map.put("value", stack.get("value"));
            }
        }
        if (sess != null) {
            sess.warnings = result;
        }
        return result;
    }

    public ISessionDataExchange getSessionInfo(String sessionId) throws Exception {
        SessionCached sess = this.cache.get(sessionId);
        if (sess != null && sess.session != null) {
            return sess.session;
        }
        Map map = this.engine.getSessionInfo(sessionId);
        if (map != null) {
            return new SessionDataExchange(map);
        }
        return null;
    }

    public int purgeLogs(Date arg0) throws Exception {
        return this.engine.purgeLogs(arg0);
    }

    public int restartSession(String sessionId) throws Exception {
        return this.engine.restartSession(sessionId);
    }

    public int stopSession(String sessionId, boolean arg1) throws Exception {
        return this.engine.stopSession(sessionId, arg1);
    }

    public Map<String, Object> getActionVariable(String sessionId, String actionId, VariableType varType) throws Exception {
        ActionCached action = this.getActionCachedById(sessionId, actionId);
        if (action == this.EMPTY_ACTION_CACHED) {
            return null;
        }
        if (action != null && action.variables != null) {
            return action.variables.get(varType.getName());
        }
        Map variables = this.engine.getActionLstVariables(sessionId, actionId);
        if (action != null) {
            action.variables = variables;
        }
        if (action.variables != null) {
            return action.variables.get(varType.getName());
        }
        return null;
    }

    public Map<String, String> getMonitoringSummary() throws Exception {
        HashMap<String, Object> mapQuestion = new HashMap<String, Object>();
        mapQuestion.put(FunctionType.getMonitoringSummary.name(), null);
        Map mapAnswer = this.engine.get(mapQuestion);
        return (Map)mapAnswer.get(FunctionType.getMonitoringSummary.name());
    }

    public String getHttpEndpoint() throws Exception {
        return this.engine.getEngineHttpEndpoint();
    }

    class ActionCached {
        String generatedCode;
        List<String> lstChildsIds;
        Map<String, Map<String, Object>> LstInstanciatedIds;
        IActionDataExchange action;
        Map<String, Map<String, Object>> variables;
        Map<String, Collection<Map<String, Object>>> statistic = new HashMap<String, Collection<Map<String, Object>>>();
        public Map<String, IIdDataExchange> altIds;
        public boolean altIdsIsSet;

        private ActionCached(IActionDataExchange action) {
            this.action = action;
        }

        public ActionCached() {
        }
    }

    class AltIdCached {
        String id;
        Set<String> altdIds;

        AltIdCached() {
        }
    }

    public class EngineIterator {
        Map<String, Set<String>> childrenSession;
        Collection<Map<String, Object>> col;
        Set<String> retain = new HashSet<String>();

        public EngineIterator(Collection<Map<String, Object>> collection) {
            this.col = collection;
            this.retain.addAll(EngineServerWrapper.this.cache.keySet());
        }

        public void clean() {
            for (String str : this.retain) {
                EngineServerWrapper.this.cache.remove(str);
            }
        }

        public Iterator<ISessionDataExchange> iterator() {
            return new Iterator<ISessionDataExchange>(){
                Iterator<Map<String, Object>> it;
                {
                    this.it = EngineIterator.this.col.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public ISessionDataExchange next() {
                    Map<String, Object> o = this.it.next();
                    ISessionDataExchange e = SessionDataExchange.getSession(o);
                    SessionCached ss = ((EngineIterator)EngineIterator.this).EngineServerWrapper.this.cache.get(e.getId());
                    SessionCached ss2 = null;
                    if (e.getStatus() == 10) {
                        if (ss != null) {
                            if (ss.session.getStatus() != e.getStatus()) {
                                ((EngineIterator)EngineIterator.this).EngineServerWrapper.this.cache.remove(e.getId());
                            }
                        } else {
                            ss2 = new SessionCached(e);
                            ((EngineIterator)EngineIterator.this).EngineServerWrapper.this.cache.put(e.getId(), ss2);
                        }
                    } else if (e.getEndDate() != null) {
                        if (ss != null && ss.session.getEndDate() != null) {
                            if (ss.session.getEndDate().compareTo(e.getEndDate()) != 0) {
                                ss2 = new SessionCached(e);
                                ((EngineIterator)EngineIterator.this).EngineServerWrapper.this.cache.put(e.getId(), ss2);
                            }
                        } else {
                            ss2 = new SessionCached(e);
                            ((EngineIterator)EngineIterator.this).EngineServerWrapper.this.cache.put(e.getId(), ss2);
                            EngineIterator.this.retain.remove(e.getId());
                        }
                    } else if (e.getIter() > 1 && ss != null && ss.session.getIter() != e.getIter()) {
                        ss2 = new SessionCached(e);
                        ((EngineIterator)EngineIterator.this).EngineServerWrapper.this.cache.put(e.getId(), ss2);
                        EngineIterator.this.retain.remove(e.getId());
                    } else if (ss != null) {
                        ((EngineIterator)EngineIterator.this).EngineServerWrapper.this.cache.remove(e.getId());
                    }
                    EngineIterator.this.retain.remove(e.getId());
                    if (ss2 != null && ss != null) {
                        ss2.altIds = ss.altIds;
                    }
                    return e;
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }
    }

    class SessionCached {
        ISessionDataExchange session;
        Map<String, Map<String, Object>> rootVariables;
        Map<String, IVariable> aggregatTion;
        Map<String, ActionCached> actionsById = new HashMap<String, ActionCached>();
        Map<String, ActionCached> actionsByName = new HashMap<String, ActionCached>();
        public Map<String, Map<String, Object>> errors;
        public Map<String, Map<String, Object>> warnings;
        public Map<String, Map<String, Object>> variables;
        public Map<String, Map<String, Map<String, Object>>> altIds;

        void putAction(ActionCached action, String actionId) {
            if (action != null && action.action != null) {
                this.actionsById.put(actionId, action);
                this.actionsByName.put(action.action.getName(), action);
            }
        }

        private SessionCached(ISessionDataExchange session) {
            this.session = session;
        }
    }
}

