/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine;

import com.indy.engine.common.security.PrivilegeException;
import com.indy.engine.core.common.LocalSession;
import com.indy.engine.core.common.objects2.IActionDataExchange;
import com.indy.engine.core.common.objects2.ISessionDataExchange;
import com.indy.engine.core.common.objects2.IVariable;
import com.indy.engine.core.common.objects2.IdDataExchange;
import com.indy.ui.custom.out.CustomSelectionListener;
import com.indy.ui.custom.out.EngineVariable;
import com.indy.ui.custom.out.IndyEventManager;
import com.indy.ui.custom.out.gmf.MultipleEditorInputProvider;
import com.indy.ui.custom.out.listener.EditorListener;
import com.indy.ui.custom.out.listener.EditorListenerRegistry;
import com.indy.ui.custom.out.tools.FigureColoringHelper;
import com.indy.ui.engine.Activator;
import com.indy.ui.engine.ClientVariable;
import com.indy.ui.engine.EngineGlobal;
import com.indy.ui.engine.EngineServerWrapper;
import com.indy.ui.engine.EventDispatcher;
import com.indy.ui.engine.Messages;
import com.indy.ui.engine.api.ActionStatus;
import com.indy.ui.engine.exception.RunProcessException;
import com.indy.ui.engine.handlers.GenerateErrorLogEngine;
import com.indy.ui.engine.helper.IStatisticDecorator;
import com.indy.ui.engine.session.SessionsMonitorState;
import com.indy.ui.engine.util.Functions;
import com.indy.ui.engine.variable.VariableList;
import com.indy.ui.engine.view.ActionView;
import com.indy.ui.engine.view.EngineView;
import com.semarchy.xdi.designer.core.Constants;
import com.semarchy.xdi.designer.core.MonitorCapability;
import com.semarchy.xdi.designer.core.services.IEnvironmentConfiguration;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.engine.common.EngineFactory;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.Authenticator;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.GraphicalEditPolicyEx;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.ISourceProviderService;

public class WatchEngine
implements Runnable {
    boolean doRefresh = false;
    private String actionProcessUniqueId;
    private List<String> childIds;
    private EngineServerWrapper.EngineIterator tmSessions;
    private String actionCodeUniqueId;
    private WeakReference<GraphicalEditPart> precDiagram;
    private String endCurrentSessionTime;
    private String remoteEngineVersion;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static Authenticator defaultAuthenticator = null;
    String remoteApiVersion;
    static final String lock = "";
    EditorListener editorListener = new EditorListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void handleDispose(IDiagramWorkbenchPart editor) {
            if (editor != EngineVariable.INSTANCE.getSelectedEditor()) return;
            String string = WatchEngine.lock;
            synchronized (WatchEngine.lock) {
                WatchEngine.this.precDiagram = null;
                EngineVariable.INSTANCE.setSelectedEditor(null);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    };
    private static final String CORE_STACK_TRACE = "CORE_STACK_TRACE";
    private static final String CORE_RET_MESS = "CORE_RET_MESS";
    ISessionDataExchange currentSession;
    ISessionDataExchange precSession;
    private boolean colorChanged = false;

    public WatchEngine() {
        this.initSelectionListener();
        this.registerListener();
    }

    public void interrupt() {
        Thread.interrupted();
    }

    @Override
    public void run() {
        this.initEngine();
    }

    public void initEngine() {
        EngineGlobal.stop = false;
        EngineGlobal.setStatus(0);
        boolean precConnected = false;
        boolean disConnected = false;
        SessionsMonitorState.getInstance().setSessionTimeTooLong(false);
        while (!EngineGlobal.stop) {
            if (!(EngineGlobal.getStatus() == 1 && EngineGlobal.engine != null || EngineGlobal.stop)) {
                try {
                    this.connect();
                    EngineGlobal.setStatus(1);
                    precConnected = true;
                }
                catch (Exception e1) {
                    if (!EngineGlobal.hasLoggedConnectionError) {
                        Activator.getDefault().getLog().log((IStatus)new Status(1, "com.indy.ui.engine", Messages.WatchEngine_0, (Throwable)e1));
                        e1.printStackTrace();
                        EngineGlobal.hasLoggedConnectionError = true;
                    }
                    if (e1 instanceof IOException && (((IOException)e1).getMessage().contains("401") || e1.getCause() instanceof PrivilegeException)) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.WatchEngine_4, (String)Messages.WatchEngine_5);
                                try {
                                    ((EngineView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("com.indy.ui.custom.engine.EngineView")).stopListener();
                                }
                                catch (Exception ex) {
                                    WatchEngine.this.logger.log(Level.WARNING, "An exception occured : ", ex);
                                }
                            }
                        });
                    }
                    if (precConnected) {
                        IndyEventManager.INSTANCE.handleEvent("EngineListener", (Object)"ConnectionChanged");
                        precConnected = false;
                    }
                    EngineGlobal.setStatus(-1);
                    this.waitBeforRetryConnection(Messages.WatchEngine_1, 5);
                }
            }
            if (EngineGlobal.getStatus() != 1 || EngineGlobal.stop) continue;
            try {
                HashMap<String, Object> criteria = new HashMap<String, Object>();
                criteria.put("nbSessions", SessionsMonitorState.getInstance().getNbSessions());
                criteria.put("filter", SessionsMonitorState.getInstance().getFilter());
                criteria.put("statusList", SessionsMonitorState.getInstance().getStatus());
                if (SessionsMonitorState.getInstance().isCurrentRuntime()) {
                    criteria.put("currentEngine", true);
                }
                if (SessionsMonitorState.getInstance().onlyLocal()) {
                    InetAddress localaddr = InetAddress.getLocalHost();
                    String guestHost = localaddr.getHostName();
                    criteria.put("guestHost", guestHost);
                }
                this.tmSessions = EngineGlobal.engine.getLstSession(criteria);
                this.refreshSessionList();
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!EngineView.getRefreshDiagram().isDisposed()) {
                            WatchEngine.this.doRefresh = EngineView.getRefreshDiagram().getSelection();
                        }
                    }
                });
                this.precSession = this.currentSession;
                this.currentSession = EngineGlobal.engine.getSessionInfo(EngineVariable.INSTANCE.getSessionId());
                if (!(this.currentSession == null || this.precSession == null || Constants.equals((Object)this.currentSession.getId(), (Object)this.precSession.getId()) && Constants.equals((Object)this.currentSession.getEndDate(), (Object)this.precSession.getEndDate()))) {
                    this.refreshView(false);
                    if (EngineVariable.INSTANCE.isRefreshDiagram()) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                WatchEngine.this.refreshDiagram();
                            }
                        });
                    }
                }
            }
            catch (Exception e1) {
                if (precConnected) {
                    IndyEventManager.INSTANCE.handleEvent("EngineListener", (Object)"ConnectionChanged");
                    precConnected = false;
                }
                this.logger.log(Level.WARNING, "An exception occured : ", e1);
                EngineGlobal.setStatus(-2);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        EngineGlobal.getSessionList().removeAllSessions();
                    }
                });
                this.waitBeforRetryConnection(Messages.WatchEngine_7, 5);
            }
            try {
                Thread.sleep(EngineGlobal.msRefresh);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        SessionsMonitorState.getInstance().setSessionTimeTooLong(false);
        EngineGlobal.setStatus(0);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                EngineGlobal.getSessionList().removeAllSessions();
                EventDispatcher.RuntimeEvent event = new EventDispatcher.RuntimeEvent();
                event.type = EventDispatcher.RuntimeEventType.disconnect;
                Activator.getDefault().getDispatcher().dispatchEvent(event);
                IndyEventManager.INSTANCE.handleEvent("EngineListener", (Object)"ConnectionChanged");
                EngineView.setStatus(1, null, null, null);
            }
        });
    }

    public void refreshSessionList() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                EngineGlobal.getSessionList().synchronise(WatchEngine.this.tmSessions);
            }
        });
    }

    public void connect() throws Exception {
        HashMap<String, String> credentials = new HashMap<String, String>();
        IEnvironmentConfiguration.EngineConfiguration engineConf = ((IEnvironmentConfiguration)E4InjectorHelper.getService(IEnvironmentConfiguration.class)).getEngineConfiguration();
        if (engineConf.getLogin() != null) {
            credentials.put("user", engineConf.getLogin());
            credentials.put("password", engineConf.getPassword());
        }
        Authenticator.setDefault(null);
        LocalSession engine = null;
        try {
            Integer port = Integer.valueOf(engineConf.getPort());
            engine = EngineFactory.getEngine((String)engineConf.getHost(), (int)port, credentials);
        }
        finally {
            WatchEngine.restoreDefaultHttpAuthenticator();
        }
        final boolean ssl = engine.isUsingSsl();
        EngineGlobal.setEngine(engine.getRemoteObject());
        this.remoteApiVersion = EngineGlobal.engine.getApiVersion();
        this.remoteEngineVersion = EngineGlobal.engine.getEngineVersion();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                int status = ssl ? 6 : 0;
                EngineView.setStatus(status, null, WatchEngine.this.remoteApiVersion, WatchEngine.this.remoteEngineVersion);
                EventDispatcher.RuntimeEvent event = new EventDispatcher.RuntimeEvent();
                event.type = EventDispatcher.RuntimeEventType.connect;
                Activator.getDefault().getDispatcher().dispatchEvent(event);
                IndyEventManager.INSTANCE.handleEvent("EngineListener", (Object)"ConnectionChanged");
            }
        });
    }

    public static void restoreDefaultHttpAuthenticator() {
        if (defaultAuthenticator != null) {
            Authenticator.setDefault(defaultAuthenticator);
        } else {
            IExtension extension;
            IConfigurationElement[] configs;
            IExtension[] extensions = RegistryFactory.getRegistry().getExtensionPoint("org.eclipse.core.net", "authenticator").getExtensions();
            if (extensions.length != 0 && (configs = (extension = extensions[0]).getConfigurationElements()).length != 0) {
                try {
                    Authenticator authenticator;
                    IConfigurationElement config = configs[0];
                    defaultAuthenticator = authenticator = (Authenticator)config.createExecutableExtension("class");
                    Authenticator.setDefault(defaultAuthenticator);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
    }

    public String getRemoteVersion() {
        return this.remoteApiVersion;
    }

    void registerListener() {
        IndyEventManager.INSTANCE.addListener("EngineListener", new IndyEventManager.IndyEventListener(){

            public void notify(Object event) {
                if (event.equals("SelectionChanged")) {
                    WatchEngine.this.selectionChanged(1);
                } else if (event.equals("RootChanged")) {
                    WatchEngine.this.selectionChanged(2);
                } else if (event.equals("DiagramChanged")) {
                    WatchEngine.this.selectionChanged(2);
                } else if (event.equals("SessionChanged")) {
                    WatchEngine.this.selectionChanged(2);
                } else if (event.equals("ConnectionChanged")) {
                    WatchEngine.this.selectionChanged(2);
                } else if (event.equals("InstanceChanged")) {
                    WatchEngine.this.selectionChanged(3);
                } else if (event.equals("RefreshEvent")) {
                    WatchEngine.this.selectionChanged(2);
                }
            }
        });
    }

    public void initSelectionListener() {
        ISelectionService service = (ISelectionService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ISelectionService.class);
        service.addSelectionListener((ISelectionListener)new CustomSelectionListener(){
            WeakReference<GraphicalEditPart> precGraphicalEditPart = new WeakReference<Object>(null);

            public void partActivated(IWorkbenchPart part) {
                if (this.isActive() && this.getPart() instanceof IDiagramWorkbenchPart) {
                    this.handleSelectionChanged();
                }
            }

            public void handleSelectionChanged() {
                EObject _o = this.getEObject();
                if (_o == null) {
                    return;
                }
                EClass o = _o.eClass();
                if (!(o.getName().equals("Parameter") || o.getName().equals("MetaDataLink") || o.getName().equals("XslVariable") || o.getName().equals("Link") || o.getName().equals("BindLink"))) {
                    MonitorCapability precSelectedAction = EngineVariable.INSTANCE.getSelectedAction();
                    MonitorCapability precSelectedRootProcess = EngineVariable.INSTANCE.getSelectedRootProcess();
                    IDiagramWorkbenchPart precEditor = EngineVariable.INSTANCE.getSelectedEditor();
                    if (this.getPart() instanceof IDiagramWorkbenchPart) {
                        Object tmp;
                        EObject eObject;
                        EObject oo;
                        IDiagramWorkbenchPart editor = (IDiagramWorkbenchPart)this.getPart();
                        Object _temp = null;
                        _temp = editor instanceof MultipleEditorInputProvider ? (((MultipleEditorInputProvider)editor).getMainDiagramEditPart() == null ? null : ((MultipleEditorInputProvider)editor).getMainDiagramEditPart().resolveSemanticElement()) : (editor.getDiagramEditPart() == null ? null : ((oo = editor.getDiagramEditPart().resolveSemanticElement()) != null ? Platform.getAdapterManager().getAdapter((Object)oo, MonitorCapability.class) : null));
                        if (EngineVariable.INSTANCE.setSelectedRootProcess(_temp)) {
                            EngineVariable.INSTANCE.setSelectedEditor(editor);
                            if (editor != precEditor) {
                                if (precEditor != null) {
                                    EditorListenerRegistry.unregister((IDiagramWorkbenchPart)precEditor);
                                }
                                EditorListenerRegistry.unregister((IDiagramWorkbenchPart)editor);
                                EditorListenerRegistry.register((IDiagramWorkbenchPart)editor, (EditorListener)WatchEngine.this.editorListener);
                            }
                        }
                        if ((eObject = this.getEObject()) != null && (tmp = Platform.getAdapterManager().getAdapter((Object)eObject, MonitorCapability.class)) != null) {
                            EngineVariable.INSTANCE.setSelectedAction((MonitorCapability)tmp);
                        }
                        boolean result = false;
                        if (EngineVariable.INSTANCE.getSelectedDiagram() != this.precGraphicalEditPart.get()) {
                            WatchEngine.this.checkError4Session();
                            IndyEventManager.INSTANCE.handleEvent("EngineListener", (Object)"DiagramChanged");
                        } else if (EngineVariable.INSTANCE.getSelectedRootProcess() == null && precSelectedRootProcess != null || EngineVariable.INSTANCE.getSelectedRootProcess() != null && !EngineVariable.INSTANCE.getSelectedRootProcess().equals(precSelectedRootProcess)) {
                            IndyEventManager.INSTANCE.handleEvent("EngineListener", (Object)"RootChanged");
                        } else if (EngineVariable.INSTANCE.getSelectedAction() == null && precSelectedAction != null || EngineVariable.INSTANCE.getSelectedAction() != null && !EngineVariable.INSTANCE.getSelectedAction().equals(precSelectedAction)) {
                            IndyEventManager.INSTANCE.handleEvent("EngineListener", (Object)"SelectionChanged");
                        }
                        this.precGraphicalEditPart = new WeakReference<GraphicalEditPart>(EngineVariable.INSTANCE.getSelectedDiagram());
                    }
                }
            }

            protected void releasSpecializedResources(IWorkbenchPart part) {
                if (part == EngineVariable.INSTANCE.getSelectedEditor()) {
                    EngineVariable.INSTANCE.setselectedAction(null);
                    EngineVariable.INSTANCE.setSelectedRootProcess(null);
                    EngineVariable.INSTANCE.setSelectedEditor(null);
                    WatchEngine.this.precDiagram = null;
                }
            }
        });
    }

    private void refreshSessionDetail() {
        if (EngineGlobal.isConnected() && EngineVariable.INSTANCE.getSessionId() != null && !EngineVariable.INSTANCE.getSessionId().equals("-1")) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        Map<String, Object> tmGlobalVariables = EngineGlobal.engine.getLstRootSessionVariables(EngineVariable.INSTANCE.getSessionId());
                        EngineGlobal.getGlobalVarList().synchronise(tmGlobalVariables, null);
                    }
                    catch (Exception e) {
                        WatchEngine.this.logger.log(Level.WARNING, "An exception occured : ", e);
                    }
                    try {
                        Map<String, Object> tmGlobalWarnings = EngineGlobal.engine.getLstSessionWarnings(EngineVariable.INSTANCE.getSessionId());
                        EngineGlobal.getGlobalWarningList().synchronise(tmGlobalWarnings, null);
                    }
                    catch (Exception e) {
                        WatchEngine.this.logger.log(Level.WARNING, "An exception occured : ", e);
                    }
                    try {
                        Map<String, Object> tmGlobalErrors = EngineGlobal.engine.getLstSessionErrors(EngineVariable.INSTANCE.getSessionId());
                        EngineGlobal.getGlobalErrorList().synchronise(tmGlobalErrors, Messages.WatchEngine_17);
                    }
                    catch (Exception e) {
                        WatchEngine.this.logger.log(Level.WARNING, "An exception occured : ", e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void selectionChanged(Integer mode) {
        this.currentSession = null;
        if (mode >= 1) {
            this.searchId();
            this.refreshView(mode == 3 || mode == 1);
            this.refreshSessionDetail();
        }
        if (mode > 1 && EngineVariable.INSTANCE.isRefreshDiagram()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    WatchEngine.this.refreshDiagram();
                }
            });
            return;
        }
        if (mode <= 1) return;
        String string = lock;
        synchronized (lock) {
            if (!this.isEditorSelected()) return;
            this.razAllAction();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void refreshView(final boolean onlyInstanceChanged) {
        if (this.actionCodeUniqueId != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ActionView.refreshValues(EngineVariable.INSTANCE.getSelectedAction(), EngineVariable.INSTANCE.getSessionId(), WatchEngine.this.actionCodeUniqueId, onlyInstanceChanged);
                }
            });
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ActionView.removeAll();
                }
            });
        }
    }

    public List<IVariable> getCoreStacktraceVariables(MonitorCapability action) {
        ArrayList<IVariable> coreStackTraceVariables = new ArrayList<IVariable>();
        if (EngineGlobal.isConnected() && EngineVariable.INSTANCE.getSessionId() != null && !EngineVariable.INSTANCE.getSessionId().equals("-1") && !EngineVariable.INSTANCE.getSessionId().isEmpty()) {
            String actionCodeUniqueId = null;
            try {
                String id = null;
                if (!action.isRootAndChild()) {
                    id = action.getId().equals(EngineVariable.INSTANCE.getSelectedRootProcess().getId()) ? this.actionProcessUniqueId : this.getFirstUniqueId(action.getId());
                }
                actionCodeUniqueId = id;
                Map<String, Map<String, Object>> list = EngineGlobal.getEngine().getLstInstanciatedIds(EngineVariable.INSTANCE.getSessionId(), action.getId());
                IActionDataExchange dataExchange = EngineGlobal.getEngine().getActionInfo(EngineVariable.INSTANCE.getSessionId(), EngineVariable.INSTANCE.getAltIdToInstance(action.getId()));
                HashMap<String, Map<String, Object>> list2 = new HashMap<String, Map<String, Object>>();
                String fullPath = dataExchange.getName();
                if (fullPath != null) {
                    String[] split = fullPath.split("/");
                    int i = split.length - 1;
                    String currentSegment = split[i];
                    String parentPath = fullPath.substring(0, fullPath.lastIndexOf(currentSegment));
                    for (String s : list.keySet()) {
                        IdDataExchange value;
                        String path;
                        Map<String, Object> o = list.get(s);
                        if (o == null || !(path = (value = new IdDataExchange(o)).getName()).startsWith(parentPath)) continue;
                        String[] split2 = path.split("/");
                        String segment = split2[i];
                        if (!(String.valueOf(parentPath) + segment).equals(path)) continue;
                        list2.put(s, list.get(s));
                    }
                }
                for (String s : list2.keySet()) {
                    IActionDataExchange currentInfo = EngineGlobal.getEngine().getActionInfo(EngineVariable.INSTANCE.getSessionId(), s);
                    if (currentInfo == null) continue;
                    Map<String, Object> tm = EngineGlobal.getEngine().getActionLstVariables(EngineVariable.INSTANCE.getSessionId(), s);
                    VariableList variables = new VariableList();
                    variables.synchronise(tm, null);
                    ArrayList<IVariable> coreRetMess = new ArrayList<IVariable>();
                    for (IVariable v : variables.getVariables()) {
                        if (v.getName().matches(".*\\/CORE_STACK_TRACE.*")) {
                            coreStackTraceVariables.add(v);
                        }
                        if (!v.getName().matches(".*\\/CORE_RET_MESS.*")) continue;
                        coreRetMess.add(v);
                    }
                    if (!coreStackTraceVariables.isEmpty()) continue;
                    coreStackTraceVariables.addAll(coreRetMess);
                }
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "An exception occured : ", e);
            }
        }
        return coreStackTraceVariables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean refreshDiagram() {
        String string = lock;
        synchronized (lock) {
            Object _gep;
            if (!this.isEditorSelected()) return this.doRefresh;
            Object v0 = _gep = this.precDiagram == null ? null : this.precDiagram.get();
            if (_gep == null || _gep != EngineVariable.INSTANCE.getSelectedDiagram()) {
                this.razAllAction();
            }
            this.precDiagram = new WeakReference<GraphicalEditPart>(EngineVariable.INSTANCE.getSelectedDiagram());
            if (EngineVariable.INSTANCE.getSessionId() != null) {
                if (EngineGlobal.getStatus() == 1 && EngineVariable.INSTANCE.getSelectedRootProcess() != null) {
                    try {
                        String id = EngineVariable.INSTANCE.getSelectedRootProcess().getId();
                        EngineGlobal.msRefresh = this.changeColor() ? EngineGlobal.msQuick : EngineGlobal.msSlow;
                        String actionRootID = null;
                        for (IVariable v : EngineGlobal.getGlobalVarList().getVariables()) {
                            if (!v.getName().equals("CORE_ROOT_ID")) continue;
                            actionRootID = v.getValue();
                            break;
                        }
                        EngineVariable.INSTANCE.setRootStepId(actionRootID);
                        ISessionListenerManager l = (ISessionListenerManager)E4InjectorHelper.getService(ISessionListenerManager.class);
                        if (l == null) return true;
                        for (IUIListener listener : l.getListeners(id)) {
                            listener.refresh();
                        }
                    }
                    catch (Exception e1) {
                        this.razAllAction();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return false;
                    }
                    return true;
                }
                this.razAllAction();
            } else {
                this.razAllAction();
            }
            this.precDiagram = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.doRefresh;
        }
    }

    public static int getQuickRefresh() {
        return Activator.getDefault().getPreferenceStore().getInt("quickRefresh");
    }

    public static int getNormalRefresh() {
        return Activator.getDefault().getPreferenceStore().getInt("normalRefresh");
    }

    public boolean searchId() {
        block19: {
            this.actionProcessUniqueId = null;
            this.actionCodeUniqueId = null;
            String sessionID = null;
            if (EngineGlobal.getStatus() == 1 && (sessionID = EngineVariable.INSTANCE.getSessionId()) != null && EngineGlobal.engine != null) {
                try {
                    if (EngineVariable.INSTANCE.getSelectedRootProcess() == null || EngineVariable.INSTANCE.getSelectedRootProcess().getId() == null) break block19;
                    String actionProcessSrcId = EngineVariable.INSTANCE.getSelectedRootProcess().getId();
                    Queue<String> ids2 = EngineVariable.INSTANCE.getSelectedEditor() instanceof MultipleEditorInputProvider ? ((MultipleEditorInputProvider)EngineVariable.INSTANCE.getSelectedEditor()).getContextRefId() : new LinkedList<String>(Collections.singletonList(actionProcessSrcId));
                    String currentProcessRealId = null;
                    String currentProcessPath = null;
                    block4: while (!ids2.isEmpty()) {
                        String id4;
                        String id2 = ids2.poll();
                        String id3 = EngineVariable.INSTANCE.getAltIdToInstance(actionProcessSrcId);
                        String string = id4 = id2 != null ? EngineVariable.INSTANCE.getAltIdToInstance(id2) : null;
                        if (id4 != null) {
                            currentProcessRealId = id4;
                            continue;
                        }
                        if (id2 == null && id3 != null) {
                            currentProcessRealId = id3;
                            continue;
                        }
                        Map<String, Map<String, Object>> map = null;
                        if (currentProcessRealId == null) {
                            map = EngineGlobal.engine.getLstInstanciatedIds(sessionID, actionProcessSrcId);
                            if (map != null && map.size() > 0) {
                                currentProcessRealId = map.keySet().iterator().next();
                            } else {
                                currentProcessRealId = null;
                                break;
                            }
                        }
                        if (id2 == null) continue;
                        map = EngineGlobal.engine.getLstInstanciatedIds(sessionID, id2);
                        if (map != null && map.size() > 0) {
                            for (Map.Entry<String, Map<String, Object>> entry : map.entrySet()) {
                                String processId = entry.getKey();
                                Map<String, Object> subMap = entry.getValue();
                                String processPath = (String)subMap.get("name");
                                if (currentProcessPath != null && !processPath.startsWith(currentProcessPath)) continue;
                                currentProcessRealId = processId;
                                currentProcessPath = processPath;
                                continue block4;
                            }
                            continue;
                        }
                        currentProcessRealId = null;
                        break;
                    }
                    this.actionProcessUniqueId = currentProcessRealId;
                    try {
                        this.childIds = EngineGlobal.engine.getLstChildIds(sessionID, this.actionProcessUniqueId);
                    }
                    catch (NullPointerException e) {
                        this.actionProcessUniqueId = null;
                    }
                    if (EngineVariable.INSTANCE.getSelectedAction() != null && EngineVariable.INSTANCE.getSelectedAction().getId() != null) {
                        String id2;
                        String id = null;
                        MonitorCapability currentProcess = null;
                        if (!EngineVariable.INSTANCE.getSelectedAction().isRootAndChild()) {
                            id = EngineVariable.INSTANCE.getSelectedAction().getId().equals(EngineVariable.INSTANCE.getSelectedRootProcess().getId()) ? this.actionProcessUniqueId : ((currentProcess = EngineVariable.INSTANCE.getSelectedActiveProcess()) != null && EngineVariable.INSTANCE.getSelectedAction().getId().equals(currentProcess.getId()) ? this.actionProcessUniqueId : ((id2 = EngineVariable.INSTANCE.getAltIdToInstance(EngineVariable.INSTANCE.getSelectedAction().getId())) != null && this.childIds != null && this.childIds.contains(id2) ? id2 : this.getFirstUniqueId(EngineVariable.INSTANCE.getSelectedAction().getId())));
                        } else {
                            id2 = EngineVariable.INSTANCE.getAltIdToInstance(EngineVariable.INSTANCE.getSelectedAction().getId());
                            if (id2 != null && this.childIds != null && this.childIds.contains(id2)) {
                                id = id2;
                            } else {
                                Map<String, Map<String, Object>> map = EngineGlobal.engine.getLstInstanciatedIds(sessionID, EngineVariable.INSTANCE.getSelectedAction().getId());
                                if (map != null && map.size() > 0) {
                                    id = map.keySet().iterator().next();
                                }
                            }
                        }
                        this.actionCodeUniqueId = id;
                        EngineVariable.INSTANCE.putAltIdToInstance(EngineVariable.INSTANCE.getSelectedAction().getId(), this.actionCodeUniqueId);
                    }
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, "An exception occured : ", e);
                }
            }
        }
        return false;
    }

    private boolean isEditorSelected() {
        return EngineVariable.INSTANCE.getSelectedEditor() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void razAllAction() {
        String string = lock;
        synchronized (lock) {
            if (this.isEditorSelected() && EngineVariable.INSTANCE.getSelectedDiagram() != null) {
                boolean active = false;
                try {
                    Field tmp = EngineVariable.INSTANCE.getSelectedDiagram().getClass().getField("MODEL_ID");
                    active = ((String)tmp.get(null)).toUpperCase().equals("PROC");
                }
                catch (SecurityException e) {
                    this.logger.log(Level.WARNING, "An exception occured : ", e);
                }
                catch (NoSuchFieldException e) {
                    this.logger.log(Level.WARNING, "An exception occured : ", e);
                }
                catch (IllegalArgumentException e) {
                    this.logger.log(Level.WARNING, "An exception occured : ", e);
                }
                catch (IllegalAccessException e) {
                    this.logger.log(Level.WARNING, "An exception occured : ", e);
                }
                if (active) {
                    List list = EngineVariable.INSTANCE.getSelectedDiagram().getChildren();
                    for (ShapeNodeEditPart selectedElement : list) {
                        MonitorCapability mc;
                        EObject eob = selectedElement.resolveSemanticElement();
                        if (eob == null || (mc = (MonitorCapability)Platform.getAdapterManager().getAdapter((Object)eob, MonitorCapability.class)) == null) continue;
                        if (selectedElement.getSelected() == 0) {
                            selectedElement.getFigure().setBackgroundColor(FigureColoringHelper.getColorAction());
                        } else {
                            selectedElement.getFigure().setBackgroundColor(FigureColoringHelper.getColorAction_Selected());
                        }
                        this.setActionLabel(selectedElement.getFigure(), mc.getName());
                        EditPolicy ep = selectedElement.getEditPolicy((Object)"DecorationPolicy");
                        if (!(ep instanceof IStatisticDecorator) || !((IStatisticDecorator)ep).setStat(null) || !(ep instanceof GraphicalEditPolicyEx)) continue;
                        ((GraphicalEditPolicyEx)ep).refresh();
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void setActionLabel(IFigure figure, String label) {
        for (Object f : figure.getChildren()) {
            if (!(f instanceof IFigure)) continue;
            for (Object f2 : ((Figure)f).getChildren()) {
                if (!(f2 instanceof WrappingLabel)) continue;
                ((WrappingLabel)f2).setText(label);
                return;
            }
        }
    }

    public String getFirstUniqueId(String srcId) {
        String result = null;
        try {
            Map<String, Map<String, Object>> map = EngineGlobal.engine.getLstInstanciatedIds(EngineVariable.INSTANCE.getSessionId(), srcId);
            for (String _id : map.keySet()) {
                if (this.childIds == null) continue;
                for (String __id : this.childIds) {
                    if (!__id.equals(_id)) continue;
                    return _id;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean changeColor() throws RunProcessException {
        boolean _return = false;
        if (EngineGlobal.getStatus() == 1 && EngineVariable.INSTANCE.getSelectedRootProcess().hasChildrenToRefresh()) {
            List list = EngineVariable.INSTANCE.getSelectedDiagram().getChildren();
            for (ShapeNodeEditPart selectedElement : list) {
                EditPolicy ep;
                int actionStatus = ActionStatus.ACTION_NOT_GENERATED.getId();
                MonitorCapability monitor = null;
                if (selectedElement.resolveSemanticElement() == null || (monitor = (MonitorCapability)Platform.getAdapterManager().getAdapter((Object)selectedElement.resolveSemanticElement(), MonitorCapability.class)) == null || monitor.getId() == null) continue;
                boolean refreshDecoratorPolicy = false;
                try {
                    Map<String, Map<String, Object>> map = EngineGlobal.engine.getLstInstanciatedIds(EngineVariable.INSTANCE.getSessionId(), monitor.getId());
                    int count = 0;
                    int done = 0;
                    HashSet<Integer> set = new HashSet<Integer>();
                    int s = ActionStatus.ACTION_NOT_GENERATED.getId();
                    if (map != null) {
                        for (String _id : map.keySet()) {
                            if (this.childIds == null) continue;
                            for (String __id : this.childIds) {
                                Collection<Map<String, Object>> _stats;
                                if (!__id.equals(_id)) continue;
                                ++count;
                                s = EngineGlobal.engine.getActionStatus(EngineVariable.INSTANCE.getSessionId(), _id);
                                if (s == 1) {
                                    ++done;
                                }
                                set.add(s);
                                String statsStr = Activator.getDefault().getPreferenceStore().getString("monitorSumStat");
                                ArrayList<String> l = new ArrayList<String>();
                                if (statsStr != null) {
                                    String[] stats;
                                    String[] stringArray = stats = statsStr.split("[,\n]");
                                    int n = stats.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String statSrt = stringArray[n2];
                                        l.add(statSrt.trim());
                                        ++n2;
                                    }
                                }
                                if ((_stats = EngineGlobal.getEngine().aggregateVariables(EngineVariable.INSTANCE.getSessionId(), _id, l, 1)) == null) continue;
                                String val = null;
                                for (Map<String, Object> _map : _stats) {
                                    IVariable stat = ClientVariable.getVariable(_map);
                                    if (stat == null) continue;
                                    val = String.valueOf(stat.getValue()) + " rows";
                                }
                                EditPolicy ep2 = selectedElement.getEditPolicy((Object)"DecorationPolicy");
                                if (!(ep2 instanceof IStatisticDecorator)) continue;
                                refreshDecoratorPolicy = ((IStatisticDecorator)ep2).setStat(val);
                            }
                        }
                    }
                    if (set.contains(-1)) {
                        s = -1;
                    } else if (set.contains(-2)) {
                        s = -2;
                    } else if (set.contains(-3)) {
                        s = -3;
                    } else if (set.contains(2)) {
                        s = 2;
                    }
                    actionStatus = s;
                    if (count > 1) {
                        this.setActionLabel(selectedElement.getFigure(), String.valueOf(monitor.getName()) + " " + done + "/" + count);
                    }
                }
                catch (Exception e1) {
                    this.logger.log(Level.WARNING, "An exception occured : ", e1);
                }
                if (this.changeFigureColor(selectedElement.getFigure(), actionStatus, monitor)) {
                    _return = true;
                }
                if (!refreshDecoratorPolicy || !((ep = selectedElement.getEditPolicy((Object)"DecorationPolicy")) instanceof GraphicalEditPolicyEx)) continue;
                ((GraphicalEditPolicyEx)ep).refresh();
            }
        }
        return _return;
    }

    public boolean changeFigureColor(IFigure figure, int actionStatus, MonitorCapability monitor) {
        boolean _return = false;
        Color newColor = Functions.getColorActionStatus(actionStatus, monitor.isToleratedError());
        IFigure figure3 = figure;
        if (figure3 != null && figure3.getBackgroundColor() != null && !figure3.getBackgroundColor().equals((Object)newColor)) {
            _return = true;
            figure3.setBackgroundColor(newColor);
            figure3.setBorder(null);
        }
        return _return;
    }

    public void waitBeforRetryConnection(String msgPre, int sec) {
        int _sec = sec;
        while (_sec >= 0 && !EngineGlobal.stop) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.logger.log(Level.WARNING, "An exception occured : ", e);
            }
            final String msg = Messages.bind((String)Messages.WatchEngine_31, (Object)_sec);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    EngineView.setStatus(5, msg, null, null);
                }
            });
            --_sec;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                EngineView.setStatus(3, null, null, null);
            }
        });
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            this.logger.log(Level.WARNING, "An exception occured : ", e);
        }
    }

    public void checkError4Session() {
        if (!EngineGlobal.isConnected()) {
            return;
        }
        IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISourceProviderService service = (ISourceProviderService)win.getService(ISourceProviderService.class);
        GenerateErrorLogEngine.SessionSourceProvider sessionSourceProvider = (GenerateErrorLogEngine.SessionSourceProvider)service.getSourceProvider("com.indy.ui.engine.handlers.sessionMatchEditorState");
        MonitorCapability monitor = null;
        if (EngineVariable.INSTANCE.getSelectedDiagram() == null) {
            sessionSourceProvider.setSessionMacthEditor(false);
        } else if (EngineVariable.INSTANCE.getSelectedDiagram().resolveSemanticElement() != null && (monitor = (MonitorCapability)Platform.getAdapterManager().getAdapter((Object)EngineVariable.INSTANCE.getSelectedDiagram().resolveSemanticElement(), MonitorCapability.class)) != null && monitor.getId() != null && EngineGlobal.engine != null) {
            try {
                Map<String, Map<String, Object>> map = EngineGlobal.engine.getLstInstanciatedIds(EngineVariable.INSTANCE.getSessionId(), monitor.getId());
                sessionSourceProvider.setSessionMacthEditor(map != null);
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, "An exception occured : ", ex);
            }
        }
    }

    public static interface ISessionListenerManager {
        public Collection<IUIListener> getListeners(String var1);

        public Collection<IUIListener> getListenersBySession(String var1);
    }

    public static interface IUIListener {
        public static final String SERVICE_PROPERTY_MODEL_ID = "com.indy.ui.engine.IUIListener.modelId";
        public static final String SERVICE_PROPERTY_SESSION_ID = "com.indy.ui.engine.IUIListener.sessionId";

        public void refresh();
    }
}

