/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine.action;

import com.indy.engine.core.common.objects2.SessionDataExchange;
import com.indy.ui.engine.ClientVariable;
import com.indy.ui.engine.EngineGlobal;
import com.indy.ui.engine.session.monitoring.SessionMonitoringEditorInput;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class MonitorSessionAction
implements IViewActionDelegate {
    private SessionMonitoringEditorInput editorInput;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public void run(IAction action) {
        if (this.editorInput != null) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)this.editorInput, "com.indy.ui.engine.session.monitoring.SessionMonitoringEditor");
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, "An exception occured : ", ex);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        SessionDataExchange sde;
        this.editorInput = null;
        if (!selection.isEmpty() && (sde = (SessionDataExchange)((IStructuredSelection)selection).getFirstElement()).getStatus() != 10 && sde.getStatus() != 9) {
            try {
                ClientVariable var;
                Map<String, Object> o;
                Map<String, Map<String, Object>> tmGlobalVariables = EngineGlobal.getEngine().getLstRootSessionVariables(sde.getId());
                String actionRootID = null;
                if (tmGlobalVariables != null && (o = tmGlobalVariables.get("CORE_ROOT_ID")) != null && (var = new ClientVariable(o)) != null) {
                    actionRootID = var.getValue();
                    this.editorInput = new SessionMonitoringEditorInput(sde.getId(), actionRootID, sde.getName());
                }
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "An exception occured : ", e);
            }
        }
        action.setEnabled(this.editorInput != null);
    }

    public void init(IViewPart view) {
    }
}

