/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine.session;

import com.indy.engine.core.common.objects2.ISessionDataExchange;
import com.indy.ui.custom.out.EngineVariable;
import com.indy.ui.custom.out.IndyEventManager;
import com.indy.ui.custom.out.Util;
import com.indy.ui.engine.EngineGlobal;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class SessionAction
implements IViewActionDelegate {
    private ISelection selection;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        final String id = Util.extractActionType((IAction)action);
        if (EngineGlobal.isConnected()) {
            final String sessionId = EngineVariable.INSTANCE.getSessionId();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        if (id.equals("RESTART")) {
                            EngineGlobal.getEngine().restartSession(sessionId);
                        } else if (id.equals("START")) {
                            EngineGlobal.getEngine().executeSession(sessionId);
                        }
                        if (id.equals("STOP")) {
                            EngineGlobal.getEngine().stopSession(sessionId, false);
                        } else if (id.equals("PAUSE")) {
                            EngineGlobal.getEngine().stopSession(sessionId, true);
                        } else if (id.equals("DELETE")) {
                            if (SessionAction.this.selection instanceof StructuredSelection) {
                                Object[] objectArray = ((StructuredSelection)SessionAction.this.selection).toArray();
                                int n = objectArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object obj = objectArray[n2];
                                    if (obj instanceof ISessionDataExchange) {
                                        EngineGlobal.getEngine().deleteSession(((ISessionDataExchange)obj).getId());
                                    }
                                    ++n2;
                                }
                            }
                            EngineVariable.INSTANCE.setSessionId("-1");
                            IndyEventManager.INSTANCE.handleEvent("EngineListener", (Object)"SelectionChanged");
                        } else if (id.equals("DELETE_HIERARCHY")) {
                            HashSet set = new HashSet();
                            Object[] objectArray = ((StructuredSelection)SessionAction.this.selection).toArray();
                            int n = objectArray.length;
                            int n3 = 0;
                            while (n3 < n) {
                                Object obj = objectArray[n3];
                                if (obj instanceof ISessionDataExchange) {
                                    SessionAction.addAllHierarchy(((ISessionDataExchange)obj).getId(), set);
                                }
                                ++n3;
                            }
                            for (String sessionId2 : set) {
                                EngineGlobal.getEngine().deleteSession(sessionId2);
                            }
                            EngineVariable.INSTANCE.setSessionId("-1");
                            IndyEventManager.INSTANCE.handleEvent("EngineListener", (Object)"SelectionChanged");
                        }
                    }
                    catch (Exception e) {
                        SessionAction.this.logger.log(Level.WARNING, "An exception occured : ", e);
                    }
                }
            };
            new Thread(runnable).start();
        }
    }

    private static void addAllHierarchy(String parent, Set<String> set) {
        if (set.contains(parent)) {
            return;
        }
        set.add(parent);
        Set<String> children = EngineGlobal.getSessionList().getChildrenSession().get(parent);
        if (children != null) {
            for (String child : children) {
                SessionAction.addAllHierarchy(child, set);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        String id = Util.extractActionType((IAction)action);
        if (id.equals("DELETE")) {
            action.setEnabled(true);
            return;
        }
        action.setEnabled(false);
        Object[] objs = ((StructuredSelection)selection).toArray();
        if (objs.length == 1) {
            ISessionDataExchange sess = (ISessionDataExchange)objs[0];
            if (id.equals("RESTART") && (sess.getStatus() == -1 || sess.getStatus() == -2)) {
                action.setEnabled(true);
                return;
            }
            if (id.equals("STOP") && sess.getStatus() == 2) {
                action.setEnabled(true);
                return;
            }
            if (id.equals("START") && sess.getStatus() == 10) {
                action.setEnabled(true);
                return;
            }
        }
        if (id.equals("DELETE_HIERARCHY")) {
            Object[] objectArray = objs;
            int n = objs.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof ISessionDataExchange) {
                    ISessionDataExchange sess = (ISessionDataExchange)obj;
                    Set<String> set = EngineGlobal.getSessionList().getChildrenSession().get(sess.getId());
                    if (set != null && set.size() > 0) {
                        action.setEnabled(true);
                        return;
                    }
                }
                ++n2;
            }
        }
    }
}

