/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine.session;

import com.indy.engine.core.common.objects2.ISessionDataExchange;
import com.indy.ui.custom.out.EngineVariable;
import com.indy.ui.custom.out.IndyEventManager;
import com.indy.ui.engine.EngineServerWrapper;
import com.indy.ui.engine.session.ISessionListViewer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SessionList {
    private Map<String, ISessionDataExchange> allSessions = new HashMap<String, ISessionDataExchange>();
    private Map<String, ISessionDataExchange> rootSessions = new HashMap<String, ISessionDataExchange>();
    private Map<String, Set<String>> childrenSessionsId = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> orphan = new HashMap<String, Set<String>>();
    private Set<ISessionListViewer> changeListeners = new HashSet<ISessionListViewer>();

    public Map<String, Set<String>> getChildrenSession() {
        return this.childrenSessionsId;
    }

    public Collection<ISessionDataExchange> getRootSessions() {
        return this.rootSessions.values();
    }

    public Map<String, ISessionDataExchange> getAllSessionsMap() {
        return this.allSessions;
    }

    public void addSession(ISessionDataExchange session) {
        Set<String> set;
        String parentId = null;
        try {
            parentId = session.getParentSessionId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ISessionDataExchange parent = null;
        if (parentId != null) {
            parent = this.allSessions.get(parentId);
        }
        if (parent != null) {
            set = this.childrenSessionsId.get(parentId);
            if (set == null) {
                set = new HashSet<String>();
                this.childrenSessionsId.put(parentId, set);
            }
            set.add(session.getId());
            this.rootSessions.remove(session.getId());
        } else {
            this.rootSessions.put(session.getId(), session);
            set = this.orphan.get(parentId);
            if (set == null) {
                set = new HashSet<String>();
                this.orphan.put(parentId, set);
            }
            set.add(session.getId());
        }
        Set<String> _set = this.orphan.get(session.getId());
        if (_set != null && _set.size() > 0) {
            this.childrenSessionsId.put(session.getId(), _set);
            this.orphan.remove(session.getId());
            for (String id : _set) {
                this.rootSessions.remove(id);
            }
        }
    }

    public void setSelection(ISessionDataExchange session) {
        Iterator<ISessionListViewer> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().setSelection(session);
        }
    }

    public void synchronise(EngineServerWrapper.EngineIterator tmSessions) {
        Iterator<ISessionDataExchange> iter = tmSessions.iterator();
        HashSet<ISessionDataExchange> sessionToRemoved = new HashSet<ISessionDataExchange>();
        sessionToRemoved.addAll(this.allSessions.values());
        String sessionId = EngineVariable.INSTANCE.getSessionId();
        sessionId = sessionId != null && !sessionId.equals("-1") ? sessionId : "";
        boolean sessionChanged = false;
        ArrayList<Object> sessionToAdded = new ArrayList<Object>();
        ArrayList<ISessionDataExchange> sessionsChanged = new ArrayList<ISessionDataExchange>();
        while (iter.hasNext()) {
            ISessionDataExchange iSessionDataExchange = iter.next();
            ISessionDataExchange sessionNew = iSessionDataExchange;
            ISessionDataExchange sessionOld = this.findSession(sessionNew);
            if (sessionOld != null) {
                sessionToRemoved.remove(sessionOld);
                if (!this.isSessionChangedStatus(sessionNew, sessionOld) && (sessionNew.getEndDate() != null || sessionNew.getStatus() == 10) && (sessionOld.getEndDate() == null || sessionNew.getEndDate() != null && sessionNew.getEndDate().compareTo(sessionOld.getEndDate()) == 0)) continue;
                sessionOld.setStatus(sessionNew.getStatus());
                sessionOld.setLogType(sessionNew.getLogType());
                sessionOld.setEndDate(sessionNew.getEndDate());
                sessionOld.setBeginDate(sessionNew.getBeginDate());
                sessionOld.setLaunchMode(sessionNew.getLaunchMode());
                sessionOld.setExecutionMode(sessionNew.getExecutionMode());
                sessionOld.setIter(sessionNew.getIter());
                sessionsChanged.add(sessionOld);
                if (!sessionNew.getId().equals(sessionId)) continue;
                sessionChanged = true;
                continue;
            }
            sessionToAdded.add(sessionNew);
            if (!sessionNew.getId().equals(sessionId)) continue;
            sessionChanged = true;
        }
        tmSessions.clean();
        for (ISessionDataExchange iSessionDataExchange : sessionToAdded) {
            this.allSessions.put(iSessionDataExchange.getId(), iSessionDataExchange);
        }
        for (ISessionDataExchange iSessionDataExchange : sessionToRemoved) {
            this.allSessions.remove(iSessionDataExchange.getId());
        }
        for (ISessionDataExchange iSessionDataExchange : sessionToAdded) {
            this.addSession(iSessionDataExchange);
        }
        for (ISessionDataExchange iSessionDataExchange : sessionToRemoved) {
            this.removeSession(iSessionDataExchange);
        }
        Iterator<ISessionListViewer> iterator = this.changeListeners.iterator();
        for (ISessionListViewer viewer : this.changeListeners) {
            if (sessionsChanged.size() > 0) {
                viewer.updateSessions(sessionsChanged.toArray());
            }
            if (sessionToAdded.size() > 0) {
                viewer.addSessions(sessionToAdded.toArray());
            }
            if (sessionToRemoved.size() > 0) {
                viewer.removeSessions(sessionToRemoved.toArray());
            }
            if (sessionToAdded.size() <= 0 && sessionToRemoved.size() <= 0) continue;
            viewer.refresh();
        }
        if (sessionChanged) {
            IndyEventManager.INSTANCE.handleEvent("EngineListener", (Object)"SessionChanged");
        }
    }

    public boolean isSessionChangedStatus(ISessionDataExchange session1, ISessionDataExchange session2) {
        return session1.getStatus() != session2.getStatus() || !this.equalsString(session1.getLogType(), session2.getLogType());
    }

    private boolean equalsString(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        if (str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    public ISessionDataExchange findSession(ISessionDataExchange session) {
        return this.allSessions.get(session.getId());
    }

    public int size() {
        return this.allSessions.size();
    }

    public void removeSession(ISessionDataExchange session) {
        ISessionDataExchange exists = this.rootSessions.remove(session.getId());
        Set<String> ids = this.childrenSessionsId.get(session.getId());
        if (ids != null) {
            for (String id : ids) {
                ISessionDataExchange child = this.allSessions.get(id);
                if (child == null) continue;
                this.rootSessions.put(id, child);
            }
            this.orphan.put(session.getId(), ids);
        }
        if (session.getParentSessionId() != null) {
            Set<String> set = this.childrenSessionsId.get(session.getParentSessionId());
            if (set != null) {
                set.remove(session.getId());
            }
            if ((set = this.orphan.get(session.getParentSessionId())) == null) {
                set = new HashSet<String>();
                this.orphan.put(session.getParentSessionId(), set);
            }
            set.add(session.getId());
        }
    }

    public void removeAllSessions() {
        this.rootSessions.clear();
        this.childrenSessionsId.clear();
        this.allSessions.clear();
        this.orphan.clear();
        Iterator<ISessionListViewer> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().removeAllSessions();
        }
    }

    public void removeChangeListener(ISessionListViewer viewer) {
        this.changeListeners.remove(viewer);
    }

    public void addChangeListener(ISessionListViewer viewer) {
        this.changeListeners.add(viewer);
    }
}

