/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine.session;

import com.indy.engine.core.common.objects2.ISessionDataExchange;
import com.indy.ui.engine.api.v1_0.LocalGLobalVar;
import com.indy.ui.engine.util.Functions;
import java.util.Date;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class SessionSorter
extends ViewerSorter {
    public static final int BEGIN_DATE = 1;
    public static final int NAME = 2;
    public static final int STATUS = 3;
    public static final int ELAPSE_TIME = 4;
    public static final int CONFIGURATION = 5;
    public static final int ID = 6;
    public static final int LAUNCH_MODE = 7;
    public static final int ITERATION = 8;
    public static final int LOG_NAME = 9;
    public static final int LOG_TYPE = 10;
    public static final int ENGINE = 11;
    public static final int GUEST_HOST = 12;
    public static final int EXECUTION_MODE = 13;
    public static final int LAUNCH_USER = 14;
    private int criteria;
    private int sens;

    public SessionSorter(int criteria, int sens) {
        this.criteria = criteria;
        this.sens = sens;
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        ISessionDataExchange session1 = (ISessionDataExchange)o1;
        ISessionDataExchange session2 = (ISessionDataExchange)o2;
        switch (this.criteria) {
            case 1: {
                return this.collator.compare(Functions.getFormatDate(session2.getBeginDate()), Functions.getFormatDate(session1.getBeginDate())) * this.sens;
            }
            case 2: {
                return this.collator.compare(session1.getName(), session2.getName()) * this.sens;
            }
            case 6: {
                return this.collator.compare(session1.getId(), session2.getId()) * this.sens;
            }
            case 3: {
                return this.collator.compare(LocalGLobalVar.getStringEngineStatus(session1.getStatus()), LocalGLobalVar.getStringEngineStatus(session2.getStatus())) * this.sens;
            }
            case 9: {
                return this.collator.compare(session1.getLogName(), session2.getLogName()) * this.sens;
            }
            case 10: {
                return this.collator.compare(session1.getLogType(), session2.getLogType()) * this.sens;
            }
            case 4: {
                long e1 = session1.getEndDate() != null ? session1.getEndDate().getTime() : System.currentTimeMillis();
                long e2 = session2.getEndDate() != null ? session2.getEndDate().getTime() : System.currentTimeMillis();
                long s1 = session1.getBeginDate().getTime();
                long s2 = session2.getBeginDate().getTime();
                return new Date(e1 - s1).compareTo(new Date(e2 - s2)) * this.sens;
            }
            case 11: {
                return this.collator.compare(String.valueOf(session1.getEngineHost()) + ":" + session2.getEnginePort(), String.valueOf(session2.getEngineHost()) + ":" + session2.getEnginePort()) * this.sens;
            }
            case 12: {
                if (session1.getGuestHost() != null && session2.getGuestHost() != null) {
                    return this.collator.compare(session1.getGuestHost(), session2.getGuestHost()) * this.sens;
                }
            }
            case 7: {
                if (session1.getLaunchMode() != null && session2.getLaunchMode() != null) {
                    return this.collator.compare(session1.getLaunchMode(), session2.getLaunchMode()) * this.sens;
                }
            }
            case 13: {
                if (session1.getExecutionMode() == null || session2.getExecutionMode() == null) break;
                return this.collator.compare(session1.getExecutionMode(), session2.getExecutionMode()) * this.sens;
            }
        }
        return 0;
    }

    public int getCriteria() {
        return this.criteria;
    }
}

