/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine.session;

import com.indy.ui.engine.Activator;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.List;

public class SessionsMonitorState {
    public static final String PROP_FILTER = "session.filter";
    public static final String PROP_STATUS = "session.status";
    public static final String PROP_SESSION_NUMBER = "session.number";
    public static final String PROP_LOCAL_SESSION = "session.local";
    public static final String PROP_CURRENT_RUNTIME = "session.currentRuntime";
    public static final String PROP_FREQUENCY_UNFIT = "session.refresh.frequency.unfit";
    private String filter;
    private List<Integer> status = null;
    private int nbSessions = 0;
    private boolean isLocal;
    private boolean currentRuntime;
    private boolean durationTooLong = false;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private static final SessionsMonitorState INSTANCE = new SessionsMonitorState();

    public static SessionsMonitorState getInstance() {
        return INSTANCE;
    }

    private SessionsMonitorState() {
        this.filter = Activator.getDefault().getPreferenceStore().getString("engineFilterName");
        this.isLocal = Activator.getDefault().getPreferenceStore().getBoolean("engineFilterMySessions");
        this.nbSessions = Activator.getDefault().getPreferenceStore().getInt("engineNbSessions");
        this.currentRuntime = Activator.getDefault().getPreferenceStore().getBoolean("currentEngine");
        String status = Activator.getDefault().getPreferenceStore().getString("engineFilterStatus");
        if (status != null) {
            try {
                this.status = Arrays.asList(Integer.valueOf(status));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    public void removeListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
        Activator.getDefault().getPreferenceStore().setValue("engineFilterName", filter);
        this.listeners.firePropertyChange(PROP_FILTER, null, filter);
    }

    public List<Integer> getStatus() {
        return this.status;
    }

    public void setStatus(List<Integer> status) {
        this.status = status;
        Activator.getDefault().getPreferenceStore().setValue("engineFilterStatus", status == null || status.isEmpty() ? "" : "" + status.get(0));
        this.listeners.firePropertyChange(PROP_STATUS, null, status);
    }

    public int getNbSessions() {
        return this.nbSessions;
    }

    public void setNbSessions(int nbSessions) {
        this.nbSessions = nbSessions;
        Activator.getDefault().getPreferenceStore().setValue("engineNbSessions", String.valueOf(nbSessions));
        this.listeners.firePropertyChange(PROP_SESSION_NUMBER, null, (Object)nbSessions);
    }

    public boolean onlyLocal() {
        return this.isLocal;
    }

    public void setSessionLocal(boolean isLocal) {
        this.isLocal = isLocal;
        Activator.getDefault().getPreferenceStore().setValue("engineFilterMySessions", isLocal);
        this.listeners.firePropertyChange(PROP_LOCAL_SESSION, null, (Object)isLocal);
    }

    public void setSessionTimeTooLong(boolean durationTooLong) {
        if (this.durationTooLong != durationTooLong) {
            this.durationTooLong = durationTooLong;
            this.listeners.firePropertyChange(PROP_FREQUENCY_UNFIT, !durationTooLong, durationTooLong);
        }
    }

    public boolean isCurrentRuntime() {
        return this.currentRuntime;
    }

    public void setCurrentRuntime(boolean currentRuntime) {
        this.currentRuntime = currentRuntime;
        this.listeners.firePropertyChange(PROP_CURRENT_RUNTIME, !currentRuntime, currentRuntime);
    }
}

