/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine.session.monitoring;

import com.indy.ui.engine.session.monitoring.SessionMonitoringEditorInput;
import com.indy.ui.engine.session.monitoring.SessionUI;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class SessionMonitoringEditor
extends EditorPart {
    public static final String ID = "com.indy.ui.engine.session.monitoring.SessionMonitoringEditor";
    protected static final String AUTO_TEST = "com.indy.gmf.map.automatedTest";
    SessionUI sessionUI;
    Control sessionUIControl;
    Composite main;
    Mode mode = Mode.GRAPH;
    boolean supportBrowser = true;
    SessionMonitoringEditorInput editorInput;
    TabbedPropertySheetWidgetFactory factory;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input.getAdapter(SessionMonitoringEditorInput.class) instanceof SessionMonitoringEditorInput) {
            this.editorInput = (SessionMonitoringEditorInput)input;
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(this.editorInput);
            this.setPartName(this.editorInput.getName());
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        super.dispose();
        this.sessionUI.dispose();
        this.factory.dispose();
    }

    public void createPartControl(Composite parent) {
        Composite main;
        if (this.factory == null) {
            this.factory = new TabbedPropertySheetWidgetFactory();
        }
        this.main = main = this.factory.createComposite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        ((GridLayout)main.getLayout()).verticalSpacing = 0;
        Composite mode = this.factory.createComposite(main, 0);
        mode.setLayout((Layout)new GridLayout(2, false));
        ((GridLayout)mode.getLayout()).marginHeight = 0;
        mode.setLayoutData((Object)new GridData(4, 1, true, false));
        Button b1 = this.factory.createButton(mode, "Graph", 16);
        b1.setLayoutData((Object)new GridData());
        b1.setSelection(true);
        Button b2 = this.factory.createButton(mode, "Time", 16);
        b2.setLayoutData((Object)new GridData());
        b1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionMonitoringEditor.this.setMode(Mode.GRAPH);
            }
        });
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionMonitoringEditor.this.setMode(Mode.TIME);
            }
        });
        EnvironmentInfo service = (EnvironmentInfo)PlatformUI.getWorkbench().getService(EnvironmentInfo.class);
        if (service != null) {
            if ("linux".equals(Platform.getOS())) {
                String o;
                String gtkVersion = service.getProperty("org.eclipse.swt.internal.gtk.version");
                if (gtkVersion != null && gtkVersion.compareTo("3") < 0) {
                    this.supportBrowser = false;
                }
                if ((o = service.getProperty(AUTO_TEST)) != null && Boolean.parseBoolean(o)) {
                    this.supportBrowser = false;
                }
            } else {
                this.supportBrowser = true;
            }
        }
        this.sessionUI = new SessionUI(this.mode.html, this.editorInput.getSessionId(), this.editorInput.getStepId());
        this.sessionUIControl = this.sessionUI.createPartControl(main, this.supportBrowser);
        this.sessionUIControl.setLayoutData((Object)new GridData(1808));
        this.sessionUI.setEnabled(true);
    }

    public void setFocus() {
    }

    private void setMode(Mode mode) {
        this.mode = mode;
        List<String> path = null;
        if (this.sessionUI != null && this.sessionUIControl != null && !this.sessionUIControl.isDisposed()) {
            path = this.sessionUI.getStepId();
        }
        if (this.sessionUIControl != null && !this.sessionUIControl.isDisposed()) {
            this.sessionUIControl.dispose();
        }
        if (this.sessionUI != null) {
            this.sessionUI.dispose();
        }
        this.sessionUI = new SessionUI(this.mode.html, this.editorInput.getSessionId(), path == null ? this.editorInput.getStepId() : path.get(0));
        this.sessionUIControl = this.sessionUI.createPartControl(this.main, this.supportBrowser);
        this.sessionUIControl.setLayoutData((Object)new GridData(1808));
        this.sessionUI.setEnabled(true);
        this.main.layout(true, true);
    }

    static enum Mode {
        TIME("timeline.html"),
        GRAPH("graph.html");

        String html;

        private Mode(String html) {
            this.html = html;
        }
    }
}

