/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine.session.monitoring;

import com.indy.ui.custom.out.IndyEventManager;
import com.indy.ui.engine.EngineGlobal;
import com.indy.ui.engine.EngineServerWrapper;
import com.indy.ui.engine.WatchEngine;
import com.indy.ui.engine.session.monitoring.Messages;
import com.indy.ui.engine.view.ActionView;
import com.semarchy.xdi.designer.core.MonitorCapability;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jetty.server.Server;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class SessionUI
implements WatchEngine.IUIListener {
    static Server server = null;
    static Thread th = null;
    Browser browser;
    ServiceRegistration<WatchEngine.IUIListener> reg = null;
    private String urlPath;
    private boolean enabled = false;
    private IndyEventManager.IndyEventListener sessionChangeListener = new IndyEventManager.IndyEventListener(){

        public void notify(Object event) {
            event.equals("CurrentSessionChanged");
        }
    };
    private String sessionId;
    private String stepId;

    public SessionUI(String htmlURL, String sessionId, String stepId) {
        this.urlPath = htmlURL;
        this.sessionId = sessionId;
        this.stepId = stepId;
        if (this.reg == null) {
            Bundle b = Platform.getBundle((String)"com.indy.gmf.process.diagram.non_rcp");
            BundleContext ctx = b.getBundleContext();
            Properties d = new Properties();
            ((Dictionary)d).put("com.indy.ui.engine.IUIListener.sessionId", sessionId);
            this.reg = ctx.registerService(WatchEngine.IUIListener.class, (Object)this, (Dictionary)d);
        }
        IndyEventManager.INSTANCE.addListener("EngineListener", this.sessionChangeListener);
    }

    public void dispose() {
        if (this.reg != null) {
            this.reg.unregister();
            this.reg = null;
        }
        IndyEventManager.INSTANCE.removeListener("EngineListener", this.sessionChangeListener);
    }

    public Control createPartControl(Composite parent, boolean embeddedBrowser) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        if (embeddedBrowser) {
            Browser b;
            this.browser = b = new Browser(main, 2048);
            b.setJavascriptEnabled(true);
            b.setLayoutData((Object)new GridData(1808));
            final BrowserFunction clickHandler = new BrowserFunction(b, "clickHandler"){

                public Object function(final Object[] arguments) {
                    if (arguments.length >= 2) {
                        final String id = (String)arguments[1];
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ActionView.refreshValues(new MonitorCapability(){

                                    public boolean isToleratedError() {
                                        return false;
                                    }

                                    public boolean isRootAndChild() {
                                        return false;
                                    }

                                    public boolean hasChildrenToRefresh() {
                                        return false;
                                    }

                                    public String getPath() {
                                        return null;
                                    }

                                    public String getName() {
                                        return (String)arguments[3];
                                    }

                                    public String getId() {
                                        return (String)arguments[2];
                                    }

                                    public String getCode() {
                                        return "";
                                    }
                                }, SessionUI.this.sessionId, id, true);
                            }
                        });
                    }
                    return super.function(arguments);
                }
            };
            main.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    clickHandler.dispose();
                    SessionUI.this.dispose();
                }
            });
        } else {
            Button bt = new Button(main, 8);
            bt.setText(Messages.SessionUI_1);
            bt.setLayoutData((Object)new GridData());
            bt.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(SessionUI.this.getURL()));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        return main;
    }

    @Override
    public void refresh() {
        if (!this.enabled || this.browser == null) {
            return;
        }
        try {
            String url = this.getURL();
            if (url == null) {
                this.browser.setUrl("#");
            } else if (this.browser.getUrl() == null || !this.browser.getUrl().equalsIgnoreCase(url)) {
                Browser.clearSessions();
                this.browser.setUrl(this.getURL());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled && this.browser != null) {
            try {
                String url = this.getURL();
                if (this.browser.getUrl() == null || !this.browser.getUrl().equals(url)) {
                    Browser.clearSessions();
                    this.browser.setUrl(url);
                }
            }
            catch (Exception ex) {
                this.browser.setUrl("#");
            }
        } else {
            this.browser.setUrl("#");
        }
    }

    private String getURL() throws Exception {
        EngineServerWrapper w = EngineGlobal.getEngine();
        if (w != null) {
            return String.valueOf(w.getHttpEndpoint()) + "graphSession/" + this.urlPath + "?sessionId=" + this.sessionId + "&stepId=" + this.stepId;
        }
        return null;
    }

    public List<String> getStepId() {
        if (this.browser != null) {
            try {
                Object res = this.browser.evaluate("return renderer.navState.items.slice(0, renderer.navState.current+1)", true);
                ArrayList<String> path = new ArrayList<String>();
                if (res instanceof Object[]) {
                    Object[] objectArray = (Object[])res;
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        path.add((String)o);
                        ++n2;
                    }
                }
                if (res instanceof String) {
                    return path;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }
}

