/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine.variable;

import com.indy.engine.core.common.objects2.IVariable;
import com.indy.ui.engine.ClientVariable;
import com.indy.ui.engine.variable.IVariableListViewer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class VariableList {
    private final int COUNT = 10;
    private Vector<IVariable> variables = new Vector(10);
    private Set<IVariableListViewer> changeListeners = new HashSet<IVariableListViewer>();
    static final String[] OWNERS_ARRAY = new String[]{"?", "Nancy", "Larry", "Joe"};

    public Vector<IVariable> getVariables() {
        return this.variables;
    }

    public void addVariable(IVariable session) {
        this.variables.add(this.variables.size(), session);
        Iterator<IVariableListViewer> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().addVariable(session);
        }
    }

    public void synchronise(Map<String, Object> tmVariables, String filter) {
        if (tmVariables != null) {
            String _value;
            Object value;
            Iterator<String> iter = tmVariables.keySet().iterator();
            int countDiff = 0;
            if (this.size() != tmVariables.size()) {
                ++countDiff;
            }
            while (iter.hasNext() && countDiff == 0) {
                String key = iter.next();
                value = tmVariables.get(key);
                IVariable varNew = value instanceof Map ? new ClientVariable((Map)value) : (IVariable)value;
                _value = varNew.getValue();
                if (filter != null && _value != null && _value.equals(filter)) continue;
                int i = this.findVariable(varNew);
                if (i >= 0) {
                    IVariable varOld = this.variables.get(i);
                    if (!this.hasVariableChanged(varNew, varOld)) continue;
                    ++countDiff;
                    continue;
                }
                if (i >= 0) continue;
                ++countDiff;
            }
            if (countDiff > 0) {
                this.removeAllVariables();
                for (String key : tmVariables.keySet()) {
                    value = tmVariables.get(key);
                    IVariable var = null;
                    var = value instanceof Map ? new ClientVariable((Map)value) : (IVariable)value;
                    _value = var.getValue();
                    if (filter != null && _value != null && _value.equals(filter)) continue;
                    this.addVariable(var);
                }
            }
        } else {
            this.removeAllVariables();
        }
    }

    public boolean hasVariableChanged(IVariable var1, IVariable var2) {
        if (var1 != null && var2 != null && var1.getType() != null && var2.getType() != null && var2.getType().equals(var1.getType()) && var1.getValue() != null && var2.getValue() != null && var2.getValue().equals(var1.getValue())) {
            return false;
        }
        return var1 != var2;
    }

    public int findVariable(IVariable var) {
        int i = 0;
        while (i < this.variables.size()) {
            if (var.getName().equals(this.variables.get(i).getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int size() {
        return this.variables.size();
    }

    public void removeVariable(IVariable session) {
        this.variables.remove(session);
        Iterator<IVariableListViewer> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().removeVariable(session);
        }
    }

    public void variableChanged(IVariable session) {
        Iterator<IVariableListViewer> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().updateVariable(session);
        }
    }

    public void removeAllVariables() {
        this.variables.removeAllElements();
        Iterator<IVariableListViewer> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().removeAllVariable();
        }
    }

    public void removeChangeListener(IVariableListViewer viewer) {
        this.changeListeners.remove(viewer);
    }

    public void addChangeListener(IVariableListViewer viewer) {
        this.changeListeners.add(viewer);
    }
}

