/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine.view;

import com.indy.administration.AdministrationHelper;
import com.indy.administration.AdministrationListener;
import com.indy.engine.command.EngineCommandsRemote;
import com.indy.engine.core.common.CommonVersion;
import com.indy.ui.conf.custom.preference.ConfPreferenceConstants;
import com.indy.ui.conf.custom.tool.ConfUtil;
import com.indy.ui.custom.out.EngineVariable;
import com.indy.ui.custom.out.INoPropertySheetProvider;
import com.indy.ui.custom.out.IndyEventManager;
import com.indy.ui.custom.out.Util;
import com.indy.ui.engine.Activator;
import com.indy.ui.engine.EngineGlobal;
import com.indy.ui.engine.EventDispatcher;
import com.indy.ui.engine.Messages;
import com.indy.ui.engine.WatchEngine;
import com.indy.ui.engine.internal.EnvironmentConfiguration;
import com.indy.ui.engine.view.ActionView;
import com.indy.ui.engine.view.RuntimeWizard;
import com.indy.ui.out.qa.InternalIdentifier;
import com.semarchy.xdi.designer.core.indexation.IMdTechRegistry;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IEnvironmentConfiguration;
import com.semarchy.xdi.designer.core.services.IEvaluationConfigurationService;
import com.semarchy.xdi.designer.core.services.IInternalResourceRegistry;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.registry.RuntimeEngine;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.EMFResourceUtil;
import com.semarchy.xdi.designer.core.utils.RuntimeLocationHelper;
import com.semarchy.xdi.engine.common.EngineFactory;
import com.stambia.egc.EgcPackage;
import com.stambia.egc.Engine;
import com.stambia.egc.presentation.EgcEditor;
import com.stambia.egc.util.EgcResourceFactoryImpl;
import com.stambia.tech.Level;
import com.stambia.tech.Tech;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Authenticator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.console.IOConsolePage;
import org.eclipse.ui.internal.console.IOConsoleViewer;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;

public class EngineView
extends ViewPart
implements INoPropertySheetProvider,
IRegistryService.IRegistryItemEventListener,
IEvaluationConfigurationService.IConfigurationChangeListener,
AdministrationListener,
ICacheService.ICacheServiceListener,
IRegistryService.IRegistryBatchEventListener {
    private static final String DEFAULT_RUNTIME_ENGINE_MD_ID = "UUID_MD_RUNTIME_EMBEDDED";
    private static final String DEFAULT_RUNTIME_ENGINE_MD_NAME = "Embedded Runtime - admin user";
    public static final String ID = "com.indy.ui.custom.engine.EngineView";
    private Composite top = null;
    private Button cbConnectToEngine = null;
    private static Label lStatus = null;
    private static Button cbRefreshDiagram = null;
    private ComboViewer cvReport;
    IWorkbenchPage workbenchPage;
    private ResourceSetImpl rs;
    private volatile boolean cacheInited = false;
    private volatile boolean runtimeRegistryChanged = false;
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ArrayList<URI> changedResources = new ArrayList();

                    ResourceDeltaVisitor() {
                    }

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getResource().getType() == 1 && (delta.getKind() == 1 || delta.getKind() == 2 || delta.getKind() == 4 && delta.getFlags() != 131072)) {
                            IPath path = delta.getMovedToPath() != null ? delta.getMovedToPath() : delta.getFullPath();
                            URI uri1 = URI.createURI((String)path.toString());
                            URI uri2 = ConfUtil.getEgcURI();
                            if (uri1 != null && uri2 != null && uri1.toString().equals("/" + uri2.toString())) {
                                this.changedResources.add(uri1);
                            }
                        }
                        return true;
                    }

                    public Collection<URI> getChangedResources() {
                        return this.changedResources;
                    }
                }
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getChangedResources().isEmpty()) {
                    EngineView.this.refreshRuntimes();
                }
            }
            catch (CoreException exception) {
                exception.printStackTrace();
            }
        }
    };
    private EnvironmentConfiguration.EngineInfoWrapper reportEngine;
    private Button bEditConnection;
    private Job refreshRuntimeJob = null;
    Map<String, Process> processMap = new HashMap<String, Process>();
    private static Label lStatusIcon;
    Thread thread;
    private CommandDialog diag = null;
    private EventDispatcher.RuntimeListener runtimeListener;
    public static final int CONNECTED_STATUS = 0;
    public static final int DISCONNECTED_STATUS = 1;
    public static final int CONNECTING_STATUS = 2;
    public static final int RECONNECTING_STATUS = 3;
    public static final int DISCONNECTING_STATUS = 4;
    public static final int WAITING_STATUS = 5;
    public static final int SSL_CONNECTED_STATUS = 6;
    public static int countRetry;
    private ServiceRegistration<ICacheService.ICacheServiceListener> serviceRegistration;

    static {
        countRetry = 0;
    }

    public void dispose() {
        this.serviceRegistration.unregister();
        this.serviceRegistration = null;
        AdministrationHelper.removeListener((AdministrationListener)this);
        ((IEvaluationConfigurationService)E4InjectorHelper.getService(IEvaluationConfigurationService.class)).removeListener((IEvaluationConfigurationService.IConfigurationChangeListener)this);
        IRegistryService.IRegistry reg = ((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(RuntimeEngine.class);
        if (reg != null) {
            reg.removeRegistryItemEventListener((IRegistryService.IRegistryItemEventListener)this);
            reg.removeRegistryBatchEventListener((IRegistryService.IRegistryBatchEventListener)this);
            if (this.refreshRuntimeJob != null) {
                this.refreshRuntimeJob.cancel();
            }
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        EngineGlobal.stop = true;
        if (EngineGlobal.thread != null) {
            EngineGlobal.thread.interrupt();
        }
        super.dispose();
        this.processMap.clear();
        if (this.runtimeListener != null) {
            Activator.getDefault().getDispatcher().removeRuntimeListeners(this.runtimeListener);
        }
    }

    public Control createComboViewer(ComboViewer cv) {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        cv.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        cv.setContentProvider((IContentProvider)new ArrayContentProvider());
        IRegistryService.IRegistry reg = ((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(RuntimeEngine.class);
        if (reg != null) {
            reg.addRegistryItemEventListener((IRegistryService.IRegistryItemEventListener)this);
            reg.addRegistryBatchEventListener((IRegistryService.IRegistryBatchEventListener)this);
        }
        ((IEvaluationConfigurationService)E4InjectorHelper.getService(IEvaluationConfigurationService.class)).addListener((IEvaluationConfigurationService.IConfigurationChangeListener)this);
        return cv.getControl();
    }

    private void handleExecuteEngineChanged() {
        if (this.reportEngine != null) {
            ((IEnvironmentConfiguration)E4InjectorHelper.getService(IEnvironmentConfiguration.class)).setEngineConfiguration((IEnvironmentConfiguration.EngineConfiguration)this.reportEngine);
        }
    }

    public Button createCommandButton(Composite parent, String label, final String id, final boolean synchro, String internalIfForQA) {
        Button b = new Button(parent, 2048);
        b.setText(label);
        b.setData("qa", (Object)internalIfForQA);
        b.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                EngineView.this.executeCommand(id, synchro, new String[0]);
            }
        });
        GridData gridData = new GridData(768);
        b.setLayoutData((Object)gridData);
        return b;
    }

    public Thread executeCommand(String id, boolean synchro, String ... args) {
        String command;
        Process _proc;
        StringBuilder b = new StringBuilder();
        if (args != null) {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                b.append(" ");
                b.append(s);
                ++n2;
            }
        }
        if ((_proc = this.processMap.get(command = String.valueOf(ConfPreferenceConstants.getString((String)id)) + b.toString())) != null) {
            _proc.destroy();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Runtime rt = Runtime.getRuntime();
                    Map<String, String> map = System.getenv();
                    String[] envs = new String[map.size() + 1];
                    int l = 0;
                    for (String key : map.keySet()) {
                        envs[l++] = String.valueOf(key) + "=" + map.get(key);
                    }
                    String javaHome = Activator.getDefault().getBundle().getBundleContext().getProperty("java.home").trim();
                    envs[l++] = "STAMBIA_JAVA_HOME=" + javaHome;
                    rt.exec(command, envs, RuntimeLocationHelper.getRuntimeLocation());
                }
                catch (Exception e1) {
                    MessageConsole ms = Util.findConsole((String)"Command Console");
                    ms.activate();
                    try {
                        Throwable envs = null;
                        Object var4_10 = null;
                        try (MessageConsoleStream mcs = ms.newMessageStream();){
                            mcs.write(e1.getMessage());
                        }
                        catch (Throwable throwable) {
                            if (envs == null) {
                                envs = throwable;
                            } else if (envs != throwable) {
                                envs.addSuppressed(throwable);
                            }
                            throw envs;
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        };
        if (!synchro) {
            Thread thread = new Thread(runnable);
            thread.start();
            return thread;
        }
        runnable.run();
        return null;
    }

    public boolean ping(EnvironmentConfiguration.EngineInfoWrapper engine) throws Exception {
        boolean isHttpServer;
        HashMap<String, String> credentials = new HashMap<String, String>();
        if (engine.getLogin() != null && !engine.getLogin().isEmpty()) {
            credentials.put("user", engine.getLogin());
            credentials.put("password", engine.getPassword());
        }
        if (isHttpServer = engine.getHost().startsWith("http")) {
            Authenticator.setDefault(null);
        }
        try {
            EngineFactory.getEngine((String)engine.getHost(), (int)new Integer(engine.getPort()), credentials);
        }
        finally {
            if (isHttpServer) {
                WatchEngine.restoreDefaultHttpAuthenticator();
            }
        }
        return true;
    }

    public void createStartCommandButton(Composite parent) {
        Button cmdButton = new Button(parent, 0);
        cmdButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                EngineView.this.executeStartCommand();
            }
        });
        cmdButton.setText(Messages.EngineView_27);
    }

    public void executeStartCommand() {
        try {
            final IOConsole c = EngineView.findIOConsole("RuntimeCommand", true);
            c.activate();
            if (this.thread != null) {
                while (this.thread.isAlive()) {
                    Thread.currentThread();
                    Thread.sleep(10L);
                }
            }
            this.thread = new Thread(){

                @Override
                public void run() {
                    Throwable throwable = null;
                    Object var2_3 = null;
                    try (PrintStream ps = new PrintStream((OutputStream)c.newOutputStream());){
                        EngineCommandsRemote ec = new EngineCommandsRemote((InputStream)c.getInputStream(), ps){

                            protected boolean checkLine(String line, PrintStream out) {
                                if (line.contains("schedule") && !AdministrationHelper.supportScheduler()) {
                                    out.println(Messages.EngineView_scheduler_permission_missing);
                                    return false;
                                }
                                return super.checkLine(line, out);
                            }
                        };
                        ec.executeNew();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            };
            this.thread.start();
        }
        catch (Exception e1) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.EngineView_29, (String)e1.getMessage());
        }
    }

    public static IOConsole findIOConsole(String name, boolean removeIfExists) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                if (removeIfExists) {
                    conMan.removeConsoles(new IConsole[]{(IOConsole)existing[i]});
                } else {
                    return (IOConsole)existing[i];
                }
            }
            ++i;
        }
        IOConsole myConsole = new IOConsole(name, null){

            public IPageBookViewPage createPage(IConsoleView view) {
                return new IOConsolePage((TextConsole)this, view){

                    protected TextConsoleViewer createViewer(Composite parent) {
                        final IOConsoleViewer v = new IOConsoleViewer(parent, (TextConsole)this.getConsole());
                        v.addTextListener(new ITextListener(){

                            public void textChanged(TextEvent event) {
                                StyledText text = v.getTextWidget();
                                text.setCaretOffset(text.getCharCount());
                            }
                        });
                        return v;
                    }
                };
            }
        };
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    public void createStartDialogButton(Composite parent) {
        this.diag = new CommandDialog(Display.getCurrent().getActiveShell(), Messages.EngineView_30);
        Button openStart = new Button(parent, 0);
        openStart.setText(Messages.EngineView_31);
        openStart.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                EngineView.this.openEnironmentDialog();
            }
        });
    }

    public void openEnironmentDialog() {
        this.diag.open();
    }

    public void createPartControl(Composite parent) {
        this.setTitleToolTip(this.getTitle());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.indy.ui.help.redirects/designer/runtime-view");
        this.top = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        this.top.setLayout((Layout)gridLayout);
        this.cvReport = new ComboViewer(this.top);
        this.createComboViewer(this.cvReport);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.cvReport.getControl().setLayoutData((Object)gridData);
        this.cvReport.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EngineView.this.reportEngine = new EnvironmentConfiguration.EngineInfoWrapper(EngineView.this.cvReport.getStructuredSelection().getFirstElement());
                EngineView.this.handleExecuteEngineChanged();
            }
        });
        this.cvReport.getCombo().setEnabled(AdministrationHelper.supportRuntimeSelection());
        AdministrationHelper.addListener((AdministrationListener)this);
        Button pingButton = new Button(this.top, 0);
        gridData = new GridData();
        pingButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                try {
                    EngineView.this.ping(EngineView.this.reportEngine);
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.EngineView_33, (String)Messages.EngineView_34);
                }
                catch (Exception e1) {
                    MessageDialog.openError((Shell)new Shell(), (String)Messages.EngineView_35, (String)e1.getMessage());
                }
            }
        });
        pingButton.setText(Messages.EngineView_36);
        final Button openButton = new Button(this.top, 0);
        gridData = new GridData();
        openButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                EventDispatcher.RuntimeEvent ev = new EventDispatcher.RuntimeEvent();
                ev.type = EventDispatcher.RuntimeEventType.open;
                ev.host = EngineView.this.reportEngine.getHost();
                ev.port = EngineView.this.reportEngine.getPort();
                ev.name = EngineView.this.reportEngine.getName();
                ev.password = EngineView.this.reportEngine.getPassword();
                ev.user = EngineView.this.reportEngine.getLogin();
                Activator.getDefault().getDispatcher().dispatchEvent(ev);
            }
        });
        openButton.setText(Messages.EngineView_37);
        openButton.setEnabled(false);
        this.runtimeListener = new EventDispatcher.RuntimeListener(){

            @Override
            public void handleEvent(EventDispatcher.RuntimeEvent event) {
                if (event.type == EventDispatcher.RuntimeEventType.connect) {
                    openButton.setEnabled(true);
                } else if (event.type == EventDispatcher.RuntimeEventType.disconnect) {
                    openButton.setEnabled(false);
                }
            }
        };
        Activator.getDefault().getDispatcher().addRuntimeListeners(this.runtimeListener);
        Group connectGroup = new Group(this.top, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        connectGroup.setLayoutData((Object)gridData);
        connectGroup.setLayout((Layout)new GridLayout(1, false));
        Composite connectAndRefesh = new Composite((Composite)connectGroup, 0);
        gridData = new GridData(768);
        connectAndRefesh.setLayoutData((Object)gridData);
        RowLayout rl = new RowLayout();
        rl.marginBottom = 0;
        rl.marginHeight = 0;
        rl.marginRight = 0;
        rl.marginLeft = 0;
        rl.marginTop = 0;
        rl.marginWidth = 0;
        connectAndRefesh.setLayout((Layout)rl);
        Composite status = new Composite((Composite)connectGroup, 0);
        gridData = new GridData(768);
        status.setLayoutData((Object)gridData);
        GridLayout gl = new GridLayout(2, false);
        gl.marginBottom = 0;
        gl.marginHeight = 0;
        gl.marginRight = 0;
        gl.marginLeft = 0;
        gl.marginTop = 0;
        gl.marginWidth = 0;
        status.setLayout((Layout)gl);
        Composite connectComposite = new Composite(connectAndRefesh, 0);
        gl = new GridLayout(2, false);
        gl.marginBottom = 0;
        gl.marginHeight = 0;
        gl.marginRight = 0;
        gl.marginLeft = 0;
        gl.marginTop = 0;
        gl.marginWidth = 0;
        connectComposite.setLayout((Layout)gl);
        this.cbConnectToEngine = new Button(connectComposite, 32);
        this.cbConnectToEngine.setData("qa", (Object)InternalIdentifier.RUNTIME_VIEW_CHECKBOX_CONNECT_RUNTIME.getId());
        gridData = new GridData(1, 2, false, false, 2, 1);
        this.cbConnectToEngine.setLayoutData((Object)gridData);
        this.cbConnectToEngine.setText(Messages.EngineView_39);
        Composite refreshComposite = new Composite(connectAndRefesh, 0);
        gl = new GridLayout(2, false);
        gl.marginBottom = 0;
        gl.marginHeight = 0;
        gl.marginRight = 0;
        gl.marginLeft = 0;
        gl.marginTop = 0;
        gl.marginWidth = 0;
        refreshComposite.setLayout((Layout)gl);
        cbRefreshDiagram = new Button(refreshComposite, 32);
        cbRefreshDiagram.setText("dddddd");
        cbRefreshDiagram.setData("qa", (Object)InternalIdentifier.RUNTIME_VIEW_CHECKBOX_REFRESH_DIAGRAM.getId());
        gridData = new GridData(1, 2, false, false, 2, 1);
        cbRefreshDiagram.setLayoutData((Object)gridData);
        cbRefreshDiagram.setEnabled(false);
        cbRefreshDiagram.setSelection(Activator.getDefault().getPreferenceStore().getBoolean("runtimeRefreshDiagram"));
        EngineVariable.INSTANCE.setRefreshDiagram(cbRefreshDiagram.getSelection());
        cbRefreshDiagram.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionView.removeAll();
                EngineVariable.INSTANCE.setRefreshDiagram(cbRefreshDiagram.getSelection());
                IndyEventManager.INSTANCE.handleEvent("EngineListener", (Object)"RefreshEvent");
            }
        });
        cbRefreshDiagram.setText(Messages.EngineView_42);
        lStatusIcon = new Label(status, 0);
        gridData = new GridData(32);
        lStatusIcon.setLayoutData((Object)gridData);
        lStatus = new Label(status, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        lStatus.setLayoutData((Object)gridData);
        EngineView.setStatus(1, null, null, null);
        EngineGlobal.watchEngine = new WatchEngine();
        this.cbConnectToEngine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EngineView.this.cbConnectToEngine.getSelection()) {
                    EngineView.this.cvReport.getCombo().setEnabled(false);
                    EngineView.getRefreshDiagram().setEnabled(true);
                    EngineView.this.startListener();
                } else {
                    EngineView.this.stopListener();
                    EngineView.getRefreshDiagram().setEnabled(false);
                    EngineView.this.cvReport.getCombo().setEnabled(AdministrationHelper.supportRuntimeSelection());
                    ActionView.removeAll();
                }
            }
        });
        Composite down = new Composite(this.top, 0);
        down.setLayout((Layout)new FillLayout());
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        down.setLayoutData((Object)gridData);
        this.createStartDialogButton(down);
        this.createEditConnection(down);
        Composite downdown = new Composite(this.top, 0);
        downdown.setLayout((Layout)new FillLayout());
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        downdown.setLayoutData((Object)gridData);
        this.createStartCommandButton(downdown);
        this.refreshRuntimes();
    }

    private void createEditConnection(Composite down) {
        this.bEditConnection = new Button(down, 0);
        this.bEditConnection.setText(Messages.EngineView_43);
        this.bEditConnection.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                EngineView.this.openConfigurationEditor();
            }
        });
    }

    public void openConfigurationEditor() {
        IResource workspaceResource;
        URIEditorInput input;
        List l;
        final EnvironmentConfiguration.EngineInfoWrapper wrapper = new EnvironmentConfiguration.EngineInfoWrapper(((IStructuredSelection)this.cvReport.getSelection()).getFirstElement());
        IRegistryService.IRegistry registry = ((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(RuntimeEngine.class);
        if (registry != null && (l = registry.find(new IRegistryService.IRegistryMatcher(){

            public boolean match(Object o) {
                return o instanceof RuntimeEngine.RuntimeEngineKey && ((RuntimeEngine.RuntimeEngineKey)o).toString().equals(wrapper.getId());
            }
        })) != null && !l.isEmpty()) {
            String fileId = ((RuntimeEngine)l.get(0)).getKey().getProviderFileID();
            URI uri = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(fileId);
            if (uri != null) {
                input = new URIEditorInput(uri);
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page.openEditor((IEditorInput)input, "com.stambia.md.presentation.MdEditorID");
                    return;
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        }
        if ((workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(ConfUtil.getEgcURI().toString()))) != null && wrapper.getId() != null) {
            IFile modelFile;
            if (workspaceResource instanceof IFile && (modelFile = (IFile)workspaceResource).exists()) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    input = (EgcEditor)page.openEditor((IEditorInput)new FileEditorInput(modelFile), PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
                }
                catch (PartInitException e1) {
                    e1.printStackTrace();
                }
            }
        } else {
            IWorkbenchWindow activeWorkbenchWindow;
            List runtimeList = null;
            if (registry != null && registry.getAll() != null) {
                runtimeList = registry.getAll();
            }
            if ((activeWorkbenchWindow = Workbench.getInstance().getActiveWorkbenchWindow()) == null) {
                return;
            }
            StructuredSelection selectionToPass = new StructuredSelection(Collections.EMPTY_LIST);
            IMdTechRegistry techRegistry = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getMdTechRegistry();
            List uris = techRegistry.getTechUris();
            Tech runtimeTech = null;
            for (URI uri : uris) {
                if (!uri.lastSegment().contains("runtime.tech")) continue;
                ResourceSetImpl rss = new ResourceSetImpl();
                rss.setURIConverter((URIConverter)new InternalResourceURIConverter());
                Resource resource = rss.getResource(uri, true);
                runtimeTech = (Tech)EMFResourceUtil.getRootElement((Resource)resource);
                selectionToPass = new StructuredSelection((Object)runtimeTech);
                break;
            }
            IInternalResourceRegistry reg = (IInternalResourceRegistry)E4InjectorHelper.getService(IInternalResourceRegistry.class);
            Level runtimeLevel = (Level)runtimeTech.getLevel().get(0);
            RuntimeWizard mdWizard = new RuntimeWizard(runtimeList);
            mdWizard.setDefaultTech(reg.getProvidingComponent(runtimeTech.getId()), runtimeLevel, runtimeTech);
            mdWizard.init(activeWorkbenchWindow.getWorkbench(), (IStructuredSelection)selectionToPass, "_UI_Wizard_runtime_label");
            StructuredSelection ss = new StructuredSelection(Collections.EMPTY_LIST);
            WizardDialog wd = new WizardDialog(new Shell(), (IWizard)mdWizard);
            if (wd.open() == 0) {
                String resourcePath = workspaceResource.getFullPath().toString();
                if (resourcePath != null && resourcePath.startsWith("/")) {
                    while (resourcePath.startsWith("/")) {
                        resourcePath = resourcePath.substring(1);
                    }
                }
                ConfPreferenceConstants.setString((String)"egcFile", (String)resourcePath);
            }
        }
    }

    public static void setStatus(int status, String message, String remoteApiVersion, String remoteEngineVersion) {
        if (!lStatus.isDisposed()) {
            String text = "";
            lStatus.setData("qa", (Object)InternalIdentifier.RUNTIME_VIEW_LABEL_RUNTIME_CONNECTION_STATUS.getId());
            boolean warning = false;
            switch (status) {
                case 0: {
                    text = Messages.EngineView_46;
                    if (remoteApiVersion != null) {
                        String localVersion = null;
                        try {
                            localVersion = CommonVersion.getVersion();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        String msg = String.valueOf(Messages.EngineView_47) + remoteEngineVersion;
                        if (localVersion != null) {
                            int compare = remoteApiVersion.compareTo(localVersion);
                            if (compare == 0) {
                                lStatus.setToolTipText(msg);
                                lStatusIcon.setImage(Activator.getImage("icons/EngineConnected16x16.png"));
                                lStatusIcon.setToolTipText(lStatus.getToolTipText());
                            } else if (compare != 0) {
                                lStatusIcon.setImage(Activator.getImage("icons/EngineConnected16x16.png"));
                                lStatus.setToolTipText(String.valueOf(msg) + Messages.EngineView_52);
                                lStatusIcon.setToolTipText(lStatus.getToolTipText());
                            }
                        }
                    } else {
                        lStatusIcon.setImage(Activator.getImage("icons/EngineConnected16x16.png"));
                        lStatus.setToolTipText(null);
                    }
                    EngineGlobal.setStatus(1);
                    break;
                }
                case 1: {
                    lStatusIcon.setImage(Activator.getImage("icons/EngineNotConnected16x16.png"));
                    text = Messages.EngineView_58;
                    EngineGlobal.setStatus(0);
                    break;
                }
                case 2: {
                    if (countRetry == 0) {
                        lStatusIcon.setImage(Activator.getImage("icons/ConnectionTry1_16x16.png"));
                        countRetry = 1;
                    } else {
                        countRetry = 0;
                        lStatusIcon.setImage(Activator.getImage("icons/ConnectionTry2_16x16.png"));
                    }
                    text = Messages.EngineView_61;
                    EngineGlobal.setStatus(0);
                    break;
                }
                case 4: {
                    lStatusIcon.setImage(Activator.getImage("icons/EngineNotConnected16x16.png"));
                    text = Messages.EngineView_63;
                    EngineGlobal.setStatus(0);
                    break;
                }
                case 5: {
                    if (countRetry == 0) {
                        lStatusIcon.setImage(Activator.getImage("icons/ConnectionTry1_16x16.png"));
                        countRetry = 1;
                    } else {
                        countRetry = 0;
                        lStatusIcon.setImage(Activator.getImage("icons/ConnectionTry2_16x16.png"));
                    }
                    text = Messages.EngineView_66;
                    EngineGlobal.setStatus(0);
                    break;
                }
                case 3: {
                    if (countRetry == 0) {
                        lStatusIcon.setImage(Activator.getImage("icons/ConnectionTry1_16x16.png"));
                        countRetry = 1;
                    } else {
                        countRetry = 0;
                        lStatusIcon.setImage(Activator.getImage("icons/ConnectionTry2_16x16.png"));
                    }
                    text = Messages.EngineView_69;
                    EngineGlobal.setStatus(0);
                    break;
                }
                case 6: {
                    text = Messages.EngineView_46;
                    if (remoteApiVersion != null) {
                        String localVersion = null;
                        try {
                            localVersion = CommonVersion.getVersion();
                        }
                        catch (Exception msg) {
                            // empty catch block
                        }
                        String msg = String.valueOf(Messages.EngineView_47) + remoteEngineVersion;
                        if (localVersion != null) {
                            int compare = remoteApiVersion.compareTo(localVersion);
                            if (compare == 0) {
                                lStatus.setToolTipText(msg);
                                lStatusIcon.setImage(Activator.getImage("icons/EngineSSLConnected16x16.png"));
                                lStatusIcon.setToolTipText(lStatus.getToolTipText());
                            } else if (compare != 0) {
                                lStatusIcon.setImage(Activator.getImage("icons/EngineSSLConnected16x16.png"));
                                lStatus.setToolTipText(msg);
                                lStatusIcon.setToolTipText(lStatus.getToolTipText());
                            }
                        }
                    } else {
                        lStatusIcon.setImage(Activator.getImage("icons/EngineSSLConnected16x16.png"));
                        lStatus.setToolTipText(null);
                    }
                    EngineGlobal.setStatus(1);
                }
            }
            if (message != null) {
                text = String.valueOf(text) + message;
            }
            lStatus.setText(text);
        }
    }

    public static Button getRefreshDiagram() {
        return cbRefreshDiagram;
    }

    public EngineView() {
        try {
            this.cacheInited = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).isInit();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.serviceRegistration = Activator.getDefault().getBundle().getBundleContext().registerService(ICacheService.ICacheServiceListener.class, (Object)this, null);
    }

    public void setFocus() {
        this.top.setFocus();
    }

    public void startListener() {
        if (this.reportEngine.getId() != null) {
            Activator.getDefault().getPreferenceStore().setValue("lastConnectedRuntime", this.reportEngine.getName());
        } else {
            Activator.getDefault().getPreferenceStore().setToDefault("lastConnectedRuntime");
        }
        EngineView.setStatus(2, null, null, null);
        EngineGlobal.hasLoggedConnectionError = false;
        EngineGlobal.msQuick = WatchEngine.getQuickRefresh();
        EngineGlobal.msRefresh = EngineGlobal.msSlow = WatchEngine.getNormalRefresh();
        EngineGlobal.thread = new Thread((Runnable)EngineGlobal.watchEngine, "WatchEngine");
        EngineGlobal.thread.setName("WatchEngine");
        EngineGlobal.thread.start();
    }

    public void stopListener() {
        if (EngineGlobal.thread != null) {
            try {
                EngineGlobal.thread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        EngineGlobal.setEngine(null);
        EngineGlobal.stop = true;
        this.cbConnectToEngine.setEnabled(false);
        EngineView.setStatus(4, null, null, null);
        if (EngineGlobal.thread != null) {
            EngineGlobal.thread.interrupt();
        }
        this.cbConnectToEngine.setEnabled(true);
        if (this.cbConnectToEngine.getSelection()) {
            this.cbConnectToEngine.setSelection(false);
        }
        this.cvReport.getCombo().setEnabled(true);
        EngineView.getRefreshDiagram().setEnabled(true);
    }

    public void handleItemUpdated(IRegistryService.IRegistryKey registrationKey, Object item) {
        this.runtimeRegistryChanged = true;
    }

    public void handleItemRemoved(IRegistryService.IRegistryKey key, Object item) {
        this.runtimeRegistryChanged = true;
    }

    public void handleItemAdded(IRegistryService.IRegistryKey key, Object item) {
        this.runtimeRegistryChanged = true;
    }

    public void configurationChanged(String oldConfName, String newConfName) {
        if (this.reportEngine != null && this.reportEngine.getEngine() instanceof RuntimeEngine) {
            ((RuntimeEngine)this.reportEngine.getEngine()).setCurrentConf(newConfName);
            if (((RuntimeEngine)this.reportEngine.getEngine()).supportConf(new String[]{oldConfName, newConfName}) && this.cbConnectToEngine.getSelection() && MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)Messages.EngineView_72, (String)(String.valueOf(Messages.EngineView_73) + Messages.EngineView_0))) {
                Event ev = new Event();
                ev.widget = this.cbConnectToEngine;
                ev.type = 13;
                ev.button = 1;
                this.cbConnectToEngine.setSelection(false);
                this.cbConnectToEngine.notifyListeners(13, ev);
                this.cbConnectToEngine.setSelection(true);
                this.cbConnectToEngine.notifyListeners(13, ev);
            }
        }
        Object[] objectArray = ((IStructuredContentProvider)this.cvReport.getContentProvider()).getElements(this.cvReport.getInput());
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof RuntimeEngine && o != this.reportEngine.getEngine()) {
                ((RuntimeEngine)o).setCurrentConf(newConfName);
            }
            ++n2;
        }
        this.refreshRuntimes();
        this.cvReport.refresh();
    }

    public void handleRoleChanged() {
        this.refreshRuntimes();
        Display.getDefault().asyncExec(() -> {
            if (!this.cbConnectToEngine.getSelection()) {
                this.cvReport.getCombo().setEnabled(AdministrationHelper.supportRuntimeSelection());
            }
        });
    }

    private AtomicReference<RuntimeEngine> getDefaultRuntimeEngine() {
        AtomicReference<RuntimeEngine> defaultEngine = new AtomicReference<RuntimeEngine>();
        IRegistryService.IRegistry registry = ((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(RuntimeEngine.class);
        if (registry != null) {
            registry.getAll().stream().forEach(r -> {
                if (DEFAULT_RUNTIME_ENGINE_MD_ID.equals(r.getKey().getProviderFileID()) && (defaultEngine.get() == null || DEFAULT_RUNTIME_ENGINE_MD_NAME.equals(((RuntimeEngine)defaultEngine.get()).getName()))) {
                    defaultEngine.set((RuntimeEngine)r);
                }
            });
        }
        return defaultEngine;
    }

    private void doRefreshRuntimes() {
        if (!this.cacheInited && !this.runtimeRegistryChanged) {
            return;
        }
        HashSet<RuntimeEngine> runtimes = new HashSet<RuntimeEngine>();
        final AtomicReference<RuntimeEngine> defaultEngine = this.getDefaultRuntimeEngine();
        IRegistryService.IRegistry registry = ((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(RuntimeEngine.class);
        if (registry != null) {
            registry.getAll().stream().forEach(r -> {
                if (AdministrationHelper.supportRuntimeSelection()) {
                    r.setCurrentConf(((IEvaluationConfigurationService)E4InjectorHelper.getService(IEvaluationConfigurationService.class)).getCurrentConfigurationName());
                    runtimes.add((RuntimeEngine)r);
                }
            });
        } else {
            ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger(EngineView.class).warn("No RuntimeEngine registry. Please rebuild the cache.");
        }
        if (AdministrationHelper.supportRuntimeSelection()) {
            if (this.rs == null) {
                this.rs = new ResourceSetImpl();
                this.rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new EgcResourceFactoryImpl());
                this.rs.getPackageRegistry().put((Object)"http://www.stambia.com/egc", (Object)EgcPackage.eINSTANCE);
            }
            try {
                URI uri = ConfUtil.getPlatformEgcURI();
                Resource resource = this.rs.getResource(uri, false);
                if (resource != null) {
                    resource.unload();
                    this.rs.getResources().remove((Object)resource);
                }
                if ((resource = this.rs.getResource(uri, true)) != null && resource.getContents().size() != 0 && ((EObject)resource.getContents().get(0)).eContents().size() != 0) {
                    runtimes.addAll((Collection<RuntimeEngine>)((EObject)((EObject)resource.getContents().get(0)).eContents().get(0)).eContents());
                }
            }
            catch (WrappedException e) {
                if (!(e.getCause() instanceof ResourceException)) {
                    ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger(EngineView.class).error("Failed to load egc file", (Object)e);
                }
            }
            catch (Exception e) {
                ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger(EngineView.class).error("Failed to load egc file", (Object)e);
            }
        } else if (defaultEngine.get() != null) {
            runtimes.add(defaultEngine.get());
        }
        final Collection sortedRuntimes = runtimes.stream().sorted(new Comparator<Object>(){

            private String getName(Object o) {
                if (o instanceof Engine) {
                    return ((Engine)o).getName();
                }
                return ((RuntimeEngine)o).getName();
            }

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 == defaultEngine.get()) {
                    return -1;
                }
                if (o2 == defaultEngine.get()) {
                    return 1;
                }
                String name1 = this.getName(o1).toLowerCase();
                String name2 = this.getName(o2).toLowerCase();
                return name1.compareTo(name2);
            }
        }).collect(Collectors.toList());
        final AtomicReference<Object> selectedEngine = new AtomicReference<Object>();
        String lastSelectedEngineName = Activator.getDefault().getPreferenceStore().getString("lastConnectedRuntime");
        if (lastSelectedEngineName != null && !lastSelectedEngineName.isEmpty()) {
            for (Object o : sortedRuntimes) {
                Engine e;
                if (o instanceof Engine) {
                    e = (Engine)o;
                    if (e.getName() == null || !e.getName().equals(lastSelectedEngineName)) continue;
                    selectedEngine.set(e);
                    break;
                }
                if (!(o instanceof RuntimeEngine) || (e = (RuntimeEngine)o).getName() == null || !e.getName().equals(lastSelectedEngineName)) continue;
                selectedEngine.set(e);
                break;
            }
        }
        if (selectedEngine.get() == null) {
            selectedEngine.set(defaultEngine.get());
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean isConnected = EngineView.this.cbConnectToEngine.getSelection();
                boolean reconnect = false;
                if (isConnected) {
                    EngineView.this.cbConnectToEngine.setSelection(false);
                    EngineView.this.cbConnectToEngine.notifyListeners(13, new Event());
                    reconnect = true;
                }
                if (selectedEngine.get() == null) {
                    selectedEngine.set(defaultEngine);
                    reconnect = false;
                }
                EngineView.this.cvReport.setInput((Object)sortedRuntimes);
                EngineView.this.cvReport.setSelection((ISelection)new StructuredSelection(selectedEngine.get()), true);
                if (reconnect) {
                    EngineView.this.cbConnectToEngine.setSelection(true);
                    EngineView.this.cbConnectToEngine.notifyListeners(13, new Event());
                }
            }
        });
    }

    public void handleCacheInitialized() {
        this.cacheInited = true;
        this.refreshRuntimes();
    }

    public void handleCacheInitializing() {
        this.cacheInited = false;
    }

    public void handleBatchedEvent() {
        this.refreshRuntimes();
        this.runtimeRegistryChanged = false;
    }

    private void refreshRuntimes() {
        if (this.refreshRuntimeJob == null) {
            this.refreshRuntimeJob = new Job(Messages.EngineView_2){

                protected IStatus run(IProgressMonitor monitor) {
                    EngineView.this.doRefreshRuntimes();
                    EngineView.this.runtimeRegistryChanged = false;
                    return Status.OK_STATUS;
                }
            };
        }
        this.refreshRuntimeJob.cancel();
        this.refreshRuntimeJob.schedule(200L);
    }

    class CommandDialog
    extends Dialog {
        private String title;

        public CommandDialog(Shell parentShell, String string) {
            super(parentShell);
            this.setShellStyle(68720);
            this.title = string;
        }

        private String getCommandIdForRunningOs(CommandType cmdtype) {
            boolean isWindows = "win32".equals(Platform.getOS());
            switch (cmdtype) {
                case START_BASE: {
                    return isWindows ? "demoStartCommand" : "demoStartCommandLinux";
                }
                case START_ENGINE: {
                    return isWindows ? "engineStartCommand" : "engineStartCommandLinux";
                }
                case STOP_BASE: {
                    return isWindows ? "demoStopCommand" : "demoStopCommandLinux";
                }
                case STOP_ENGINE: {
                    return isWindows ? "engineStopCommand" : "engineStopCommandLinux";
                }
            }
            return null;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Button b = new Button(composite, 2048);
            b.setData("qa", (Object)InternalIdentifier.RUNTIME_VIEW_BUTTON_START_LOCAL_RUNTIME.getId());
            b.setText(Messages.EngineView_17);
            b.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    boolean ping = false;
                    try {
                        ping = EngineView.this.ping(new EnvironmentConfiguration.EngineInfoWrapper(EngineView.this.cvReport.getElementAt(0)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!ping) {
                        EngineView.this.executeCommand(CommandDialog.this.getCommandIdForRunningOs(CommandType.START_ENGINE), true, new String[0]);
                    } else {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.EngineView_18, (String)Messages.EngineView_19);
                    }
                }
            });
            GridData gridData = new GridData(768);
            b.setLayoutData((Object)gridData);
            Button b2 = new Button(composite, 2048);
            b2.setData("qa", (Object)InternalIdentifier.RUNTIME_VIEW_BUTTON_STOP_LOCAL_RUNTIME.getId());
            b2.setText(Messages.EngineView_21);
            b2.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    boolean ping = false;
                    try {
                        ping = EngineView.this.ping(new EnvironmentConfiguration.EngineInfoWrapper(EngineView.this.cvReport.getElementAt(0)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!ping) {
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.EngineView_22, (String)Messages.EngineView_23);
                    } else {
                        AtomicReference defaultEngine = EngineView.this.getDefaultRuntimeEngine();
                        String[] defaultRuntimeCredentials = null;
                        if (defaultEngine.get() != null && ((RuntimeEngine)defaultEngine.get()).getPassword() != null) {
                            defaultRuntimeCredentials = new String[]{"-user", ((RuntimeEngine)defaultEngine.get()).getUser(), "-password", ((RuntimeEngine)defaultEngine.get()).getPassword()};
                        }
                        EngineView.this.executeCommand(CommandDialog.this.getCommandIdForRunningOs(CommandType.STOP_ENGINE), true, defaultRuntimeCredentials);
                    }
                }
            });
            gridData = new GridData(768);
            b2.setLayoutData((Object)gridData);
            boolean exists = false;
            Bundle[] bundleArray = Activator.getDefault().getBundle().getBundleContext().getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                exists = bundle.getSymbolicName().equals("com.indy.demo");
                if (exists) break;
                ++n2;
            }
            if (exists) {
                EngineView.this.createCommandButton(composite, Messages.EngineView_25, this.getCommandIdForRunningOs(CommandType.START_BASE), true, InternalIdentifier.RUNTIME_VIEW_BUTTON_START_DEMO_DATABASES.getId());
                EngineView.this.createCommandButton(composite, Messages.EngineView_26, this.getCommandIdForRunningOs(CommandType.STOP_BASE), true, InternalIdentifier.RUNTIME_VIEW_BUTTON_STOP_DEMO_DATABASES.getId());
            }
            return composite;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            if (this.title != null) {
                shell.setText(this.title);
            }
        }
    }

    private static enum CommandType {
        START_ENGINE,
        STOP_ENGINE,
        START_BASE,
        STOP_BASE;

    }
}

