/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine.view;

import com.indy.ui.engine.Messages;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.registry.RuntimeEngine;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.presentation.custom.MdQuickModelWizard;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class RuntimeWizard
extends MdQuickModelWizard {
    private boolean isExistingRuntimeMetaData;
    private Map<String, RuntimeEngine> runtimeMetadataMap = new HashMap<String, RuntimeEngine>();
    private ComboViewer runtimeComboViewer;
    private RuntimeEngine selectedRuntimeEngine;
    private static String RESSOURCE_PATH = "platform:/resource/tech/";

    public RuntimeWizard(List<RuntimeEngine> runtimeList) {
        if (runtimeList != null && runtimeList.size() >= 1) {
            this.isExistingRuntimeMetaData = true;
            for (RuntimeEngine runtimeEngine : runtimeList) {
                String fileId = runtimeEngine.getKey().getProviderFileID();
                URI uri = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(fileId);
                if (uri == null) continue;
                String runtimeMdName = uri.toString().replaceAll(RESSOURCE_PATH, "");
                this.runtimeMetadataMap.put(runtimeMdName, runtimeEngine);
            }
        }
    }

    public void addPages() {
        this.setWindowTitle(Messages.RuntimeWizard_6);
        if (this.isExistingRuntimeMetaData) {
            WizardPage runtimeInformationPage = new WizardPage(Messages.RuntimeWizard_0){

                private void hookListeners() {
                    RuntimeWizard.this.runtimeComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                        public void selectionChanged(SelectionChangedEvent event) {
                            RuntimeWizard.this.selectedRuntimeEngine = (RuntimeEngine)RuntimeWizard.this.runtimeMetadataMap.get(((IStructuredSelection)event.getSelection()).getFirstElement());
                            this.getWizard().getContainer().updateButtons();
                        }
                    });
                }

                public boolean isPageComplete() {
                    return RuntimeWizard.this.selectedRuntimeEngine != null;
                }

                public void createControl(Composite parent) {
                    Composite composite = new Composite(parent, 0);
                    composite.setLayout((Layout)new GridLayout(1, false));
                    Label l = new Label(composite, 0);
                    l.setLayoutData((Object)new GridData(4, 1, true, false));
                    l.setText(Messages.RuntimeWizard_1);
                    l = new Label(composite, 0);
                    l.setLayoutData((Object)new GridData(4, 1, true, false));
                    l.setText(Messages.RuntimeWizard_4);
                    l = new Label(composite, 0);
                    l.setLayoutData((Object)new GridData(4, 1, true, false));
                    l.setText(Messages.RuntimeWizard_5);
                    Group g = new Group(composite, 0);
                    g.setLayoutData((Object)new GridData(4, 1, true, false));
                    g.setLayout((Layout)new GridLayout(2, false));
                    g.setText(Messages.RuntimeWizard_7);
                    RuntimeWizard.this.runtimeComboViewer = new ComboViewer((Composite)g, 8);
                    RuntimeWizard.this.runtimeComboViewer.getControl().setLayoutData((Object)new GridData(4, 1, true, false));
                    RuntimeWizard.this.runtimeComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
                    RuntimeWizard.this.runtimeComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                        public String getText(Object element) {
                            return (String)element;
                        }
                    });
                    ISelection s = RuntimeWizard.this.runtimeComboViewer.getSelection();
                    RuntimeWizard.this.runtimeComboViewer.setInput(RuntimeWizard.this.runtimeMetadataMap.keySet());
                    RuntimeWizard.this.runtimeComboViewer.setSelection(s);
                    this.setControl((Control)composite);
                    this.hookListeners();
                }
            };
            this.addPage((IWizardPage)runtimeInformationPage);
            runtimeInformationPage.setTitle(Messages.RuntimeWizard_0);
        } else {
            this.addRuntimeInformationPage();
        }
    }

    private void addRuntimeInformationPage() {
        WizardPage runtimeInformationPage = new WizardPage(Messages.RuntimeWizard_0){

            public boolean isPageComplete() {
                return true;
            }

            public void createControl(Composite parent) {
                Composite composite = new Composite(parent, 0);
                composite.setLayout((Layout)new GridLayout(1, false));
                Label l = new Label(composite, 0);
                l.setLayoutData((Object)new GridData(4, 1, true, false));
                l.setText(Messages.RuntimeWizard_1);
                l = new Label(composite, 0);
                l.setLayoutData((Object)new GridData(4, 1, true, false));
                l.setText(Messages.RuntimeWizard_2);
                l = new Label(composite, 0);
                l.setLayoutData((Object)new GridData(4, 1, true, false));
                l.setText(Messages.RuntimeWizard_3);
                this.setControl((Control)composite);
            }
        };
        this.addPage((IWizardPage)runtimeInformationPage);
        runtimeInformationPage.setTitle(Messages.RuntimeWizard_0);
        super.addPages();
    }

    public boolean canFinish() {
        IWizardPage cur;
        IWizardContainer c = this.getContainer();
        if (c != null && (cur = c.getCurrentPage()) != null) {
            return cur.isPageComplete() && !cur.canFlipToNextPage();
        }
        return false;
    }

    public boolean performFinish() {
        if (this.isExistingRuntimeMetaData) {
            String fileId = this.selectedRuntimeEngine.getKey().getProviderFileID();
            URI uri = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(fileId);
            if (uri != null) {
                URIEditorInput input = new URIEditorInput(uri);
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page.openEditor((IEditorInput)input, "com.stambia.md.presentation.MdEditorID");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            return true;
        }
        return super.performFinish();
    }
}

