/*
 * Decompiled with CFR 0.152.
 */
package com.indy.model.navigation.ui.view;

import com.indy.model.navigation.ui.view.SearchModelUI;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FilteredDropDownControl {
    private boolean listenModify = true;
    private Text text;
    private String filter;
    private Shell shell;
    private CheckboxTableViewer tableViewer;
    private SearchModelUI.ProductInfo selected;
    private Composite control;
    private ContentProvider provider;

    public Composite createContent(Composite parent, ContentProvider provider) {
        this.provider = provider;
        Composite main = new Composite(parent, 0);
        main.setVisible(false);
        GridLayout gl = null;
        gl = new GridLayout(2, false);
        main.setLayout((Layout)gl);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.text = new Text(main, 2048);
        this.text.setLayoutData((Object)new GridData(4, 1, true, false));
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (!(e.detail != 4 && e.detail != 2 || FilteredDropDownControl.this.shell == null || FilteredDropDownControl.this.shell.isDisposed())) {
                    FilteredDropDownControl.this.shell.close();
                }
            }
        });
        this.text.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                FilteredDropDownControl.this.handleFocusGained();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FilteredDropDownControl.this.listenModify) {
                    FilteredDropDownControl.this.filter = FilteredDropDownControl.this.text.getText();
                    if (FilteredDropDownControl.this.shell != null && !FilteredDropDownControl.this.shell.isDisposed()) {
                        FilteredDropDownControl.this.tableViewer.refresh();
                    } else {
                        FilteredDropDownControl.this.openShell();
                    }
                }
            }
        });
        main.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                FilteredDropDownControl.this.relocateShell();
            }

            public void controlMoved(ControlEvent e) {
                FilteredDropDownControl.this.relocateShell();
            }
        });
        this.control = main;
        return this.control;
    }

    private void handleFocusGained() {
        if (this.shell == null || this.shell.isDisposed()) {
            this.openShell();
        }
    }

    private void openShell() {
        this.shell = new Shell(this.control.getShell(), 12);
        this.shell.setLayout((Layout)new FillLayout());
        this.tableViewer = new CheckboxTableViewer((Composite)this.shell, 68112);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((SearchModelUI.ProductInfo)element).label;
            }
        });
        this.tableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return FilteredDropDownControl.this.filter == null || FilteredDropDownControl.this.filter.isEmpty() || ((SearchModelUI.ProductInfo)element).label.toUpperCase().contains(FilteredDropDownControl.this.filter.toUpperCase());
            }
        });
        this.tableViewer.setSorter(new ViewerSorter());
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){
            boolean checking = false;

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (this.checking) {
                    return;
                }
                this.checking = true;
                FilteredDropDownControl.this.listenModify = false;
                if (event.getChecked()) {
                    FilteredDropDownControl.this.text.setText(((SearchModelUI.ProductInfo)event.getElement()).label);
                    FilteredDropDownControl.this.selected = (SearchModelUI.ProductInfo)event.getElement();
                    FilteredDropDownControl.this.tableViewer.setCheckedElements(new Object[]{event.getElement()});
                } else {
                    FilteredDropDownControl.this.selected = null;
                }
                FilteredDropDownControl.this.fireSelectionChanged();
                FilteredDropDownControl.this.listenModify = true;
                this.checking = false;
            }
        });
        this.relocateShell();
        this.shell.getDisplay().addFilter(3, new Listener(){

            public void handleEvent(Event event) {
                if (FilteredDropDownControl.this.shell == null || FilteredDropDownControl.this.shell.isDisposed()) {
                    return;
                }
                Point p = ((Control)event.widget).toDisplay(event.x, event.y);
                Point ps = FilteredDropDownControl.this.shell.toDisplay(0, 0);
                Rectangle r = new Rectangle(ps.x, ps.y, ((FilteredDropDownControl)FilteredDropDownControl.this).shell.getBounds().width, ((FilteredDropDownControl)FilteredDropDownControl.this).shell.getBounds().height);
                if (event.widget != FilteredDropDownControl.this.text && !r.contains(p)) {
                    FilteredDropDownControl.this.shell.close();
                }
            }
        });
        ArrayList input = new ArrayList();
        for (Object i : (Collection)this.provider.getContent()) {
            if (((SearchModelUI.ProductInfo)i).hidden) continue;
            input.add(i);
        }
        this.tableViewer.setInput(input);
        if (this.selected != null) {
            this.tableViewer.setCheckedElements(new Object[]{this.selected});
        }
        this.shell.open();
        Point sz = this.shell.computeSize(-1, -1);
        this.shell.setSize(Math.min(200, sz.x) + 20, Math.min(150, sz.y) + 20);
    }

    private void relocateShell() {
        if (this.shell != null && !this.shell.isDisposed()) {
            Rectangle controlBounds = this.control.getBounds();
            Point location = this.control.getParent().toDisplay(controlBounds.x, controlBounds.y);
            this.shell.setLocation(location.x, location.y + this.control.getClientArea().height + 2);
        }
    }

    private void fireSelectionChanged() {
        this.provider.selectProduct(this.selected);
    }

    public void clear() {
        this.listenModify = false;
        this.text.setText("");
        this.listenModify = true;
        this.selected = null;
    }

    public static interface ContentProvider {
        public Object getContent();

        public void selectProduct(SearchModelUI.ProductInfo var1);
    }
}

