/*
 * Decompiled with CFR 0.152.
 */
package com.indy.model.navigation.ui.view;

import com.semarchy.xdi.designer.core.indexation.IMdTechRegistry;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.EMFResourceUtil;
import com.stambia.md.MdNode;
import com.stambia.md.util.TechMerger;
import com.stambia.tech.FileType;
import com.stambia.tech.Level;
import com.stambia.tech.MappingType;
import com.stambia.tech.Tech;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class TechRegistry {
    private List<TechDescriptor> descriptors = new ArrayList<TechDescriptor>();
    private ResourceSet rs = new ResourceSetImpl();

    public TechRegistry() {
        this.rs.setURIConverter((URIConverter)new InternalResourceURIConverter());
        this.rs.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", true);
        this.init();
    }

    private void init() {
        IMdTechRegistry reg = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getMdTechRegistry();
        for (URI techURI : reg.getTechUris()) {
            Resource resource = this.rs.getResource(techURI, true);
            Tech tech = (Tech)EMFResourceUtil.getRootElement((Resource)resource);
            TechMerger merger = null;
            ArrayList<String> additionalLevelCodes = new ArrayList<String>();
            for (Level lvl : new ArrayList(tech.getLevel())) {
                if (!lvl.isIsFile()) continue;
                if (lvl.getParent().isEmpty()) {
                    if (merger == null) {
                        merger = new TechMerger(resource);
                        merger.refreshTech();
                    }
                    this.descriptors.add(this.createDescriptor(merger.getTech().getLevel(lvl.getCode()), techURI.trimFileExtension().lastSegment()));
                    continue;
                }
                additionalLevelCodes.add(lvl.getCode());
            }
            if (additionalLevelCodes.isEmpty()) continue;
            List usages = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getDependencyHelper().getUsage(techURI);
            for (URI u : usages) {
                String id;
                if (!u.fileExtension().equals("md") || !(id = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getSourceId(u)).startsWith("UUID_")) continue;
                this.descriptors.add(this.createDescriptor(u, techURI.trimFileExtension().lastSegment()));
            }
        }
        for (Resource r : this.rs.getResources()) {
            r.unload();
        }
        this.rs.getResources().clear();
    }

    private TechDescriptor createDescriptor(Level lvl, String categorie) {
        TechDescriptor r = new TechDescriptor();
        r.iconURL = lvl.getIconURL();
        r.label = lvl.getDisplayName();
        r.levelCode = lvl.getCode();
        r.UUID = ((Tech)lvl.eContainer()).getId();
        r.categorie = categorie;
        r.isAdvanced = lvl.getIsFile() == FileType.ADVANCED;
        r.modelURI = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(r.UUID);
        for (Level l : ((Tech)lvl.eContainer()).getLevel()) {
            if (!l.getMappingType().contains((Object)MappingType.FILTER) && !l.getMappingType().contains((Object)MappingType.JOIN) && !l.getMappingType().contains((Object)MappingType.MAPPING) && !l.getMappingType().contains((Object)MappingType.SOURCE) && !l.getMappingType().contains((Object)MappingType.SOURCE_MAPPING) && !l.getMappingType().contains((Object)MappingType.STAGING) && !l.getMappingType().contains((Object)MappingType.VARIABLE) && !l.getMappingType().contains((Object)MappingType.TARGET) && !l.getMappingType().contains((Object)MappingType.TARGET_MAPPING)) continue;
            r.isMapping = true;
            break;
        }
        return r;
    }

    private TechDescriptor createDescriptor(URI mdModelURI, String categorie) {
        Resource r = this.rs.getResource(mdModelURI, true);
        MdNode productNode = (MdNode)EMFResourceUtil.getRootElement((Resource)r);
        TechDescriptor res = null;
        for (Level lvl : ((Tech)productNode.getLevel().eContainer()).getLevel()) {
            if (lvl == productNode.getLevel() || !lvl.isIsFile() || !lvl.getParent().contains((Object)productNode.getLevel().getCode())) continue;
            res = new TechDescriptor();
            res.iconURL = lvl.getIconURL();
            res.label = productNode.getName();
            if (res.label == null) {
                res.label = lvl.getDisplayName();
            }
            res.isAdvanced = lvl.getIsFile() == FileType.ADVANCED;
            res.levelCode = lvl.getCode();
            res.UUID = productNode.getId();
            res.categorie = categorie;
            res.modelURI = mdModelURI;
        }
        for (Level l : ((Tech)productNode.getLevel().eContainer()).getLevel()) {
            if (!l.getMappingType().contains((Object)MappingType.FILTER) && !l.getMappingType().contains((Object)MappingType.JOIN) && !l.getMappingType().contains((Object)MappingType.MAPPING) && !l.getMappingType().contains((Object)MappingType.SOURCE) && !l.getMappingType().contains((Object)MappingType.SOURCE_MAPPING) && !l.getMappingType().contains((Object)MappingType.STAGING) && !l.getMappingType().contains((Object)MappingType.VARIABLE) && !l.getMappingType().contains((Object)MappingType.TARGET) && !l.getMappingType().contains((Object)MappingType.TARGET_MAPPING)) continue;
            res.isMapping = true;
            break;
        }
        return res;
    }

    public List<TechDescriptor> getDescriptors() {
        return this.descriptors;
    }

    class TechDescriptor {
        String UUID;
        String levelCode;
        String label;
        URL iconURL;
        String categorie;
        boolean isAdvanced;
        boolean isMapping;
        URI modelURI;

        TechDescriptor() {
        }

        public String getUUID() {
            return this.UUID;
        }

        public String getLevelCode() {
            return this.levelCode;
        }

        public String getLabel() {
            return this.label;
        }

        public URL getIconURL() {
            return this.iconURL;
        }

        public String getCategorie() {
            return this.categorie;
        }

        public String toString() {
            return String.valueOf(this.getCategorie()) + " " + this.getUUID() + " " + this.getLabel() + " " + this.getLevelCode() + " " + this.iconURL;
        }
    }
}

