/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.parquet;

import com.indy.addons.parquet.Messages;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.parquet.io.SeekableInputStream;

public final class ParquetSeekableFileInputStream
extends SeekableInputStream {
    private File file;
    private BufferedInputStream bufferedInputStream;
    private static final int bufferSize = 8192;
    private long currentPosition = 0L;
    private long lowWaterMark = 0L;

    public ParquetSeekableFileInputStream(File file) throws FileNotFoundException {
        this.file = file;
        this.bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        this.bufferedInputStream.mark(8192);
    }

    public final long getPos() throws IOException {
        return this.currentPosition;
    }

    public final boolean markSupported() {
        return true;
    }

    private final void incrementPosition(long increment) {
        this.currentPosition += increment;
        if (this.currentPosition - this.lowWaterMark > 8192L) {
            this.bufferedInputStream.mark(8192);
            this.lowWaterMark = this.currentPosition;
        }
    }

    public final int read() throws IOException {
        int ret = this.bufferedInputStream.read();
        if (ret != -1) {
            this.incrementPosition(1L);
        }
        return ret;
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        int ret = this.bufferedInputStream.read(b, off, len);
        if (ret != -1) {
            this.incrementPosition(ret);
        }
        return ret;
    }

    public final int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public final long skip(long n) throws IOException {
        long ret = this.bufferedInputStream.skip(n);
        if (ret > 0L) {
            this.incrementPosition(ret);
        }
        return ret;
    }

    public final int read(ByteBuffer buf) throws IOException {
        int nbBytesToRead = buf.remaining();
        byte[] bytesToRead = new byte[nbBytesToRead];
        int ret = this.read(bytesToRead);
        if (ret > 0) {
            buf.put(bytesToRead, 0, ret);
        }
        return ret;
    }

    public final void readFully(byte[] bytes) throws IOException {
        int ret = this.read(bytes, 0, bytes.length);
        if (ret < bytes.length) {
            throw new IOException(Messages.ParquetSeekableFileInputStream_endOfStream);
        }
    }

    public final void readFully(ByteBuffer buf) throws IOException {
        int nbBytesToRead = buf.remaining();
        int ret = this.read(buf);
        if (ret < nbBytesToRead) {
            throw new IOException(Messages.ParquetSeekableFileInputStream_endOfStream);
        }
    }

    public final void readFully(byte[] bytes, int start, int len) throws IOException {
        int ret = this.read(bytes, start, len);
        if (ret < len) {
            throw new IOException(Messages.ParquetSeekableFileInputStream_endOfStream);
        }
    }

    public final void seek(long pos) throws IOException {
        if (pos < this.lowWaterMark) {
            this.currentPosition = 0L;
            this.lowWaterMark = 0L;
            this.bufferedInputStream.close();
            this.bufferedInputStream = new BufferedInputStream(new FileInputStream(this.file));
            this.bufferedInputStream.mark(8192);
            this.seek(pos);
        } else if (pos > this.currentPosition) {
            this.skipLoop(pos);
        } else {
            this.reset();
            this.skipLoop(pos);
        }
    }

    private void skipLoop(long pos) throws IOException {
        while (this.currentPosition < pos) {
            this.skip(pos - this.currentPosition);
        }
    }

    public final void close() throws IOException {
        this.bufferedInputStream.close();
        super.close();
    }

    public final synchronized void reset() throws IOException {
        this.bufferedInputStream.reset();
        this.currentPosition = this.lowWaterMark;
    }
}

