/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.parquet;

import com.indy.addons.parquet.Messages;
import com.indy.addons.parquet.ParquetInputFile;
import com.indy.addons.parquet.ParquetTypeVisitor;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IExecute;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.custom.exception.ExecuteException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.TypeVisitor;
import org.eclipse.emf.ecore.EObject;

public final class ReverseParquetAction
implements IExecute {
    private final Logger logger = LogManager.getLogger(this.getClass());

    public Object run(Object mdNode, String configuration, Map<String, String> params) throws ExecuteException {
        this.printDebug("START parquet reverse");
        MdNode rootNode = (MdNode)mdNode;
        try {
            String moduleName = rootNode.evaluateXpathExpressionCached("INTERNAL_MODULE", null);
            if (moduleName == null) {
                throw new Exception("No module specified");
            }
            String parquetFilePath = rootNode.evaluate(Messages.ReverseParquetAction_1);
            String debugMessage = "parquet file path:" + parquetFilePath;
            this.printDebug(debugMessage);
            if (parquetFilePath == null || parquetFilePath.trim().length() <= 0) {
                throw new RuntimeException(Messages.ReverseParquetAction_3);
            }
            MessageType parquetSchema = this.getSchemaFromParquet(parquetFilePath);
            this.reverse(rootNode, parquetSchema);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ExecuteException(exception);
        }
        this.printDebug("STOP parquet reverse");
        return null;
    }

    private final MessageType getSchemaFromParquet(String parquetFilePath) throws IOException {
        MessageType parquetSchema = null;
        ParquetInputFile localInputFile = new ParquetInputFile(parquetFilePath);
        ParquetReadOptions parquetReadOptions = ParquetReadOptions.builder().build();
        try (ParquetFileReader parquetFileReader = null;){
            try {
                FileMetaData fileMetaData;
                parquetFileReader = ParquetFileReader.open((InputFile)localInputFile, (ParquetReadOptions)parquetReadOptions);
                ParquetMetadata metadata = parquetFileReader.getFooter();
                if (metadata != null && (fileMetaData = metadata.getFileMetaData()) != null) {
                    parquetSchema = fileMetaData.getSchema();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IOException(exception);
            }
        }
        return parquetSchema;
    }

    private final void reverse(MdNode originalSchemaNode, MessageType parquetSchemaType) throws Exception {
        if (originalSchemaNode != null && parquetSchemaType != null) {
            MdNode newSchemaNode = originalSchemaNode.copy(1);
            MdNode parquetNode = (MdNode)originalSchemaNode.eContainer();
            newSchemaNode.setSubstituteContainer((EObject)parquetNode);
            ParquetTypeVisitor visitor = new ParquetTypeVisitor(newSchemaNode, originalSchemaNode);
            parquetSchemaType.accept((TypeVisitor)visitor);
            HashMap<MdNode, MdNode> reversedMap = new HashMap<MdNode, MdNode>();
            reversedMap.put(newSchemaNode, originalSchemaNode);
            IncrementalReverser ir = new IncrementalReverser((EObject)parquetNode, reversedMap, Collections.EMPTY_LIST, false, null, null, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, null, true);
            ir.reverse();
        }
    }

    protected final void printDebug(String debugMessage) {
        this.logger.debug(debugMessage);
    }
}

