/*
 * Decompiled with CFR 0.152.
 */
package com.indy.libraries.management.ui;

import com.indy.engine.core.module.IModuleService;
import com.indy.libraries.management.ui.Activator;
import com.indy.libraries.management.ui.Messages;
import com.indy.libraries.management.ui.wizard.ModuleControler;
import com.indy.libraries.management.ui.wizard.ModuleWizard;
import com.indy.ui.custom.out.common.properties.AbstractUnboundedControl;
import com.semarchy.xdi.designer.core.services.IBaseModuleProvider;
import com.semarchy.xdi.designer.core.services.IModuleProblemProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.statushandlers.StatusManager;

public class LibrariesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.indy.libraries.management.ui.page1";
    private IModuleService mgr;
    private IBaseModuleProvider baseModuleProvider;
    private IModuleProblemProvider moduleProblemProvider;

    public LibrariesPage() {
        this.noDefaultAndApplyButton();
    }

    public void dispose() {
        super.dispose();
    }

    protected Control createContents(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        ((GridLayout)main.getLayout()).marginHeight = 0;
        ((GridLayout)main.getLayout()).marginWidth = 0;
        main.setLayoutData((Object)new GridData(4, 4, false, true));
        Label t = new Label(main, 64);
        t.setAlignment(16384);
        t.setLayoutData((Object)new GridData());
        ((GridData)t.getLayoutData()).widthHint = 400;
        t.setText(Messages.LibrariesPage_13);
        Composite modulesC = new Composite(main, 0);
        modulesC.setLayout((Layout)new GridLayout());
        modulesC.setLayoutData((Object)new GridData(1808));
        Label l = new Label(modulesC, 0);
        l.setText(Messages.LibrariesPage_10);
        l.setLayoutData((Object)new GridData());
        final ToolBar tb = new ToolBar(modulesC, 0x800100);
        tb.setLayoutData((Object)new GridData(4, 1, true, false));
        ToolItem add = new ToolItem(tb, 8);
        add.setImage(AbstractUnboundedControl.addIcon);
        add.setToolTipText(Messages.LibrariesPage_11);
        final ToolItem del = new ToolItem(tb, 8);
        del.setImage(AbstractUnboundedControl.delIcon);
        del.setToolTipText(Messages.LibrariesPage_12);
        del.setEnabled(false);
        final TableViewer moduleList = new TableViewer(modulesC, 68096);
        moduleList.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)moduleList.getControl().getLayoutData()).heightHint = 400;
        final Text problems = new Text(modulesC, 2624);
        problems.setLayoutData((Object)new GridData(4, 3, true, false));
        ((GridData)problems.getLayoutData()).heightHint = 100;
        problems.setEditable(false);
        moduleList.setContentProvider((IContentProvider)new ArrayContentProvider());
        moduleList.setComparator(new ViewerComparator());
        moduleList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IModuleService.IModule)element).getName();
            }

            public Image getImage(Object element) {
                try {
                    IModuleProblemProvider.Status s = LibrariesPage.this.moduleProblemProvider.getStatus((IModuleService.IModule)element);
                    switch (s) {
                        case ERROR: {
                            return ModuleControler.errorIcon;
                        }
                        case WARNING: {
                            return ModuleControler.warningIcon;
                        }
                        case VALID: {
                            return null;
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return super.getImage(element);
            }
        });
        moduleList.setInput((Object)this.mgr.getModules());
        moduleList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IModuleService.IModule lib = (IModuleService.IModule)moduleList.getStructuredSelection().getFirstElement();
                del.setEnabled(lib != null && !"com.indy.baseModule.default".equals(lib.getDescriptor().getBaseModuleInfo().getId()) && !lib.getName().equals("internal"));
                if (lib != null) {
                    problems.setText(LibrariesPage.this.moduleProblemProvider.getProblems(lib).stream().map(p -> p.getMessage()).collect(Collectors.joining("\n")));
                }
            }
        });
        moduleList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ModuleWizard z = new ModuleWizard(null, ((IModuleService.IModule)moduleList.getStructuredSelection().getFirstElement()).getDescriptor(), true, false);
                WizardDialog d = new WizardDialog(tb.getShell(), (IWizard)z);
                d.setPageSize(-1, 600);
                d.open();
                IModuleService.IModule m = z.getResult();
                moduleList.setInput((Object)LibrariesPage.this.mgr.getModules());
                if (m != null) {
                    moduleList.setSelection((ISelection)new StructuredSelection((Object)m));
                }
            }
        });
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModuleWizard z = new ModuleWizard(null, null, false, true);
                WizardDialog d = new WizardDialog(tb.getShell(), (IWizard)z);
                z.setBaseModule(LibrariesPage.this.baseModuleProvider.findBaseModule("com.indy.baseModule.generic"));
                d.setPageSize(-1, 600);
                if (d.open() == 0) {
                    ISelection s = moduleList.getSelection();
                    moduleList.setInput((Object)LibrariesPage.this.mgr.getModules());
                    moduleList.setSelection(s);
                }
            }
        });
        del.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                block12: {
                    IModuleService.IModule lib = (IModuleService.IModule)moduleList.getStructuredSelection().getFirstElement();
                    try {
                        if (lib == null) break block12;
                        Path libPath = lib.getInstallationFolder().toPath();
                        LibrariesPage.this.mgr.removeModule(lib.getName());
                        Throwable throwable = null;
                        Object var5_9 = null;
                        try (Stream<Path> stream = Files.walk(libPath, new FileVisitOption[0]);){
                            stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        moduleList.setInput((Object)LibrariesPage.this.mgr.getModules());
                    }
                    catch (IOException ex) {
                        Status status = new Status(4, "com.indy.libraries.management.ui", String.format(Messages.LibrariesPage_0, lib.getName()), (Throwable)ex);
                        StatusManager.getManager().handle((IStatus)status, 7);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        MessageDialog.openError((Shell)tb.getShell(), (String)Messages.LibrariesPage_46, (String)(String.valueOf(Messages.LibrariesPage_47) + ex.getMessage()));
                    }
                }
            }
        });
        return main;
    }

    public void init(IWorkbench workbench) {
        this.mgr = (IModuleService)workbench.getService(IModuleService.class);
        this.baseModuleProvider = (IBaseModuleProvider)workbench.getService(IBaseModuleProvider.class);
        this.moduleProblemProvider = (IModuleProblemProvider)workbench.getService(IModuleProblemProvider.class);
        this.initializeContent();
    }

    private void initializeContent() {
    }

    protected void performDefaults() {
        this.initializeContent();
        super.performDefaults();
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    protected void performApply() {
    }

    public boolean performOk() {
        return super.performOk();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }
}

