/*
 * Decompiled with CFR 0.152.
 */
package com.indy.libraries.management.ui.wizard.upgrade;

import com.indy.engine.core.module.IModuleService;
import com.indy.libraries.management.ui.Activator;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.services.IBaseModuleProvider;
import com.semarchy.xdi.designer.core.services.IModelUpgrader;
import com.semarchy.xdi.designer.core.services.IModuleRequirmentService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.ServiceReference;

public class UpgradeModuleControler {
    @Inject
    private IModuleRequirmentService requirmentService;
    @Inject
    private IModuleService moduleService;
    @Inject
    private IBaseModuleProvider baseModuleProvider;
    private Map<String, List<IFile>> mdWithMissingModulePerBaseModule = null;
    private HashMap<String, IModuleService.IBaseModule> cachedBaseModules = null;
    UpgraderOptions options = new UpgraderOptions();

    public IModuleRequirmentService getModuleRequirementService() {
        return this.requirmentService;
    }

    public void updateMdModels(UpgraderOptions state) {
    }

    public void refresh() {
        if (this.mdWithMissingModulePerBaseModule == null) {
            this.mdWithMissingModulePerBaseModule = new HashMap<String, List<IFile>>();
        } else {
            this.mdWithMissingModulePerBaseModule.clear();
        }
        Map m = this.requirmentService.getModelsWithModuleRequirment();
        for (String id : m.keySet()) {
            for (URI u : (Collection)m.get(id)) {
                IFile f;
                if (!u.isPlatformResource() || (f = Util.convertEMFURIToFile((URI)u)) == null) continue;
                if (this.mdWithMissingModulePerBaseModule.get(id) == null) {
                    this.mdWithMissingModulePerBaseModule.put(id, new ArrayList());
                }
                this.mdWithMissingModulePerBaseModule.get(id).add(f);
            }
        }
    }

    public Map<String, List<IFile>> getMdWithNoModulesPerBaseModuleId() {
        if (this.mdWithMissingModulePerBaseModule == null) {
            this.refresh();
        }
        return this.mdWithMissingModulePerBaseModule;
    }

    public IModuleService getModuleService() {
        return this.moduleService;
    }

    public IModuleService.IBaseModule getBaseModule(String baseModuleId) {
        if (this.cachedBaseModules == null) {
            this.cachedBaseModules = new HashMap();
            for (IModuleService.IBaseModule m : this.baseModuleProvider.getBaseModules()) {
                this.cachedBaseModules.put(m.getInfo().getId(), m);
            }
        }
        return this.cachedBaseModules.get(baseModuleId);
    }

    public IModuleRequirmentService.ModelModuleState getState(IFile element) {
        URI uri = Util.convertIFileToEMFURI((IFile)element);
        return this.requirmentService.getState(uri);
    }

    public String getModuleName(IFile element) {
        URI uri = Util.convertIFileToEMFURI((IFile)element);
        return this.requirmentService.getSpecifiedModuleName(uri);
    }

    private class UpgraderJob
    extends Job {
        UpgraderOptions options;

        public UpgraderJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            block6: {
                try {
                    Collection sr = Activator.getDefault().getBundle().getBundleContext().getServiceReferences(IModelUpgrader.class, "(&(type=md)(kind=module))");
                    if (sr == null || sr.isEmpty()) break block6;
                    ServiceReference ref = (ServiceReference)sr.iterator().next();
                    IModelUpgrader upgrader = (IModelUpgrader)Activator.getDefault().getBundle().getBundleContext().getService(ref);
                    try {
                        HashMap<IFile, IModuleService.IModule> ops = new HashMap<IFile, IModuleService.IModule>();
                        for (IFile f : this.options.mdModelsToUpdate) {
                            ops.put(f, this.options.moduleToApply);
                        }
                        upgrader.upgradeModels(this.options.mdModelsToUpdate, ops, null, false);
                    }
                    finally {
                        Activator.getDefault().getBundle().getBundleContext().ungetService(ref);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return Status.OK_STATUS;
        }
    }

    public class UpgraderOptions {
        IModuleService.IBaseModule selectedBaseModule;
        IModuleService.IModule moduleToApply;
        Set<IFile> mdModelsToUpdate = new HashSet<IFile>();
    }
}

