/*
 * Decompiled with CFR 0.152.
 */
package com.indy.cross.ui;

import com.indy.cross.ContainerLevel;
import com.indy.cross.ui.Activator;
import com.indy.cross.ui.LineageDraw2DHelper;
import com.indy.cross.ui.LineageTreeBuilder;
import com.indy.cross.ui.Messages;
import com.indy.cross.ui.editor.CrossRefEditorInput;
import com.indy.cross.ui.editor.CrossRefLabelProvider;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.patch.FileDialogPatch;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.Viewport;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.statushandlers.StatusManager;

public class LineageUI
implements ISelectionProvider {
    private static String[] ZOOM_VALUES = new String[]{"5%", "10%", "25%", "50%", "75%", "100%", "125%", "150%", "175%", "200%", "400%"};
    private static int ZOOM_100 = 5;
    static ImageRegistry imageRegistry = new ImageRegistry();
    static final String ICON_ARRANGE_ALL = "arrangeAll";
    static final String ICON_IMPACT_ANALYSIS = "impatcAnalysis";
    static final String ICON_REVEAL = "reveal";
    static final String ICON_RESET = "reset";
    static final String INCOMING_ICON = "in";
    static final String OUTGING_ICON = "out";
    static final String SRC_ARROW_ICON = "srcArrow";
    static final String TRG_ARROW_ICON = "trgArrow";
    static final String EXPORT_PNG = "exportPNG";
    private CheckboxTreeViewer filesViewer;
    private CheckboxTreeViewer contentFilterViewer;
    private ILabelProvider labelProvider = null;
    private List<Object> input;
    private OptionsBean options = new OptionsBean();
    private HashMap<URI, Set<LineageTreeBuilder.Node>> nodesByURI = new HashMap();
    private LineageDraw2DHelper draw2DHelper;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new HashSet<ISelectionChangedListener>();
    private ComboViewer levelSelectorViewer;
    private CCombo zoomCbo;
    private ContainerLevel currentContainerLevel;
    private DecoratorHelper decorator = new DecoratorHelper();
    private HashMap<LineageTreeBuilder.Node, Collection<LineageTreeBuilder.GhostNode>> ghosts = new HashMap();
    private LineageTreeBuilder synchronizer;
    private FigureCanvas canvas;
    private List<Listener> refreshListeners = new ArrayList<Listener>();

    static {
        try {
            imageRegistry.put(ICON_ARRANGE_ALL, ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.gmf.runtime.diagram.ui.actions/icons/elcl16/arrangeall.gif")));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            imageRegistry.put(ICON_IMPACT_ANALYSIS, ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.cross.ui/icons/16x16/impact-analysis_16x16.png")));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            imageRegistry.put(ICON_REVEAL, ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.cross.ui/icons/16x16/reveal_16x16.png")));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            imageRegistry.put(ICON_RESET, ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.ui/icons/full/elcl16/progress_remall.png")));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            imageRegistry.put(INCOMING_ICON, ImageDescriptor.createFromURL((URL)new URL("platform:plugin/com.indy.gmf.map.edit/icons/full/obj16x16/SrcMapped16x16 _2.png")));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            imageRegistry.put(OUTGING_ICON, ImageDescriptor.createFromURL((URL)new URL("platform:plugin/com.indy.gmf.map.edit/icons/full/obj16x16/TrgMapped16x16_2.png")));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            imageRegistry.put(SRC_ARROW_ICON, ImageDescriptor.createFromURL((URL)new URL("platform:plugin/com.indy.cross.ui/icons/16x16/right-arrow-src-16x16.png")));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            imageRegistry.put(TRG_ARROW_ICON, ImageDescriptor.createFromURL((URL)new URL("platform:plugin/com.indy.cross.ui/icons/16x16/right-arrow-trg-16x16.png")));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            imageRegistry.put(EXPORT_PNG, ImageDescriptor.createFromURL((URL)new URL("platform:plugin/com.indy.cross.ui/icons/16x16/png_export_16x16.png")));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public LineageUI() {
        this.labelProvider = new CrossRefLabelProvider();
        this.draw2DHelper = new LineageDraw2DHelper(this.labelProvider, this);
    }

    public LineageTreeBuilder getSynchronizer() {
        return this.synchronizer;
    }

    public Composite createContent(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        Composite tuning = this.createTuningComposite(main);
        tuning.setLayoutData((Object)new GridData(4, 1, true, false));
        SashForm sash = new SashForm(main, 256);
        sash.setLayout((Layout)new GridLayout(3, false));
        sash.setLayoutData((Object)new GridData(1808));
        this.createFilterViewer((Composite)sash).setLayoutData((Object)new GridData(1, 4, false, true));
        Composite c = new Composite((Composite)sash, 0);
        GridLayout gl = null;
        gl = new GridLayout(3, false);
        c.setLayout((Layout)gl);
        gl.horizontalSpacing = 1;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        c.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createGraphViewer(c);
        this.createDetail((Composite)sash).setLayoutData((Object)new GridData(3, 4, false, true));
        sash.setWeights(new int[]{20, 100, 20});
        return main;
    }

    private Control createDetail(Composite parent) {
        final Composite c = new Composite(parent, 0);
        StackLayout layout = new StackLayout();
        c.setLayout((Layout)layout);
        Composite nodeComposite = new Composite(c, 0);
        layout.topControl = nodeComposite;
        GridLayout gl = null;
        gl = new GridLayout();
        nodeComposite.setLayout((Layout)gl);
        gl.marginHeight = 0;
        gl.marginTop = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 1;
        Text incomingfilter = new Text(nodeComposite, 2048);
        incomingfilter.setLayoutData((Object)new GridData(4, 1, true, false));
        final TreeViewer incomingModelViewer = new TreeViewer(nodeComposite, 68352);
        incomingModelViewer.getControl().setLayoutData((Object)new GridData(1808));
        incomingModelViewer.setAutoExpandLevel(-1);
        incomingModelViewer.setContentProvider((IContentProvider)new ResourceContentProvider());
        incomingModelViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        incomingModelViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((IResource)e1).getName().toLowerCase().compareTo(((IResource)e2).getName().toLowerCase());
            }
        });
        ResourceViewerFilter f = null;
        f = new ResourceViewerFilter(incomingfilter);
        incomingModelViewer.addFilter((ViewerFilter)f);
        incomingfilter.addModifyListener((ModifyListener)f);
        Listener decorationListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 41: {
                        this.measureItem(event);
                        break;
                    }
                    case 42: {
                        this.paintItem(event);
                        break;
                    }
                    case 40: {
                        this.eraseItem(event);
                    }
                }
            }

            private void eraseItem(Event event) {
                event.detail &= 0xFFFFFFEF;
                event.detail &= 0xFFFFFFF7;
            }

            private void paintItem(Event event) {
                TreeItem item = (TreeItem)event.item;
                List<Image> image1 = LineageUI.this.decorator.getDecorationImage(item.getData());
                Image image2 = ((ILabelProvider)incomingModelViewer.getLabelProvider()).getImage(item.getData());
                int offset = 0;
                if (image1 != null) {
                    for (Image i : image1) {
                        event.gc.drawImage(i, event.x + 1, event.y + 1);
                        offset = Math.max(offset, i.getImageData().width);
                    }
                }
                if (image2 != null) {
                    event.gc.drawImage(image2, event.x + 1 + offset, event.y + 1);
                    offset += image2.getImageData().width;
                }
                event.gc.drawText(((ILabelProvider)incomingModelViewer.getLabelProvider()).getText(item.getData()), event.x + offset, event.y + 2);
            }

            private void measureItem(Event event) {
                TreeItem item = (TreeItem)event.item;
                List<Image> im = LineageUI.this.decorator.getDecorationImage(item.getData());
                if (im != null && !im.isEmpty()) {
                    event.width += im.get((int)0).getImageData().width;
                }
            }
        };
        incomingModelViewer.getTree().addListener(41, decorationListener);
        incomingModelViewer.getTree().addListener(42, decorationListener);
        incomingModelViewer.getTree().addListener(40, decorationListener);
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HashSet l = new HashSet();
                ((LineageUI)LineageUI.this).decorator.outgoing.clear();
                ((LineageUI)LineageUI.this).decorator.incoming.clear();
                if (!event.getSelection().isEmpty()) {
                    Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (o instanceof LineageTreeBuilder.Node) {
                        HashSet<URI> incoming = new HashSet<URI>();
                        HashSet<URI> outgoing = new HashSet<URI>();
                        LineageTreeBuilder.Node n = (LineageTreeBuilder.Node)o;
                        ArrayList wrappers = new ArrayList();
                        for (LineageTreeBuilder.Node src : n.getSources()) {
                            incoming.addAll(LineageUI.this.synchronizer.getModelsPath4Source(n, src));
                        }
                        for (LineageTreeBuilder.Node trg : n.getTargets()) {
                            outgoing.addAll(LineageUI.this.synchronizer.getModelsPath4Target(n, trg));
                        }
                        ((LineageUI)LineageUI.this).decorator.incoming.addAll(incoming);
                        ((LineageUI)LineageUI.this).decorator.outgoing.addAll(outgoing);
                        l.addAll(incoming);
                        l.addAll(outgoing);
                    } else if (o instanceof LineageDraw2DHelper.ConnectionWrapper) {
                        l.addAll(((LineageUI)LineageUI.this).synchronizer.filesPerLink.get(o));
                    }
                }
                incomingModelViewer.setInput(l);
                c.layout(true);
            }
        });
        IDoubleClickListener openModelListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection().isEmpty()) {
                    return;
                }
                for (Object o : ((IStructuredSelection)event.getSelection()).toList()) {
                    if (!(o instanceof IFile)) continue;
                    try {
                        URI uri = Util.convertIFileToEMFURI((IFile)((IFile)o));
                        IEditorDescriptor d = IDE.getEditorDescriptor((String)uri.lastSegment());
                        URIEditorInput editorInput = new URIEditorInput(uri);
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, d.getId());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
        incomingModelViewer.addDoubleClickListener(openModelListener);
        return c;
    }

    private Control createFilterViewer(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new FillLayout(512));
        ICheckStateListener checkListener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                LineageUI.this.filterGraph();
            }
        };
        GridLayout gl = null;
        Composite cc = new Composite(c, 0);
        gl = new GridLayout();
        cc.setLayout((Layout)gl);
        gl.marginHeight = 0;
        gl.marginTop = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 1;
        final Text rfilter = new Text(cc, 2048);
        rfilter.setLayoutData((Object)new GridData(4, 1, true, false));
        rfilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LineageUI.this.filesViewer.refresh();
                LineageUI.this.filesViewer.expandAll();
            }
        });
        this.filesViewer = new CheckboxTreeViewer(cc, 2816);
        this.filesViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.filesViewer.setAutoExpandLevel(-1);
        this.filesViewer.setContentProvider((IContentProvider)new ResourceContentProvider());
        this.filesViewer.addCheckStateListener(checkListener);
        this.filesViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.filesViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((IResource)e1).getName().toLowerCase().compareTo(((IResource)e2).getName().toLowerCase());
            }
        });
        this.filesViewer.setInput(this.nodesByURI.keySet());
        this.filesViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                String pattern = rfilter.getText().replace("*", ".*").toUpperCase();
                if (pattern != null && !pattern.trim().isEmpty()) {
                    pattern = ".*" + pattern + ".*";
                    String elt = LineageUI.this.labelProvider.getText(element).toUpperCase();
                    if (elt.matches(pattern)) {
                        return true;
                    }
                    if (element instanceof IContainer) {
                        Object[] objectArray = ((ITreeContentProvider)LineageUI.this.filesViewer.getContentProvider()).getChildren(element);
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object o = objectArray[n2];
                            if (this.select(viewer, element, o)) {
                                return true;
                            }
                            ++n2;
                        }
                    }
                    return false;
                }
                return true;
            }
        });
        cc = new Composite(c, 0);
        gl = new GridLayout();
        cc.setLayout((Layout)gl);
        gl.marginHeight = 0;
        gl.marginTop = 5;
        gl.marginWidth = 0;
        gl.verticalSpacing = 1;
        final Text filter = new Text(cc, 2048);
        filter.setLayoutData((Object)new GridData(4, 1, true, false));
        filter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LineageUI.this.contentFilterViewer.refresh();
                LineageUI.this.contentFilterViewer.expandAll();
            }
        });
        this.contentFilterViewer = new CheckboxTreeViewer(cc, 2816);
        this.contentFilterViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.contentFilterViewer.setAutoExpandLevel(-1);
        this.contentFilterViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.contentFilterViewer.addCheckStateListener(checkListener);
        this.contentFilterViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LineageUI.this.draw2DHelper.reveal(event.getSelection());
            }
        });
        this.contentFilterViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                if (element instanceof LineageTreeBuilder.Node) {
                    return !((LineageTreeBuilder.Node)element).getChildren().isEmpty();
                }
                return false;
            }

            public Object getParent(Object element) {
                if (element instanceof LineageTreeBuilder.Node) {
                    return ((LineageTreeBuilder.Node)element).getParent();
                }
                return null;
            }

            public Object[] getElements(Object inputElement) {
                Collection c = (Collection)inputElement;
                return c.toArray(new Object[c.size()]);
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof LineageTreeBuilder.Node) {
                    Collection<LineageTreeBuilder.Node> c = ((LineageTreeBuilder.Node)parentElement).getChildren();
                    return c.toArray(new Object[c.size()]);
                }
                return null;
            }
        });
        this.contentFilterViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof LineageTreeBuilder.GhostNode) {
                    return false;
                }
                ContainerLevel l = LineageUI.this.getContainerLevel();
                if (l != null) {
                    return ((LineageTreeBuilder.Node)element).getContainerLevelNames().contains(l.getName());
                }
                return true;
            }
        });
        this.contentFilterViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                String pattern = filter.getText().replace("*", ".*").toUpperCase();
                if (pattern != null && !pattern.trim().isEmpty()) {
                    pattern = ".*" + pattern + ".*";
                    String elt = LineageUI.this.labelProvider.getText(element).toUpperCase();
                    if (elt.matches(pattern)) {
                        return true;
                    }
                    Object[] objectArray = ((ITreeContentProvider)LineageUI.this.contentFilterViewer.getContentProvider()).getChildren(element);
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        if (this.select(viewer, element, o)) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }
                return true;
            }
        });
        this.contentFilterViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((LineageTreeBuilder.Node)e1).getLabel().compareTo(((LineageTreeBuilder.Node)e2).getLabel());
            }
        });
        return c;
    }

    public void filterGraph() {
        Object o2;
        ArrayList<Object> l = new ArrayList<Object>();
        HashMap<URI, IFile> fileMap = new HashMap<URI, IFile>();
        for (Object o2 : (Collection)this.filesViewer.getInput()) {
            fileMap.put((URI)o2, Util.convertEMFURIToFile((URI)((URI)o2)));
        }
        Object object = this.filesViewer.getCheckedElements();
        int n = ((Object[])object).length;
        int n2 = 0;
        while (n2 < n) {
            o2 = object[n2];
            IPath p = ((IResource)o2).getFullPath();
            for (URI u : fileMap.keySet()) {
                if (!p.isPrefixOf(((IFile)fileMap.get(u)).getFullPath())) continue;
                l.add(u);
            }
            ++n2;
        }
        object = this.contentFilterViewer.getCheckedElements();
        n = ((Object[])object).length;
        n2 = 0;
        while (n2 < n) {
            o2 = object[n2];
            l.add(o2);
            Collection<LineageTreeBuilder.GhostNode> c = this.ghosts.get(o2);
            if (c != null) {
                l.addAll(c);
            }
            ++n2;
        }
        boolean needLayout = false;
        ContainerLevel lvl = this.getContainerLevel();
        if (lvl != null) {
            for (Object o3 : (Collection)this.contentFilterViewer.getInput()) {
                if (!(o3 instanceof LineageTreeBuilder.Node) || ((LineageTreeBuilder.Node)o3).getContainerLevelNames().contains(lvl.getName())) continue;
                l.add(o3);
                needLayout = true;
            }
        } else {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "com.indy.lineage.ui", Messages.LineageUI_43));
        }
        this.draw2DHelper.hideFigure(l, this.nodesByURI);
        if (needLayout) {
            this.draw2DHelper.layout2();
        }
    }

    private Composite createGraphViewer(Composite parent) {
        RotatedButton filterBt = new RotatedButton(parent, 8, Messages.LineageUI_44);
        filterBt.setToolTipText(Messages.LineageUI_45);
        filterBt.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                SashForm s = (SashForm)((Control)e.widget).getParent().getParent();
                int[] old = s.getWeights();
                int all = old[0] + old[1] + old[2];
                if (old[0] == 0) {
                    s.setWeights(new int[]{20 * all / 100, old[1] - 20 * all / 100, old[2]});
                } else {
                    int[] nArray = new int[3];
                    nArray[1] = all - old[2];
                    nArray[2] = old[2];
                    s.setWeights(nArray);
                }
            }
        });
        filterBt.setLayoutData(new GridData(1, 1, false, true));
        FigureCanvas f = new FigureCanvas(parent, 0x20000900);
        f.setLayoutData((Object)new GridData(4, 4, true, true));
        f.setViewport((Viewport)new FreeformViewport());
        f.setBackground(ColorConstants.white);
        f.setContents(this.draw2DHelper.getRootFigure());
        f.setScrollBarVisibility(FigureCanvas.ALWAYS);
        RotatedButton modelsBt = new RotatedButton(parent, 8, Messages.LineageUI_46);
        modelsBt.setToolTipText(Messages.LineageUI_47);
        modelsBt.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                SashForm s = (SashForm)((Control)e.widget).getParent().getParent();
                int[] old = s.getWeights();
                int all = old[0] + old[1] + old[2];
                if (old[2] == 0) {
                    s.setWeights(new int[]{old[0], old[1] - 20 * all / 100, 20 * all / 100});
                } else {
                    int[] nArray = new int[3];
                    nArray[0] = old[0];
                    nArray[1] = all - old[0];
                    s.setWeights(nArray);
                }
            }
        });
        modelsBt.setLayoutData(new GridData(1, 1, false, true));
        this.canvas = f;
        ZoomHandler zoomHandler = new ZoomHandler();
        this.canvas.addMouseWheelListener((MouseWheelListener)zoomHandler);
        this.canvas.addKeyListener((KeyListener)zoomHandler);
        return this.canvas;
    }

    private Composite createTuningComposite(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout gl = null;
        gl = new GridLayout(4, false);
        main.setLayout((Layout)gl);
        gl.marginHeight = 0;
        Composite c = new Composite(main, 0);
        gl = new GridLayout(2, false);
        c.setLayout((Layout)gl);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        Label l = new Label(c, 0);
        l.setLayoutData((Object)new GridData());
        l.setText(Messages.LineageUI_52);
        Combo cbo = new Combo(c, 2048);
        cbo.setLayoutData((Object)new GridData(4, 1, false, false));
        cbo.setItems(new String[]{Messages.LineageUI_53, "1", "2", "3"});
        cbo.select(1);
        cbo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = ((Combo)e.widget).getSelectionIndex();
                ((LineageUI)LineageUI.this).options.depth = i == 0 ? -1 : i;
            }
        });
        cbo.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Combo cbo = (Combo)e.getSource();
                String oldS = cbo.getText();
                String newS = String.valueOf(oldS.substring(0, e.start)) + e.text + oldS.substring(e.end);
                try {
                    Integer.parseInt(newS);
                }
                catch (Exception ex) {
                    e.doit = cbo.getItem(0).equals(newS);
                }
            }
        });
        cbo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    ((LineageUI)LineageUI.this).options.depth = Integer.parseInt(((Combo)e.widget).getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        ToolBar tb = new ToolBar(main, 256);
        tb.setLayoutData((Object)new GridData(1, 1, false, false));
        ToolItem b = new ToolItem(tb, 8);
        b.setToolTipText(Messages.LineageUI_57);
        b.setImage(imageRegistry.get(ICON_RESET));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List treeNodes = LineageUI.this.performAnalyze();
                Iterator iterator = LineageUI.this.refreshListeners.iterator();
                while (iterator.hasNext()) {
                    Listener l;
                    final Listener k = l = (Listener)iterator.next();
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                        }

                        public void run() throws Exception {
                            k.handleEvent(new Event());
                        }
                    });
                }
            }
        });
        b = new ToolItem(tb, 8);
        b.setToolTipText(Messages.LineageUI_58);
        b.setImage(imageRegistry.get(ICON_ARRANGE_ALL));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LineageUI.this.draw2DHelper.layout();
            }
        });
        final ToolItem showBaseNode = new ToolItem(tb, 8);
        showBaseNode.setToolTipText(Messages.LineageUI_59);
        showBaseNode.setImage(imageRegistry.get(ICON_REVEAL));
        showBaseNode.setEnabled(false);
        showBaseNode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList l = new ArrayList();
                for (Object o : ((IStructuredSelection)LineageUI.this.getSelection()).toList()) {
                    LineageTreeBuilder.Node obj;
                    if (!(o instanceof LineageTreeBuilder.GhostNode) || (obj = ((LineageTreeBuilder.GhostNode)o).getBaseNode()) == null) continue;
                    LineageUI.this.draw2DHelper.setSelectedNode(obj);
                    LineageUI.this.draw2DHelper.reveal(LineageUI.this.getSelection());
                    return;
                }
            }
        });
        final ToolItem launch = new ToolItem(tb, 8);
        launch.setToolTipText(Messages.LineageUI_60);
        launch.setImage(imageRegistry.get(ICON_IMPACT_ANALYSIS));
        launch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<EObject> l = new ArrayList<EObject>();
                for (Object o : ((IStructuredSelection)LineageUI.this.getSelection()).toList()) {
                    EObject obj;
                    if (!(o instanceof IAdaptable) || (obj = (EObject)((IAdaptable)o).getAdapter(EObject.class)) == null) continue;
                    l.add(obj);
                }
                if (!l.isEmpty()) {
                    CrossRefEditorInput input = new CrossRefEditorInput((IStructuredSelection)new StructuredSelection(l));
                    try {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, "com.indy.cross.ui.editor.CrossRefEditor");
                    }
                    catch (PartInitException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        launch.setEnabled(false);
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() == null || event.getSelection().isEmpty()) {
                    launch.setEnabled(false);
                    showBaseNode.setEnabled(false);
                } else {
                    showBaseNode.setEnabled(!event.getSelection().isEmpty() && ((IStructuredSelection)event.getSelection()).getFirstElement() instanceof LineageTreeBuilder.GhostNode);
                    for (Object o : ((IStructuredSelection)event.getSelection()).toList()) {
                        EObject obj;
                        if (!(o instanceof IAdaptable) || (obj = (EObject)((IAdaptable)o).getAdapter(EObject.class)) == null) continue;
                        launch.setEnabled(true);
                        return;
                    }
                    launch.setEnabled(false);
                }
            }
        });
        ToolItem exportPNG = new ToolItem(tb, 8);
        exportPNG.setToolTipText(Messages.LineageUI_62);
        exportPNG.setImage(imageRegistry.get(EXPORT_PNG));
        exportPNG.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(LineageUI.this.getMainControl().getShell(), 8192);
                dialog.setFilterExtensions(new String[]{"*.png"});
                String path = dialog.open();
                path = FileDialogPatch.addFileExtensionIfRequired((String)path, (FileDialog)dialog);
                if (path != null) {
                    LineageUI.this.draw2DHelper.exportAsImage(path);
                }
            }
        });
        this.zoomCbo = new CCombo(main, 0x800808);
        this.zoomCbo.setToolTipText("");
        this.zoomCbo.setLayoutData((Object)new GridData(4, 2, false, false));
        this.zoomCbo.setItems(ZOOM_VALUES);
        this.zoomCbo.select(ZOOM_100);
        this.zoomCbo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectedIndex = ((CCombo)e.widget).getSelectionIndex();
                String zoomLabel = ZOOM_VALUES[selectedIndex];
                float zoomValue = Float.valueOf(zoomLabel.replace("%", "")).floatValue() / 100.0f;
                LineageUI.this.draw2DHelper.performZoom(zoomValue);
            }
        });
        this.levelSelectorViewer = new ComboViewer(new CCombo(main, 0x800808));
        this.levelSelectorViewer.getCCombo().setLayoutData((Object)new GridData(1, 2, false, false));
        this.levelSelectorViewer.getControl().setVisible(false);
        this.levelSelectorViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.levelSelectorViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ContainerLevel)element).getName();
            }
        });
        this.levelSelectorViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LineageUI.this.currentContainerLevel = event.getSelection().isEmpty() ? null : (ContainerLevel)((IStructuredSelection)event.getSelection()).getFirstElement();
                LineageUI.this.filterGraph();
                LineageUI.this.filesViewer.refresh();
                LineageUI.this.contentFilterViewer.refresh();
            }
        });
        return main;
    }

    void refreshFiltersContent(Collection<LineageTreeBuilder.Node> treeNodes) {
        Object[] fChecked = this.filesViewer.getCheckedElements();
        this.nodesByURI.clear();
        this.filesViewer.refresh();
        this.ghosts.clear();
        HashSet<LineageTreeBuilder.Node> rootNodes = new HashSet<LineageTreeBuilder.Node>();
        for (LineageTreeBuilder.Node n : treeNodes) {
            if (n.getWrappedObjectFileLocation().endsWith("map") || !rootNodes.add(n)) continue;
            URI uri = n.getFileURI();
            Set<LineageTreeBuilder.Node> s = null;
            s = this.nodesByURI.get(uri);
            if (s == null) {
                s = new HashSet<LineageTreeBuilder.Node>();
                this.nodesByURI.put(uri, s);
            }
            s.add(n);
            if (!(n instanceof LineageTreeBuilder.GhostNode)) continue;
            Collection<LineageTreeBuilder.GhostNode> c = this.ghosts.get(((LineageTreeBuilder.GhostNode)n).getBaseNode());
            if (c == null) {
                c = new HashSet<LineageTreeBuilder.GhostNode>();
                this.ghosts.put(((LineageTreeBuilder.GhostNode)n).getBaseNode(), c);
            }
            c.add((LineageTreeBuilder.GhostNode)n);
        }
        Object[] checked = this.contentFilterViewer.getCheckedElements();
        this.contentFilterViewer.setInput(rootNodes);
        this.contentFilterViewer.setCheckedElements(checked);
        this.filesViewer.expandAll();
        this.filesViewer.setCheckedElements(fChecked);
        this.filesViewer.refresh();
    }

    public void setInput(List<Object> input) {
        HashMap replacement = new HashMap();
        if (this.input == null) {
            this.input = new ArrayList<Object>();
        } else {
            this.input.clear();
        }
        this.input.addAll(input);
        for (Object k : replacement.keySet()) {
            this.input.remove(k);
            this.input.addAll((Collection)replacement.get(k));
        }
        List<LineageTreeBuilder.Node> treeNodes = this.performAnalyze();
    }

    private List<LineageTreeBuilder.Node> performAnalyze() {
        final ArrayList<LineageTreeBuilder.Node> treeNodes = new ArrayList<LineageTreeBuilder.Node>();
        try {
            new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    block3: {
                        try {
                            LineageUI.this.synchronizer = new LineageTreeBuilder();
                            treeNodes.addAll(LineageUI.this.synchronizer.buildTree(monitor, LineageUI.this.input, ((LineageUI)LineageUI.this).options.depth));
                            Collections.sort(treeNodes, LineageTreeBuilder.NODE_COMPARATOR);
                            for (LineageTreeBuilder.Node n : treeNodes) {
                                n.sort();
                            }
                        }
                        catch (Exception ex) {
                            if (monitor.isCanceled()) break block3;
                            throw new InvocationTargetException(ex);
                        }
                    }
                }
            });
            this.draw2DHelper.refreshGraph(treeNodes);
            this.nodesByURI.clear();
            this.filesViewer.refresh();
            this.refreshFiltersContent(treeNodes);
            Collection<ContainerLevel> l = this.synchronizer.getAvailableLevels();
            this.levelSelectorViewer.setInput(l);
            if (l.size() > 1) {
                this.levelSelectorViewer.getControl().setVisible(true);
                this.levelSelectorViewer.getControl().getParent().layout();
                this.levelSelectorViewer.setSelection((ISelection)new StructuredSelection((Object)this.synchronizer.getActiveContainerLevel()));
            } else {
                this.levelSelectorViewer.getControl().setVisible(false);
            }
            this.filterGraph();
        }
        catch (Exception e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.lineage.ui", Messages.LineageUI_68, e.getCause()));
            return Collections.EMPTY_LIST;
        }
        return treeNodes;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.draw2DHelper.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    protected void notifyListeners() {
        for (ISelectionChangedListener l : this.selectionChangedListeners) {
            l.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }
    }

    public void setSelection(ISelection selection) {
        if (selection.isEmpty()) {
            this.draw2DHelper.setSelectedNode(null);
        } else {
            this.draw2DHelper.setSelectedNode((LineageTreeBuilder.Node)((IStructuredSelection)selection).getFirstElement());
            this.draw2DHelper.reveal(selection);
        }
    }

    public LineageDraw2DHelper getDraw2DHelper() {
        return this.draw2DHelper;
    }

    public void addRefreshListener(Listener l) {
        this.refreshListeners.add(l);
    }

    public void removeRefreshListener(Listener l) {
        this.refreshListeners.add(l);
    }

    public Composite getMainControl() {
        return this.canvas;
    }

    public ContainerLevel getContainerLevel() {
        return this.currentContainerLevel == null ? this.synchronizer.getActiveContainerLevel() : this.currentContainerLevel;
    }

    private class DecoratorHelper {
        Set incoming = new HashSet();
        Set outgoing = new HashSet();

        private DecoratorHelper() {
        }

        public void dispose() {
            this.incoming.clear();
            this.outgoing.clear();
        }

        public List<Image> getDecorationImage(Object element) {
            int mode = 0;
            if (this.incoming.contains(element)) {
                ++mode;
            }
            if (this.outgoing.contains(element)) {
                mode += 10;
            }
            ArrayList<Image> l = new ArrayList<Image>();
            Object desc = null;
            switch (mode) {
                case 1: {
                    l.add(imageRegistry.get(LineageUI.INCOMING_ICON));
                    break;
                }
                case 10: {
                    l.add(imageRegistry.get(LineageUI.OUTGING_ICON));
                    break;
                }
                case 11: {
                    l.add(imageRegistry.get(LineageUI.INCOMING_ICON));
                    l.add(imageRegistry.get(LineageUI.OUTGING_ICON));
                    break;
                }
                default: {
                    return Collections.EMPTY_LIST;
                }
            }
            return l;
        }
    }

    private class OptionsBean {
        int depth = 1;

        private OptionsBean() {
        }
    }

    private class ResourceContentProvider
    implements ITreeContentProvider {
        List<IFile> files = new ArrayList<IFile>();

        private ResourceContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.files.clear();
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IContainer) {
                try {
                    return ((IContainer)element).members().length > 0;
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            return false;
        }

        public Object getParent(Object element) {
            if (element instanceof IProject) {
                return null;
            }
            if (element instanceof IResource) {
                return ((IResource)element).getParent();
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            this.files.clear();
            HashSet<IProject> roots = new HashSet<IProject>();
            for (Object p : (Collection)inputElement) {
                IFile f = null;
                if (p instanceof IFile) {
                    f = (IFile)p;
                    this.files.add(f);
                } else if (p instanceof URI) {
                    f = Util.convertEMFURIToFile((URI)((URI)p));
                    this.files.add(f);
                }
                if (f == null) continue;
                roots.add(f.getProject());
            }
            return roots.toArray(new Object[roots.size()]);
        }

        public Object[] getChildren(Object parentElement) {
            if (!(parentElement instanceof IContainer)) {
                return null;
            }
            ArrayList<IResource> l = new ArrayList<IResource>();
            try {
                IResource[] iResourceArray = ((IContainer)parentElement).members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource r = iResourceArray[n2];
                    for (IFile f : this.files) {
                        if (f == null || parentElement == null || f.getProject() != ((IResource)parentElement).getProject() || !r.getProjectRelativePath().isPrefixOf(f.getProjectRelativePath())) continue;
                        l.add(r);
                        break;
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            return l.toArray(new Object[l.size()]);
        }
    }

    private class ResourceViewerFilter
    extends ViewerFilter
    implements ModifyListener {
        private Text filterWidget;
        private Viewer viewer;

        public ResourceViewerFilter(Text filterWidget) {
            this.filterWidget = filterWidget;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            this.viewer = viewer;
            String pattern = this.filterWidget.getText().replace("*", ".*").toUpperCase();
            if (pattern != null && !pattern.trim().isEmpty()) {
                pattern = ".*" + pattern + ".*";
                String elt = LineageUI.this.labelProvider.getText(element).toUpperCase();
                if (elt.matches(pattern)) {
                    return true;
                }
                if (element instanceof IContainer) {
                    Object[] objectArray = ((ITreeContentProvider)((ContentViewer)viewer).getContentProvider()).getChildren(element);
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        if (this.select(viewer, element, o)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                return false;
            }
            return true;
        }

        public void modifyText(ModifyEvent e) {
            if (this.viewer != null) {
                this.viewer.refresh();
            }
        }
    }

    public class RotatedButton
    extends Canvas {
        private String text;
        private Point sz;
        private boolean hovered;

        public RotatedButton(Composite parent, int style, String txt) {
            super(parent, style | 0x20000000);
            this.sz = null;
            this.hovered = false;
            this.text = txt;
            this.setCursor(Cursors.HAND);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    e.gc.setFont(e.display.getSystemFont());
                    Rectangle r = RotatedButton.this.getClientArea();
                    e.gc.setAdvanced(true);
                    if (RotatedButton.this.hovered) {
                        e.gc.setForeground(e.display.getSystemColor(26));
                    } else {
                        e.gc.setForeground(e.display.getSystemColor(15));
                    }
                    e.gc.setAntialias(1);
                    e.gc.drawRectangle(r.x + 1, r.y + 1, r.width - 2, r.height - 2);
                    e.gc.setForeground(e.display.getSystemColor(2));
                    Transform tr = new Transform((Device)e.display);
                    Point p = e.gc.stringExtent(RotatedButton.this.text);
                    p = new Point(p.y, p.x);
                    tr.translate(5.0f, 5.0f);
                    tr.rotate(270.0f);
                    e.gc.setAdvanced(true);
                    e.gc.setTransform(tr);
                    e.gc.drawString(RotatedButton.this.text, -3 - p.y, -3);
                    tr.dispose();
                }
            });
            this.addListener(6, new Listener(){

                public void handleEvent(Event event) {
                    RotatedButton.this.hovered = true;
                    RotatedButton.this.redraw();
                }
            });
            this.addListener(7, new Listener(){

                public void handleEvent(Event event) {
                    RotatedButton.this.hovered = false;
                    RotatedButton.this.redraw();
                }
            });
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            if (this.sz == null) {
                GC gc = new GC((Drawable)this.getDisplay());
                Point pt = gc.stringExtent(" " + this.text + " ");
                pt.x += 5;
                pt.y += 5;
                this.sz = new Point(pt.y, pt.x);
                gc.dispose();
            }
            return this.sz;
        }
    }

    private class ZoomHandler
    implements MouseWheelListener,
    KeyListener {
        private boolean ctrlPressed = false;

        private ZoomHandler() {
        }

        public void keyPressed(KeyEvent e) {
            if ((e.stateMask & 0x40000) != 0 || e.keyCode == 262144) {
                this.ctrlPressed = true;
            }
        }

        public void keyReleased(KeyEvent e) {
            if ((e.stateMask & 0x40000) != 0 || e.keyCode == 262144) {
                this.ctrlPressed = false;
            }
        }

        public void mouseScrolled(MouseEvent e) {
            if (this.ctrlPressed) {
                int i = LineageUI.this.zoomCbo.getSelectionIndex();
                if (e.count > 0) {
                    if (i + 1 < ZOOM_VALUES.length) {
                        LineageUI.this.zoomCbo.select(i + 1);
                        String zoomLabel = ZOOM_VALUES[i + 1];
                        float zoomValue = Float.valueOf(zoomLabel.replace("%", "")).floatValue() / 100.0f;
                        LineageUI.this.draw2DHelper.performZoom(zoomValue);
                    }
                } else if (i > 0) {
                    LineageUI.this.zoomCbo.select(i - 1);
                    String zoomLabel = ZOOM_VALUES[i - 1];
                    float zoomValue = Float.valueOf(zoomLabel.replace("%", "")).floatValue() / 100.0f;
                    LineageUI.this.draw2DHelper.performZoom(zoomValue);
                }
            }
        }
    }
}

