/*
 * Decompiled with CFR 0.152.
 */
package com.indy.cross.ui;

import com.indy.cross.ui.Messages;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.models.EMFResourceOptions;
import com.semarchy.xdi.designer.core.models.IndyResourceUtil;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.registry.ICrossReference;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.MemoryMonitor;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class RefreshCrossRegistryHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ExtractJob job = new ExtractJob();
        job.setUser(true);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
        return null;
    }

    class ExtractJob
    extends WorkspaceJob {
        TransactionalEditingDomain editingDomain;
        IRegistryService.IRegistry<ICrossReference> registry;

        ExtractJob() {
            super(Messages.RefreshCrossRegistryHandler_0);
            this.editingDomain = null;
            this.registry = ((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(ICrossReference.class);
            this.editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
            ResourceSet rs = this.editingDomain.getResourceSet();
            ((ResourceSetImpl)rs).setURIResourceMap(new WeakHashMap());
            rs.setURIConverter((URIConverter)new InternalResourceURIConverter(false));
            rs.getLoadOptions().put(EMFResourceOptions.LOAD_OPTION_NO_BATCH_VALIDATION, Boolean.TRUE);
            rs.getLoadOptions().put("com.indy.gmf.map.LOAD_OPTION_NO_MAP_REF_SYNC", Boolean.TRUE);
            rs.getLoadOptions().put("com.indy.gmf.map.LOAD_OPTION_NO_MAP_UPDATE", Boolean.TRUE);
            rs.getLoadOptions().put(EMFResourceOptions.LOAD_OPTION_NO_EXTERNAIZATION_LOADING, Boolean.TRUE);
            rs.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
            rs.getLoadOptions().put("PROCESS_DANGLING_HREF", "RECORD");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            try {
                ICacheService service;
                List sources = null;
                ICacheService iCacheService = service = (ICacheService)E4InjectorHelper.getService(ICacheService.class);
                synchronized (iCacheService) {
                    sources = service.getSourceWithCrossReferences();
                }
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)sources.size());
                for (URI s : sources) {
                    SubMonitor cur = sub.newChild(1);
                    cur.setTaskName(s.toString());
                    if (sub.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    if (this.freeMemory()) {
                        ((ICacheService.IBatchedListener)this.registry).handBatchedEvents();
                    }
                    try {
                        Resource r = this.editingDomain.getResourceSet().getResource(s, true);
                        if (r instanceof IRegistryService.IRegistrationContribution) {
                            IFile f;
                            URI lineageURI = Util.getResourceLineageURI((URI)s);
                            if (lineageURI != null && (f = Util.convertEMFURIToFile((URI)lineageURI)) != null && f.exists()) {
                                f.delete(true, (IProgressMonitor)new NullProgressMonitor());
                            }
                            this.registry.registerFrom(((IndyResourceUtil.IndyResource)r).getId(), (IRegistryService.IRegistrationContribution)r);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    cur.done();
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                this.editingDomain.dispose();
                this.editingDomain = null;
            }
        }

        private boolean freeMemory() {
            if (MemoryMonitor.isMemoryLow((int)40)) {
                this.editingDomain.getCommandStack().flush();
                ((ResourceSetImpl)this.editingDomain.getResourceSet()).getURIResourceMap().clear();
                for (Resource r : this.editingDomain.getResourceSet().getResources()) {
                    try {
                        r.unload();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.editingDomain.getResourceSet().getResources().clear();
                return true;
            }
            return false;
        }
    }
}

