/*
 * Decompiled with CFR 0.152.
 */
package com.indy.osgihook;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommonUtils {
    static CommonUtils INSTANCE = new CommonUtils();
    static FileMaskApi fileMaskApi = new FileMaskApi();

    public static List<File> getFile(String masks, String separator) {
        return fileMaskApi.getFile(masks.split(separator));
    }

    private static class FileMaskApi {
        private FileMaskApi() {
        }

        void fillStack(File file, List<File> stack) {
            if (file != null) {
                this.fillStack(file.getParentFile(), stack);
                stack.add(file);
            }
        }

        public String replaceWildCharsWithGroups(String wild) {
            StringBuffer buffer = new StringBuffer();
            char[] chars = wild.toCharArray();
            int i = 0;
            while (i < chars.length) {
                if (chars[i] == '*') {
                    buffer.append("(.*)");
                } else if (chars[i] == '?') {
                    buffer.append("(.)");
                } else if ("+()^$.{}[]|\\".indexOf(chars[i]) != -1) {
                    buffer.append('\\').append(chars[i]);
                } else {
                    buffer.append(chars[i]);
                }
                ++i;
            }
            return buffer.toString();
        }

        void getAllRecursDir(File dir, List<File> list, List<File> excludes) {
            if (dir.isDirectory() && (excludes == null || !excludes.contains(dir))) {
                list.add(dir);
                if (dir.listFiles() != null) {
                    File[] fileArray = dir.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File child = fileArray[n2];
                        this.getAllRecursDir(child, list, excludes);
                        ++n2;
                    }
                }
            }
        }

        void fillList2(File parentRealFile, Level parentLevel, List<File> list, int index, boolean recursive, List<File> excludes) {
            if (parentRealFile == null) {
                ++index;
                for (Level child : parentLevel.level.values()) {
                    this.fillList2(child.file, child, list, index, recursive, excludes);
                }
                return;
            }
            if (excludes != null && excludes.contains(parentRealFile)) {
                return;
            }
            if (!parentRealFile.exists()) {
                return;
            }
            if (parentLevel.isLeaf) {
                list.add(parentRealFile);
                return;
            }
            if (!parentLevel.isLeaf && parentRealFile.isDirectory()) {
                for (Level childLevel : parentLevel.level.values()) {
                    File childRealFile = new File(parentRealFile, childLevel.file.getName());
                    String name = childRealFile.getName();
                    if (name == null) continue;
                    if (name.equals("**")) {
                        ArrayList<File> allDirs = new ArrayList<File>();
                        this.getAllRecursDir(parentRealFile, allDirs, excludes);
                        for (File dir : allDirs) {
                            this.fillList2(dir, childLevel, list, index, true, excludes);
                        }
                        continue;
                    }
                    if (name.indexOf(42) > -1 || name.indexOf(63) > -1) {
                        String pattern = this.replaceWildCharsWithGroups(name);
                        if (parentRealFile.listFiles() == null) continue;
                        File[] fileArray = parentRealFile.listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File _file = fileArray[n2];
                            if (_file.getName().matches(pattern)) {
                                this.fillList2(_file, childLevel, list, index, recursive, excludes);
                            }
                            ++n2;
                        }
                        continue;
                    }
                    this.fillList2(childRealFile, childLevel, list, index, recursive, excludes);
                }
            }
        }

        void fillRoot(Level root, List<List<File>> stacks) {
            for (List<File> stack : stacks) {
                Level current = root;
                int i = -1;
                for (File fi : stack) {
                    ++i;
                    Level l = current.level.get(fi.getName());
                    if (l == null) {
                        l = new Level();
                        l.file = fi;
                        if (i + 1 == stack.size()) {
                            l.isLeaf = true;
                        }
                        current.level.put(fi.getName(), l);
                    }
                    current = l;
                }
            }
        }

        List<File> getFile(String ... mask) {
            ArrayList<List<File>> stacks = new ArrayList<List<File>>();
            ArrayList<List<File>> excludes = new ArrayList<List<File>>();
            String[] stringArray = mask;
            int n = mask.length;
            int n2 = 0;
            while (n2 < n) {
                String _mask = stringArray[n2];
                boolean exclude = (_mask = _mask.trim()).startsWith("exclude::");
                if (exclude) {
                    _mask = _mask.substring(9);
                }
                ArrayList<File> stack = new ArrayList<File>();
                File f = new File(_mask);
                this.fillStack(f, stack);
                if (exclude) {
                    excludes.add(stack);
                } else {
                    stacks.add(stack);
                }
                ++n2;
            }
            Level root = new Level();
            this.fillRoot(root, stacks);
            Level rootExclude = new Level();
            this.fillRoot(rootExclude, excludes);
            ArrayList<File> _excludes = new ArrayList<File>();
            this.fillList2(null, rootExclude, _excludes, -1, false, null);
            ArrayList<File> list = new ArrayList<File>();
            this.fillList2(null, root, list, -1, false, _excludes);
            return list;
        }
    }

    class Group {
        Group parent;
        List<Group> children = new ArrayList<Group>();
        String current;
        String code;

        Group() {
        }

        Group addGroup() {
            Group group = new Group();
            group.parent = this;
            this.children.add(group);
            return group;
        }

        public String toString() {
            if (this.current != null && !this.current.isEmpty()) {
                return this.current;
            }
            String str = "(";
            int i = 0;
            while (i < this.children.size()) {
                Group grp = this.children.get(i);
                if (i > 0) {
                    str = String.valueOf(str) + ",";
                }
                str = String.valueOf(str) + grp.toString();
                ++i;
            }
            str = String.valueOf(str) + ")";
            return str;
        }
    }

    static class Level {
        Map<String, Level> level = new HashMap<String, Level>();
        File file;
        boolean isLeaf;

        Level() {
        }
    }
}

