/*
 * Decompiled with CFR 0.152.
 */
package com.indy.osgihook;

import com.indy.osgihook.CopyFilesTask;
import com.indy.osgihook.ExternalJarHook;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.eclipse.osgi.internal.hookregistry.BundleFileWrapperFactoryHook;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.storage.bundlefile.BundleFileWrapper;
import org.eclipse.osgi.storage.bundlefile.DirBundleFile;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Version;

public class RuntimeDeployer
implements BundleFileWrapperFactoryHook {
    private static final String OSGI_BUNDLE_NAME = "org.eclipse.osgi";
    private boolean isOsgiBundleDeployed = false;
    private BundleFile osgiBundleFile = null;
    private String osgiDeploymentParams = null;
    private Map<String, Version> versionByBundleNameToDeploy = new HashMap<String, Version>();

    public BundleFileWrapper wrapBundleFile(BundleFile bundleFile, BundleInfo.Generation generation, boolean base) {
        block33: {
            if (bundleFile.getBaseFile().getName().startsWith("org.eclipse.osgi_") && this.osgiBundleFile == null && !(bundleFile instanceof DirBundleFile)) {
                this.osgiBundleFile = bundleFile;
                if (!this.isOsgiBundleDeployed && this.osgiDeploymentParams != null) {
                    ExternalJarHook.logln("\tLine \"OSGI_BUNDLE_NAME\" detected");
                    String bundleName = this.osgiBundleFile.getBaseFile().getName();
                    try {
                        try {
                            this.doExtractBundle(this.getManifestInfo(bundleFile, generation), bundleName, bundleFile, bundleName, base);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            this.isOsgiBundleDeployed = true;
                            break block33;
                        }
                    }
                    catch (Throwable throwable) {
                        this.isOsgiBundleDeployed = true;
                        throw throwable;
                    }
                    this.isOsgiBundleDeployed = true;
                }
            }
        }
        HashSet<String> keys = new HashSet<String>();
        HashSet classpasth = new HashSet();
        BundleEntry hookProprtiesEntry = bundleFile.getEntry("hook.properties");
        if (hookProprtiesEntry != null) {
            Properties properties = new Properties();
            try {
                Throwable throwable = null;
                Object var9_13 = null;
                try (BufferedInputStream is = new BufferedInputStream(hookProprtiesEntry.getFileURL().openStream());){
                    properties.load(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ExternalJarHook.logln(String.valueOf(bundleFile.getBaseFile().getName()) + ": Hook file found");
                ArrayList<Object> orderedKeys = new ArrayList<Object>(properties.keySet());
                Collections.sort(orderedKeys, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        String s1 = o1.toString();
                        String s2 = o2.toString();
                        if (s1.startsWith("remove")) {
                            return -1;
                        }
                        if (s2.startsWith("remove")) {
                            return 1;
                        }
                        return s1.compareTo(s2);
                    }
                });
                for (Object e : orderedKeys) {
                    String bundleName;
                    String key = (String)e;
                    String params = properties.getProperty(key);
                    if (keys.contains(String.valueOf(key) + "=" + params)) continue;
                    if (key.startsWith("extract.")) {
                        if (key.startsWith("extract./") || key.startsWith("extract.lib")) {
                            ExternalJarHook.logln("\tSTOP");
                        }
                        ExternalJarHook.logln("\tLine \"" + key + "\" detected");
                        keys.add(String.valueOf(key) + "=" + params);
                        String fromDir = key.substring(key.indexOf(".") + 1);
                        String[] lines = params.split(",");
                        int i = 0;
                        while (i < lines.length) {
                            CopyFilesTask cft = new CopyFilesTask(bundleFile, fromDir, lines[i]);
                            cft.run();
                            ++i;
                        }
                        continue;
                    }
                    if (key.startsWith("remove")) {
                        ExternalJarHook.logln("\tLine \"" + key + "\" detected");
                        keys.add(String.valueOf(key) + "=" + params);
                        String _file = key.substring(key.indexOf(".") + 1);
                        File file = new File(String.valueOf(ExternalJarHook.stambiaRuntimeDir) + File.separator + _file);
                        ExternalJarHook.logln("\tFile to delete \"" + file.getAbsolutePath() + "\"");
                        if (!file.exists()) continue;
                        ExternalJarHook.logln("\tFile existed \"" + file.getAbsolutePath() + "\"");
                        if (ExternalJarHook.deleteFile(file)) {
                            ExternalJarHook.logln("\tFile deleted \"" + file.getAbsolutePath() + "\"");
                            continue;
                        }
                        ExternalJarHook.logln("\tFile not deleted \"" + file.getAbsolutePath() + "\"");
                        continue;
                    }
                    if (key.startsWith("extractOSGIBundle")) {
                        if (this.isOsgiBundleDeployed) continue;
                        if (this.osgiBundleFile == null) {
                            this.osgiDeploymentParams = params;
                            continue;
                        }
                        ExternalJarHook.logln("\tLine \"" + key + "\" detected");
                        bundleName = this.osgiBundleFile.getBaseFile().getName();
                        try {
                            try {
                                this.doExtractBundle(this.getManifestInfo(bundleFile, generation), bundleName, this.osgiBundleFile, params, false);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                this.isOsgiBundleDeployed = true;
                                continue;
                            }
                        }
                        catch (Throwable throwable2) {
                            this.isOsgiBundleDeployed = true;
                            throw throwable2;
                        }
                        this.isOsgiBundleDeployed = true;
                        continue;
                    }
                    if (!key.startsWith("extractBundle")) continue;
                    ExternalJarHook.logln("\tLine \"" + key + "\" detected");
                    bundleName = bundleFile.getBaseFile().getName();
                    try {
                        this.doExtractBundle(this.getManifestInfo(bundleFile, generation), bundleName, bundleFile, params, true);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return null;
    }

    private ManifestInfo getManifestInfo(BundleFile file, BundleInfo.Generation generation) {
        try {
            BundleEntry manifest = file.getEntry("META-INF/MANIFEST.MF");
            if (manifest != null) {
                Map merged = ManifestElement.parseBundleManifest((InputStream)manifest.getInputStream(), new HashMap());
                String version = (String)merged.get("Bundle-Version");
                String name = (String)merged.get("Bundle-SymbolicName");
                if (version != null) {
                    return ManifestInfo.of(name, version);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void doExtractBundle(ManifestInfo manifestInfo, String bundleName, BundleFile bundleFile, String parameters, boolean useProtectionRules) throws Exception {
        Version currentVersion = this.versionByBundleNameToDeploy.get(manifestInfo.bundleName);
        if (currentVersion != null && currentVersion.compareTo(manifestInfo.version) > 0) {
            ExternalJarHook.logln(String.format("skip extracting %s (%s) because version %s already extracted", bundleName, manifestInfo.version.toString(), currentVersion.toString()));
            return;
        }
        this.versionByBundleNameToDeploy.put(manifestInfo.bundleName, manifestInfo.version);
        ExternalJarHook.extractBundle(bundleName, bundleFile, parameters, useProtectionRules);
    }

    private static class ManifestInfo {
        String bundleName;
        Version version;

        private ManifestInfo() {
        }

        static ManifestInfo of(String name, String version) {
            ManifestInfo m = new ManifestInfo();
            m.bundleName = name;
            m.version = Version.parseVersion((String)version);
            return m;
        }
    }
}

