/*
 * Decompiled with CFR 0.152.
 */
package com.indy.osgihook.utils;

import com.indy.osgihook.utils.JavaProps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.osgi.service.environment.EnvironmentInfo;

public class StambiaEnvironmentPropertyReader {
    private static final Set<String> supportedPropertiesWithReplacement = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(JavaProps.RUNTIME_HOME.label(), JavaProps.RUNTIME_HOME.getAlias(), JavaProps.MODULES_FOLDER.label(), JavaProps.MODULES_FOLDER.getAlias(), "skipLicenseAgreement")));

    public static String readProperty(String propertyName, EnvironmentInfo info) {
        String value = info.getProperty(propertyName);
        if (value != null && supportedPropertiesWithReplacement.contains(propertyName)) {
            value = StambiaEnvironmentPropertyReader.resolveVariable(value, info);
        }
        return value;
    }

    public static String readProperty(JavaProps prop, EnvironmentInfo info) {
        Optional<String> o;
        String value = StambiaEnvironmentPropertyReader.readProperty(prop.label(), info);
        if (value == null && (o = Stream.of(prop.getAlias()).map(s -> StambiaEnvironmentPropertyReader.readProperty(s, info)).filter(s -> s != null).findFirst()).isPresent()) {
            value = o.get();
        }
        if (value == null) {
            value = prop.getDefault();
        }
        return value;
    }

    private static String resolveVariable(String value, EnvironmentInfo info) {
        if (value == null) {
            return value;
        }
        if (value.startsWith(VariablePlaceHolder.USER_HOME.placeHolder)) {
            return StambiaEnvironmentPropertyReader.replaceVariable(value, info, VariablePlaceHolder.USER_HOME);
        }
        if (value.startsWith(VariablePlaceHolder.USER_DIR.placeHolder)) {
            return StambiaEnvironmentPropertyReader.replaceVariable(value, info, VariablePlaceHolder.USER_DIR);
        }
        return value;
    }

    private static String replaceVariable(String source, EnvironmentInfo info, VariablePlaceHolder var) {
        String value = info.getProperty(var.propertyName);
        if (value == null) {
            value = "";
        }
        return String.valueOf(value) + source.substring(var.placeHolder.length());
    }

    static enum VariablePlaceHolder {
        USER_HOME("@user.home", "user.home"),
        USER_DIR("@user.dir", "user.dir");

        String placeHolder;
        String propertyName;

        private VariablePlaceHolder(String placeHolder, String propertyName) {
            this.placeHolder = placeHolder;
            this.propertyName = propertyName;
        }
    }
}

