/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.conf.custom.internal;

import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.indy.ui.conf.custom.Activator;
import com.indy.ui.conf.custom.Messages;
import com.indy.ui.custom.out.TextDialogEditor;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.services.IConfigurationAuthenticator;
import com.semarchy.xdi.engine.common.exceptions.OtherExceptionI;
import com.stambia.cfc.Configuration;
import com.stambia.cfc.IConfigurationProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(service={IConfigurationAuthenticator.class}, scope=ServiceScope.SINGLETON)
public class ConfigurationAuthenticator
implements IConfigurationAuthenticator {
    @Reference
    private IConfigurationProvider provider;

    public boolean validateConfigurationCredentials(String configurationName, IConfigurationAuthenticator.Mode mode) {
        boolean res = this.checkCredentials(this.provider.getConfiguration(configurationName), mode);
        return res;
    }

    public boolean validateCurrentConfigurationCredentials(IConfigurationAuthenticator.Mode mode) {
        boolean res = this.checkCredentials(this.provider.getConfiguration(), mode);
        return res;
    }

    private boolean authenticationRequired(Configuration configuration, IConfigurationAuthenticator.Mode mode) {
        return mode == IConfigurationAuthenticator.Mode.SELECTION && configuration.isSelectionProtection() || mode == IConfigurationAuthenticator.Mode.GENERATION && configuration.isExecutionProtection();
    }

    private boolean checkCredentials(Configuration configuration, IConfigurationAuthenticator.Mode mode) {
        boolean ok = true;
        if (this.authenticationRequired(configuration, mode)) {
            ok = false;
            Shell shell = Util.getCurrentShellOrCreateShell();
            if (configuration.getPassword() != null && !configuration.getPassword().isEmpty()) {
                TextDialogEditor tde = new TextDialogEditor(shell, String.valueOf(Messages.BuildUtil_7) + configuration.getCode(), String.valueOf(Messages.BuildUtil_8) + configuration.getCode().toString(), "");
                tde.setStyle(0x400000);
                tde.setMonoLine(true);
                while (!ok && tde.open() == 0) {
                    String password = tde.getValue();
                    try {
                        SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                        semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                        password = semaphoreManager.setSemaphore(true, tde.getValue());
                    }
                    catch (OtherExceptionI e) {
                        Activator.getDefault().getLog().info("Failed to parse credentials password", (Throwable)e);
                    }
                    boolean bl = ok = tde.getValue() != null && password != null && password.equals(configuration.getPassword());
                }
            } else if (MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.BuildUtil_11, (String)(String.valueOf(Messages.BuildUtil_12) + configuration.getCode()))) {
                ok = true;
            }
        }
        return ok;
    }
}

