/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.conf.custom.internal;

import com.indy.ui.conf.custom.Messages;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IEvaluationConfigurationService;
import com.semarchy.xdi.designer.core.utils.EMFResourceUtil;
import com.stambia.cfc.Cfc;
import com.stambia.cfc.CfcFactory;
import com.stambia.cfc.CfcPackage;
import com.stambia.cfc.Configuration;
import com.stambia.cfc.IConfigurationProvider;
import com.stambia.cfc.util.CfcResourceFactoryImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ServiceScope;

@Component(service={IConfigurationProvider.class}, scope=ServiceScope.SINGLETON)
public class ConfigurationProvider
implements IConfigurationProvider,
IResourceChangeListener,
IResourceDeltaVisitor {
    public static final Configuration defaultConf = CfcFactory.eINSTANCE.createConfiguration();
    private Configuration configuration = defaultConf;
    private Map<String, Configuration> confs = Collections.synchronizedMap(new HashMap());
    ResourceSet rs;
    boolean hasChanged = false;
    private Runnable cfcChangedHandler;
    @Reference
    private IEvaluationConfigurationService evaluationConfig;
    @Reference
    private IWorkspace workspace;
    private ICacheService cacheService;

    static {
        defaultConf.setCode(new QName("Default"));
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void bind(final ICacheService cacheService) {
        this.cacheService = cacheService;
        Job j = new Job(Messages.ListCfc_4){

            protected IStatus run(IProgressMonitor monitor) {
                while (!cacheService.isInit()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ConfigurationProvider.this.loadAllConf((IResource)ResourcesPlugin.getWorkspace().getRoot(), monitor);
                ConfigurationProvider.this.notifyCfcFileChanged();
                return Status.OK_STATUS;
            }
        };
        j.setSystem(true);
        j.schedule();
    }

    public void unbind(ICacheService cacheService) {
        this.cacheService = null;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        this.hasChanged = false;
        try {
            delta.accept((IResourceDeltaVisitor)this);
            if (this.hasChanged) {
                this.synch();
                if (this.rs.getResources().size() > 0) {
                    this.notifyCfcFileChanged();
                }
            }
        }
        catch (CoreException exception) {
            exception.printStackTrace();
        }
    }

    private void notifyCfcFileChanged() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        ConfigurationProvider.this.cfcChangedHandler.run();
                    }
                });
            }
        });
    }

    public void setConfigurationHandler(Runnable handler) {
        this.cfcChangedHandler = handler;
    }

    public boolean visit(IResourceDelta delta) {
        IPath path;
        IPath iPath = path = delta.getMovedToPath() != null ? delta.getMovedToPath() : delta.getFullPath();
        if (delta.getResource().getType() == 1) {
            if ((delta.getKind() == 2 || delta.getKind() == 4) && delta.getFlags() != 131072) {
                if (path != null && path.getFileExtension() != null && path.getFileExtension().equals("cfc")) {
                    if (delta.getKind() == 4) {
                        this.rs.getResource(URI.createURI((String)path.toString()), true);
                    } else {
                        Resource r = this.rs.getResource(URI.createURI((String)path.toString()), false);
                        if (r != null) {
                            r.unload();
                        }
                    }
                    this.hasChanged = true;
                }
            } else if (delta.getKind() == 1 && delta.getFlags() != 131072 && path != null && "cfc".equals(path.getFileExtension()) && "global".equals(path.segment(0))) {
                Resource r = this.rs.getResource(URI.createURI((String)path.toString()), false);
                if (r != null) {
                    r.unload();
                }
                r = this.rs.getResource(URI.createURI((String)path.toString()), true);
                this.hasChanged = true;
            }
        }
        return true;
    }

    private void detectAllResouce(IResource r, IProgressMonitor monitor) {
        monitor.subTask(r.getFullPath().toString());
        if (r.getFileExtension() != null && r.getFileExtension().equals("cfc")) {
            URI uri = URI.createPlatformResourceURI((String)r.getFullPath().toString(), (boolean)true);
            this.rs.getResource(uri, true);
        }
        if (r instanceof IContainer && (!(r instanceof IProject) || ((IProject)r).isOpen())) {
            try {
                IResource[] iResourceArray = ((IContainer)r).members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource re = iResourceArray[n2];
                    this.detectAllResouce(re, monitor);
                    ++n2;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synch() {
        Map<String, Configuration> map = this.confs;
        synchronized (map) {
            this.confs.clear();
            if (this.rs.getResources().size() > 0) {
                for (Resource resource : this.rs.getResources()) {
                    if (resource.isLoaded()) {
                        resource.unload();
                    }
                    try {
                        resource = this.rs.getResource(resource.getURI(), true);
                        Cfc cfc = (Cfc)EMFResourceUtil.getFirstElement((Resource)resource);
                        for (Configuration conf : cfc.getConfiguration()) {
                            Configuration other = this.confs.get(conf.getCode().toString());
                            if (other != null) {
                                this.merge(other, conf);
                                continue;
                            }
                            this.confs.put(conf.getCode().toString(), this.copyConf(conf));
                        }
                    }
                    catch (Exception e) {
                        StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.ui.conf.custom", String.valueOf(Messages.ListCfc_0) + resource.getURI(), (Throwable)e), 1);
                    }
                }
            }
        }
    }

    private Configuration copyConf(Configuration conf1) {
        Configuration copy = CfcFactory.eINSTANCE.createConfiguration();
        copy.setCode(conf1.getCode());
        copy.setDescription(conf1.getDescription());
        copy.setExecutionProtection(conf1.isExecutionProtection());
        copy.setSelectionProtection(conf1.isSelectionProtection());
        copy.setPassword(conf1.getPassword());
        return copy;
    }

    private void merge(Configuration conf1, Configuration conf2) {
        if (conf2.isExecutionProtection()) {
            conf1.setExecutionProtection(true);
        }
        if (conf2.isSelectionProtection()) {
            conf1.setSelectionProtection(true);
        }
        if (conf1.getDescription() == null) {
            conf1.setDescription(conf2.getDescription());
        }
        if (conf1.getPassword() == null) {
            conf1.setPassword(conf2.getPassword());
        }
    }

    private void loadAllConf(IResource r, IProgressMonitor monitor) {
        monitor.beginTask(Messages.ListCfc_6, -1);
        this.detectAllResouce(r, monitor);
        this.synch();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String conf) {
        Configuration cnf;
        this.configuration = cnf = this.getConfiguration(conf);
        this.evaluationConfig.setCurrentConfigurationName(this.configuration.getCode().toString(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getAllConfiguration() {
        ArrayList<String> res = null;
        Map<String, Configuration> map = this.confs;
        synchronized (map) {
            res = new ArrayList<String>(this.confs.keySet());
        }
        res.sort((o1, o2) -> o1.toLowerCase().compareTo(o2.toLowerCase()));
        res.add(0, defaultConf.getCode().toString());
        return res;
    }

    public void activate() {
        this.rs = new ResourceSetImpl();
        this.rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new CfcResourceFactoryImpl());
        this.rs.getPackageRegistry().put((Object)"http://www.stambia.com/cfc", (Object)CfcPackage.eINSTANCE);
        this.workspace.addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void deactivate() {
        this.workspace.removeResourceChangeListener((IResourceChangeListener)this);
    }

    public Configuration getConfiguration(String configurationName) {
        Configuration res;
        Configuration configuration = res = configurationName == null ? defaultConf : this.confs.get(configurationName);
        if (res == null) {
            res = defaultConf;
        }
        return res;
    }
}

