/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.conf.custom.tool;

import com.indy.ui.conf.custom.Activator;
import com.indy.ui.conf.custom.Messages;
import com.indy.ui.conf.custom.preference.ConfPreferenceConstants;
import com.indy.ui.conf.custom.tool.PropertyEvaluation;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.emf.SharingReadOnlyEditingDomainFactory;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.cache.CacheEventResource;
import com.semarchy.xdi.designer.core.services.cache.CacheEventURI;
import com.semarchy.xdi.designer.core.services.cache.ICacheListener;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.tpc.Case;
import com.stambia.tpc.Conf;
import com.stambia.tpc.ILevel;
import com.stambia.tpc.Template;
import com.stambia.tpc.util.custom.StbTpcResourceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.osgi.framework.ServiceRegistration;

public class ConfUtil {
    static final ConfTracker tracker = new ConfTracker();

    public static List<EObject> getTemplate(String str, EObject base) {
        ProjectInfo projectInfo = ConfUtil.tracker.getProjectInfo(base, str);
        if (str != null) {
            Map<String, String> _map;
            if (str != null) {
                _map = projectInfo.map.get(str);
                if (_map == null || _map.isEmpty()) {
                    _map = new HashMap<String, String>();
                    String[] stringArray = str.split(";");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String prop = stringArray[n2];
                        String[] part = prop.split("=");
                        if (part.length == 2) {
                            _map.put(part[0].toUpperCase(), part[1].toUpperCase());
                        }
                        ++n2;
                    }
                }
            } else {
                _map = Collections.EMPTY_MAP;
            }
            projectInfo.map.put(str, _map);
        }
        if (str != null && str.equals(projectInfo.lastCriteria) && projectInfo.templates != null && !projectInfo.templates.isEmpty()) {
            return projectInfo.templates;
        }
        projectInfo.templates = ConfUtil.getTemplate(projectInfo.map.get(str), projectInfo.confs, base);
        projectInfo.lastCriteria = str;
        return projectInfo.templates;
    }

    private static boolean eval(Case _case, Map<String, String> map, List<Template> list, EObject context) {
        PropertyEvaluation pe = new PropertyEvaluation((ILevel)_case, map, context);
        boolean eval = pe.eval();
        if (eval) {
            list.addAll((Collection<Template>)_case.getTemplate());
            for (Case cas : _case.getCase()) {
                ConfUtil.eval(cas, map, list, context);
            }
        }
        return eval;
    }

    private static List<EObject> getTemplate(Map<String, String> map, List<Conf> confs, EObject eobject) {
        ArrayList<EObject> list2 = new ArrayList<EObject>();
        if (map != null && !map.isEmpty() || eobject != null) {
            ArrayList cases = new ArrayList();
            for (Conf _conf : confs) {
                cases.addAll(_conf.getCase());
            }
            ArrayList<Template> list = new ArrayList<Template>();
            for (Case cas : cases) {
                ConfUtil.eval(cas, map, list, eobject);
            }
            Collections.sort(list, new Comparator<Template>(){

                @Override
                public int compare(Template arg0, Template arg1) {
                    if (arg0.getProof() < arg1.getProof()) {
                        return 1;
                    }
                    if (arg0.getProof() > arg1.getProof()) {
                        return -1;
                    }
                    return 0;
                }
            });
            for (Template tpl : list) {
                if (list2.contains(tpl.getRef())) continue;
                if (tpl.getRef() == null) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.ui.conf.custom", Messages.bind((String)Messages.ConfUtil_4, (Object)tpl.getId(), (Object)tpl.eResource().getURI().toPlatformString(true)), (Throwable)new NullPointerException(Messages.ConfUtil_7)));
                    continue;
                }
                list2.add(tpl.getRef());
            }
        }
        return list2;
    }

    public static Collection<URI> getTemplates() {
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.setURIConverter((URIConverter)new InternalResourceURIConverter());
        ArrayList<IFile> list2 = new ArrayList<IFile>();
        ArrayList<URI> internalResourceURI = new ArrayList<URI>();
        for (URI uri : ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURI("(.)*.tpc")) {
            if (uri.isPlatformResource()) {
                list2.add(Util.convertEMFURIToFile((URI)uri));
                continue;
            }
            internalResourceURI.add(uri);
        }
        ArrayList<IProject> prjsList = new ArrayList<IProject>();
        IProject globalProject = ResourcesPlugin.getWorkspace().getRoot().getProject("global");
        if (globalProject != null && !prjsList.contains(globalProject)) {
            prjsList.add(globalProject);
        }
        for (IResource iResource : list2) {
            if (!iResource.getProject().exists() || !iResource.getProject().isOpen() || prjsList.contains(iResource.getProject())) continue;
            prjsList.add(iResource.getProject());
        }
        ArrayList<Conf> arrayList = new ArrayList<Conf>();
        for (IProject project : prjsList) {
            for (IResource iResource : list2) {
                Object fileConf;
                if (project != iResource.getProject() || (fileConf = (IFile)iResource) == null) continue;
                URI uri = Util.convertIFileToEMFURI((IFile)fileConf);
                Conf conf2 = StbTpcResourceImpl.getConf((URI)uri, (ResourceSet)rs);
                arrayList.add(conf2);
            }
        }
        for (URI u : internalResourceURI) {
            Conf conf = StbTpcResourceImpl.getConf((URI)u, (ResourceSet)rs);
            arrayList.add(conf);
        }
        ArrayList<? extends Case> cases = new ArrayList<Case>();
        for (Conf c : arrayList) {
            for (Case ca : c.getCase()) {
                cases.addAll(ConfUtil.getCases(ca));
            }
        }
        HashSet<URI> templates = new HashSet<URI>();
        for (Case case_ : cases) {
            for (Template t : case_.getTemplate()) {
                if (t.getRef() == null || t.getRef().eIsProxy()) continue;
                templates.add(EcoreUtil.getURI((EObject)t.getRef()));
            }
        }
        return templates;
    }

    private static Collection<? extends Case> getCases(Case case1) {
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(case1);
        for (Case c : case1.getCase()) {
            l.addAll(ConfUtil.getCases(c));
        }
        return l;
    }

    public static URI getEgcURI() {
        String str = ConfPreferenceConstants.getString("egcFile");
        return URI.createURI((String)str);
    }

    public static URI getCfcURI() {
        String str = ConfPreferenceConstants.getString("cfcFile");
        return URI.createURI((String)str);
    }

    public static URI getPlatformCfcURI() {
        String str = ConfPreferenceConstants.getString("cfcFile");
        return URI.createPlatformResourceURI((String)str, (boolean)false);
    }

    public static URI getPlatformEgcURI() {
        String str = ConfPreferenceConstants.getString("egcFile");
        return URI.createPlatformResourceURI((String)str, (boolean)false);
    }

    static class ConfTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor,
    ICacheListener {
        Map<IProject, ProjectInfo> confs = new HashMap<IProject, ProjectInfo>();
        Map<IProject, Set<IProject>> dependencies = new HashMap<IProject, Set<IProject>>();
        boolean inited = false;
        ServiceRegistration<ICacheListener> sr = null;

        ConfTracker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean setConfs(EObject context) {
            ResourceSet rs;
            ResourceSet resourceSet = rs = context.eResource() != null ? context.eResource().getResourceSet() : null;
            if (rs != null) {
                IFile file = Util.convertEMFURIToFile((URI)context.eResource().getURI());
                ProjectInfo info = this.confs.get(file.getProject());
                ICacheService cacheService = (ICacheService)E4InjectorHelper.getService(ICacheService.class);
                if (info == null || info.lastTimeStamp == -1L || info.lastTimeStamp < cacheService.getTimeStamp()) {
                    ResourceSet toSync;
                    IProject globalProject;
                    if (info == null) {
                        info = new ProjectInfo();
                        this.confs.put(file.getProject(), info);
                        try {
                            this.dependencies.put(file.getProject(), new HashSet<IProject>(Arrays.asList(file.getProject().getReferencedProjects())));
                        }
                        catch (Exception e) {
                            this.dependencies.put(file.getProject(), new HashSet());
                        }
                    }
                    List list2 = cacheService.findResourceURI("(.)*.tpc");
                    HashSet<IProject> prjsList = new HashSet<IProject>();
                    if (file != null) {
                        this.getAllProjects(file.getProject(), prjsList);
                    }
                    if ((globalProject = ResourcesPlugin.getWorkspace().getRoot().getProject("global")).exists() && globalProject.isOpen()) {
                        prjsList.add(globalProject);
                    }
                    info.confs.clear();
                    EditingDomain d = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)context);
                    ResourceSet resourceSet2 = toSync = d instanceof SharingReadOnlyEditingDomainFactory.CustomTransactionalEditingDomain ? SharingReadOnlyEditingDomainFactory.getSharedResourceSet() : rs;
                    synchronized (resourceSet2) {
                        for (IProject project : prjsList) {
                            for (URI uri : list2) {
                                if (!uri.isPlatformResource() || !project.getName().equals(URI.decode((String)uri.segment(1)))) continue;
                                Conf conf2 = StbTpcResourceImpl.getConf((URI)uri, (ResourceSet)rs);
                                info.confs.add(conf2);
                            }
                        }
                        for (URI uri : list2) {
                            if (!uri.isPlatformPlugin()) continue;
                            Conf conf2 = StbTpcResourceImpl.getConf((URI)uri, (ResourceSet)rs);
                            info.confs.add(conf2);
                        }
                    }
                    info.lastTimeStamp = cacheService.getTimeStamp();
                    return true;
                }
            }
            return false;
        }

        private void getAllProjects(IProject project, Set<IProject> prjsList) {
            if (prjsList.add(project)) {
                try {
                    IProject[] iProjectArray = project.getReferencedProjects();
                    int n = iProjectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject p = iProjectArray[n2];
                        if (p.exists() && p.isOpen()) {
                            this.getAllProjects(p, prjsList);
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }

        private ProjectInfo getProjectInfo(EObject base, String str) {
            if (!this.inited) {
                this.init();
            }
            IFile file = Util.convertEMFURIToFile((URI)base.eResource().getURI());
            ProjectInfo projectInfo = this.confs.get(file.getProject());
            boolean hasDiff = false;
            if (projectInfo == null || (hasDiff |= this.setConfs(base))) {
                if (projectInfo == null) {
                    hasDiff |= this.setConfs(base);
                    projectInfo = this.confs.get(file.getProject());
                }
                if (hasDiff) {
                    projectInfo.map.clear();
                }
                projectInfo = this.confs.get(file.getProject());
            }
            return projectInfo;
        }

        private void init() {
            if (this.sr != null) {
                this.sr.unregister();
                this.sr = null;
            }
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
            this.sr = Activator.getDefault().getBundle().getBundleContext().registerService(ICacheListener.class, (Object)this, null);
            this.inited = true;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                event.getDelta().accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }

        private void remove(IProject p, ProjectInfo i) {
            HashSet<IProject> allImpacted = new HashSet<IProject>();
            this.getAllDependancies(p, allImpacted);
            this.confs.remove(p);
            for (IProject d : allImpacted) {
                this.confs.remove(d);
            }
        }

        private void getAllDependancies(IProject p, Set<IProject> res) {
            for (IProject k : this.dependencies.keySet()) {
                Collection c = this.dependencies.get(k);
                if (c == null || !c.contains(p) || !res.add(k)) continue;
                this.getAllDependancies(k, res);
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            block12: {
                if (delta.getResource().getType() == 8) {
                    return true;
                }
                if (delta.getResource().getType() == 4) {
                    IProject project = delta.getResource().getProject();
                    ProjectInfo inf = this.confs.get(project);
                    if (delta.getKind() == 2) {
                        this.remove(project, inf);
                    } else if (delta.getKind() == 4) {
                        if ((delta.getFlags() & 0x4000) != 0) {
                            if (!project.isOpen()) {
                                this.remove(project, inf);
                            }
                        } else if ((delta.getFlags() & 0x80000) != 0) {
                            HashSet<IProject> newReferences = new HashSet<IProject>(Arrays.asList(project.getReferencedProjects()));
                            Collection curReferences = this.dependencies.get(project);
                            try {
                                if (curReferences == null && !newReferences.isEmpty() || curReferences != null && (!newReferences.containsAll(curReferences) || !curReferences.containsAll(newReferences))) {
                                    this.remove(project, inf);
                                    this.dependencies.put(project, newReferences);
                                }
                            }
                            catch (Exception ex) {
                                if (curReferences == null || newReferences == null) break block12;
                                ex.printStackTrace();
                            }
                        }
                    }
                }
            }
            return false;
        }

        public void resourceBuildStateChanged(CacheEventResource event) {
        }

        public void resourceErrorStateChanged(CacheEventResource event) {
            URI uri;
            if (event.getEventType() == CacheEventResource.EventType.ERROR && (uri = event.getResourceInfo()) != null && "tpc".equals(uri.fileExtension())) {
                this.handleTpcChangedInProject(ResourcesPlugin.getWorkspace().getRoot().getProject(URI.decode((String)uri.segment(1))));
            }
        }

        public boolean handleEvent(CacheEventResource event) {
            URI uri;
            return event.getEventType() == CacheEventResource.EventType.ERROR && (uri = event.getResourceInfo()) != null && "tpc".equals(uri.fileExtension());
        }

        public boolean handleEvent(CacheEventURI event) {
            return event.getModelURI() != null && event.getModelURI().isPlatformResource() && "tpc".equals(event.getModelURI().fileExtension());
        }

        private void handleTpcChangedInProject(IProject project) {
            try {
                this.confs.remove(project);
                if ("global".equals(project.getName())) {
                    this.confs.clear();
                } else {
                    ArrayList<IProject> toRemove = new ArrayList<IProject>();
                    for (IProject p : this.confs.keySet()) {
                        HashSet<IProject> dep = new HashSet<IProject>();
                        this.getAllDependancies(p, dep);
                        if (!dep.contains(project)) continue;
                        toRemove.add(p);
                    }
                    this.confs.keySet().removeAll(toRemove);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.confs.clear();
            }
        }

        public void handleEventsTriggered() {
        }

        public void handleCacheSourceChanged(CacheEventURI event) {
            IFile f = Util.convertEMFURIToFile((URI)event.getModelURI());
            if (f != null) {
                this.handleTpcChangedInProject(f.getProject());
            }
        }
    }

    static class ProjectInfo {
        List<Conf> confs = new ArrayList<Conf>();
        long lastTimeStamp = -1L;
        String lastCriteria = null;
        Map<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        List<EObject> templates = null;

        ProjectInfo() {
        }
    }
}

