/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.conf.custom.tool;

import com.stambia.md.MdNode;
import com.stambia.tpc.And;
import com.stambia.tpc.Case;
import com.stambia.tpc.ILevel;
import com.stambia.tpc.Not;
import com.stambia.tpc.Or;
import com.stambia.tpc.PropertyState;
import com.stambia.tpc.TestMode;
import com.stambia.tpc.XpathEvaluation;
import java.util.Iterator;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.emf.ecore.EObject;

public class PropertyEvaluation {
    private static final int NOT_TYPE = 1;
    private static final int OR_TYPE = 2;
    private static final int AND_TYPE = 3;
    private static final int PROP_EVAL_TYPE = 5;
    private static final int XPATH_EVAL_TYPE = 6;
    boolean enabled;
    int type;
    Map<String, String> map;
    private ILevel level;
    private EObject context;

    public PropertyEvaluation(ILevel level, Map<String, String> map, EObject context) {
        this.level = level;
        this.map = map;
        this.context = context;
        this.setType();
    }

    private void setType() {
        if (this.level instanceof Not) {
            this.type = 1;
        } else if (this.level instanceof And || this.level instanceof Case) {
            this.type = 3;
        } else if (this.level instanceof Or) {
            this.type = 2;
        } else if (this.level instanceof PropertyState) {
            this.type = 5;
        } else if (this.level instanceof XpathEvaluation) {
            this.type = 6;
        }
    }

    public boolean eval() {
        boolean retour = false;
        block1 : switch (this.type) {
            case 1: {
                Iterator it = this.level.getChildren();
                while (it.hasNext()) {
                    ILevel child = (ILevel)it.next();
                    PropertyEvaluation _child = new PropertyEvaluation(child, this.map, this.context);
                    if (_child.eval()) continue;
                    retour = true;
                }
                break;
            }
            case 2: {
                Iterator it = this.level.getChildren();
                while (it.hasNext()) {
                    ILevel child = (ILevel)it.next();
                    PropertyEvaluation _child = new PropertyEvaluation(child, this.map, this.context);
                    if (!_child.eval()) continue;
                    retour = true;
                    break block1;
                }
                break;
            }
            case 3: {
                boolean tmp = false;
                Iterator it = this.level.getChildren();
                while (it.hasNext()) {
                    ILevel child = (ILevel)it.next();
                    PropertyEvaluation _child = new PropertyEvaluation(child, this.map, this.context);
                    if (_child.eval()) continue;
                    tmp = true;
                    break;
                }
                retour = !tmp;
                break;
            }
            case 5: {
                if (this.map != null && !this.map.isEmpty()) {
                    PropertyState ps = (PropertyState)this.level;
                    String name = ps.getName().toUpperCase();
                    String value = ps.getValue().toUpperCase();
                    if (ps.getMode() == null || ps.getMode().equals((Object)TestMode.EQUALS)) {
                        retour = this.map.get(name) != null && value != null && !value.equals("") && !this.map.get(name).equals("") ? this.map.get(name).equals(value) : false;
                        break;
                    }
                    if (ps.getMode().equals((Object)TestMode.CONTAINS)) {
                        if (name != null && name.endsWith("LIST")) {
                            retour = false;
                            String s = this.map.get(name);
                            if (s == null) break;
                            String[] stringArray = s.split("\\|");
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String v = stringArray[n2];
                                if (v.equals(value)) {
                                    retour = true;
                                    break block1;
                                }
                                ++n2;
                            }
                            break;
                        }
                        retour = this.map.get(name) != null && value != null && !value.equals("") && !this.map.get(name).equals("") ? this.map.get(name).contains(value) : false;
                        break;
                    }
                    if (!ps.getMode().equals((Object)TestMode.EXISTS)) break;
                    retour = this.map.containsKey(name);
                    break;
                }
                retour = false;
                break;
            }
            case 6: {
                if (this.context instanceof MdNode) {
                    XpathEvaluation xe = (XpathEvaluation)this.level;
                    String name = xe.getName().toUpperCase();
                    String expression = xe.getXpathExpression();
                    retour = false;
                    try {
                        retour = ((MdNode)this.context).evaluateMdBoolean(expression);
                    }
                    catch (XPathExpressionException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                retour = false;
            }
        }
        return retour;
    }
}

