/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.runtime.editor;

import com.indy.ui.common.editor.input.RuntimeEditorInput;
import com.indy.ui.common.resource.IResource;
import com.indy.ui.common.resource.IResourceChanged;
import com.indy.ui.common.resource.IResourceListener;
import com.indy.ui.runtime.editor.page.CommandPage;
import com.indy.ui.runtime.editor.page.MonitoringEditorPage;
import com.indy.ui.runtime.editor.page.PurgePage;
import com.indy.ui.runtime.editor.page.VirtualMachineEditorPage;
import com.stambia.app.authorization.Action;
import com.stambia.app.authorization.AuthManager;
import com.stambia.ui.resource.ResourcePluginStambia;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public class RuntimeEditor
extends FormEditor {
    IResourceListener resourceListener = new IResourceListener(){

        public void resourceRemoved(IResource resource) {
            String runtimeId;
            if (resource instanceof IResource && RuntimeEditor.this.getEditorInput() instanceof RuntimeEditorInput && (runtimeId = ((RuntimeEditorInput)RuntimeEditor.this.getEditorInput()).getRuntimeId()).equals(resource.getResourceId())) {
                RuntimeEditor.this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        RuntimeEditor.this.getSite().getPage().closeEditor((IEditorPart)RuntimeEditor.this, false);
                    }
                });
            }
        }

        public void resourceChanged(IResourceChanged resourceChanged) {
        }

        public void resourceAdded(IResource resource) {
        }

        public void resourceMoved(IResource resource) {
        }
    };

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        ResourcePluginStambia.getDefault().getResourceListenerManager().addResourceListener(this.resourceListener);
    }

    public void dispose() {
        super.dispose();
        ResourcePluginStambia.getDefault().getResourceListenerManager().removeResourceListener(this.resourceListener);
    }

    protected void createPages() {
        try {
            RuntimeEditorInput editorInput = null;
            if (this.getEditorInput() instanceof RuntimeEditorInput) {
                this.setPartName(this.getEditorInput().getName());
                editorInput = (RuntimeEditorInput)this.getEditorInput();
            }
            int index = 0;
            if (AuthManager.isAuthorized((Action)Action.RUNTIME_SESSION_THREAD_ACCESS) || AuthManager.isAuthorized((Action)Action.RUNTIME_HOST_ACCESS)) {
                MonitoringEditorPage monitoringEditorPage = new MonitoringEditorPage(this, editorInput);
                index = this.addPage((IFormPage)monitoringEditorPage);
                this.setPageText(index, "Monitoring");
            }
            VirtualMachineEditorPage virtualMachineEditorPage = new VirtualMachineEditorPage(this, editorInput);
            index = this.addPage((IFormPage)virtualMachineEditorPage);
            this.setPageText(index, "Virtual Machine");
            if (AuthManager.isAuthorized((Action)Action.RUNTIME_PURGE_SCHEDULE_ACCESS)) {
                PurgePage purgePage = new PurgePage(this, editorInput);
                index = this.addPage((IFormPage)purgePage);
                this.setPageText(index, "Purge");
            }
            if (AuthManager.isAuthorized((Action)Action.RUNTIME_COMMAND_EXECUTE)) {
                CommandPage commandPage = new CommandPage(this, editorInput);
                index = this.addPage((IFormPage)commandPage);
                this.setPageText(index, "Command");
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    protected void addPages() {
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }
}

