/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.runtime.editor.page;

import com.indy.engine.core.common.FunctionType;
import com.indy.engine.core.common.ParameterType;
import com.indy.engine.log.engine.AnalyticsEngineWrapper;
import com.indy.ui.common.editor.input.RuntimeEditorInput;
import com.indy.ui.runtime.editor.RuntimeEditorBundle;
import com.stambia.app.authorization.AuthManager;
import com.stambia.ui.tools.Utils;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class MonitoringEditorPage
extends FormPage {
    private FormToolkit toolkit;
    private ScrolledForm form;
    private TableViewer hostTableViewer;
    private TreeViewer threadTreeViewer;
    private Table hostTable;
    private Tree threadTree;
    private RuntimeEditorInput editorInput;

    public MonitoringEditorPage(FormEditor editor, RuntimeEditorInput editorInput) {
        super(editor, UUID.randomUUID().toString(), "");
        this.editorInput = editorInput;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.form = this.getManagedForm().getForm();
        this.toolkit = this.getManagedForm().getToolkit();
        GridLayout layout = new GridLayout();
        this.form.getBody().setLayout((Layout)layout);
        this.createHeaderSection();
        this.createBodySection(this.form.getBody());
    }

    private void createHeaderSection() {
        this.form.setText("Monitoring");
        this.toolkit.decorateFormHeading(this.form.getForm());
        Action refresh = new Action("Refresh", ExtendedImageRegistry.INSTANCE.getImageDescriptor((Object)RuntimeEditorBundle.getDefault().getImage("refresh16x16.gif"))){

            public void run() {
                MonitoringEditorPage.this.refreshViewerInput();
            }
        };
        this.form.getToolBarManager().add((IAction)refresh);
        this.form.getToolBarManager().update(true);
        this.form.getForm().getHead().setBackground(null);
    }

    private void refreshViewerInput() {
        this.refreshHostTableInput();
        this.refreshThreadTreeInput();
    }

    private void createBodySection(Composite parent) {
        GridData gridData;
        Composite comp = this.toolkit.createComposite(parent);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        SashForm sash = new SashForm(comp, 576);
        GridData gd = new GridData(4, 4, true, true);
        sash.setLayoutData((Object)gd);
        if (AuthManager.isAuthorized((com.stambia.app.authorization.Action)com.stambia.app.authorization.Action.RUNTIME_HOST_ACCESS)) {
            Section connectionSection = Utils.createSection((FormToolkit)this.toolkit, (Composite)sash, (String)"Connection");
            Composite hostTableComp = this.toolkit.createComposite((Composite)connectionSection);
            gridData = new GridData(4, 4, true, false);
            hostTableComp.setLayout((Layout)new GridLayout());
            hostTableComp.setLayoutData((Object)gridData);
            this.hostTableViewer = new TableViewer(hostTableComp, 68096);
            this.createHostTableColumns((Composite)sash, this.hostTableViewer);
            this.hostTable = this.hostTableViewer.getTable();
            this.hostTable.setLayoutData((Object)new GridData(4, 4, true, true));
            this.hostTable.setHeaderVisible(true);
            this.hostTable.setLinesVisible(true);
            this.hostTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            connectionSection.setClient((Control)hostTableComp);
        }
        if (AuthManager.isAuthorized((com.stambia.app.authorization.Action)com.stambia.app.authorization.Action.RUNTIME_SESSION_THREAD_ACCESS)) {
            Section threadSection = Utils.createSection((FormToolkit)this.toolkit, (Composite)sash, (String)"Threads");
            Composite threadTableComp = this.toolkit.createComposite((Composite)threadSection);
            gridData = new GridData(4, 4, true, false);
            threadTableComp.setLayout((Layout)new GridLayout());
            threadTableComp.setLayoutData((Object)gridData);
            this.threadTreeViewer = new TreeViewer(threadTableComp, 68096);
            this.createThreadTreeColumns((Composite)sash, this.threadTreeViewer);
            this.threadTree = this.threadTreeViewer.getTree();
            this.threadTree.setLayoutData((Object)new GridData(4, 4, true, true));
            this.threadTree.setHeaderVisible(true);
            this.threadTree.setLinesVisible(true);
            this.threadTreeViewer.setContentProvider((IContentProvider)new SessionThreadContentProvider());
            threadSection.setClient((Control)threadTableComp);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                final TreeItem treeItem = (TreeItem)e.item;
                MonitoringEditorPage.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TreeColumn[] treeColumnArray = treeItem.getParent().getColumns();
                        int n = treeColumnArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeColumn tc = treeColumnArray[n2];
                            tc.pack();
                            ++n2;
                        }
                    }
                });
            }
        };
        if (this.hostTable != null) {
            this.hostTable.addListener(18, listener);
        }
        if (this.threadTree != null) {
            this.threadTree.addListener(17, listener);
        }
        this.refreshViewerInput();
    }

    private void refreshThreadTreeInput() {
        try {
            AnalyticsEngineWrapper engine = this.editorInput.getEngine();
            if (engine != null) {
                HashMap<String, Object> mapQuestion = new HashMap<String, Object>();
                mapQuestion.put(FunctionType.getAllThreads.name(), null);
                Map mapAnswer = engine.get(mapQuestion);
                List listThread = (List)mapAnswer.get(FunctionType.getAllThreads.name());
                ArrayList<SessionThreadsData> sessThread = new ArrayList<SessionThreadsData>();
                for (String thread : listThread) {
                    String[] tabInfo = thread.split("\\|");
                    SessionThreadsData threadData = null;
                    if (tabInfo.length == 5) {
                        threadData = new SessionThreadsData(tabInfo[1], tabInfo[3], tabInfo[2], null, null, tabInfo[4]);
                    } else if (tabInfo.length == 7) {
                        threadData = new SessionThreadsData(tabInfo[1], tabInfo[3], tabInfo[2], tabInfo[4], tabInfo[5], tabInfo[6]);
                    }
                    if (threadData == null) continue;
                    sessThread.add(threadData);
                }
                this.threadTreeViewer.setInput(sessThread);
                this.threadTreeViewer.expandAll();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void refreshHostTableInput() {
        try {
            AnalyticsEngineWrapper engine = this.editorInput.getEngine();
            if (engine != null) {
                ArrayList<HostData> hosts = new ArrayList<HostData>();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(FunctionType.getConnectedClient.name(), null);
                Map mapClient = engine.get(map);
                Map mapAPIReturn = (Map)mapClient.get(FunctionType.getConnectedClient.name());
                HashMap<String, Object> mapIP = new HashMap<String, Object>();
                for (String ip : mapAPIReturn.keySet()) {
                    mapIP.put(ip, null);
                }
                HashMap<String, HashMap<String, Object>> mapIPAsk = new HashMap<String, HashMap<String, Object>>();
                mapIPAsk.put(FunctionType.getInetAddress.name(), mapIP);
                Map mapIPAnswer = engine.get(mapIPAsk);
                Map mapAddress = (Map)mapIPAnswer.get(FunctionType.getInetAddress.name());
                for (Map.Entry entry : mapAPIReturn.entrySet()) {
                    Date oneHourAgo;
                    String ip = (String)entry.getKey();
                    InetAddress addr = (InetAddress)mapAddress.get(ip);
                    Map mapVal = (Map)entry.getValue();
                    long lastAccess = (Long)mapVal.get(ParameterType.lastAccessTime.name());
                    Date date = new Date(lastAccess);
                    if (!date.after(oneHourAgo = new Date(System.currentTimeMillis() - 3600000L))) continue;
                    SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss", Locale.getDefault());
                    String format = sdf.format(date);
                    hosts.add(new HostData(ip, addr.getHostName(), format));
                }
                this.hostTableViewer.setInput(hosts);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createHostTableColumns(Composite comp, TableViewer viewer) {
        String[] titles = new String[]{"Adresse IP", "Name", "Last access"};
        int[] bounds = new int[]{150, 150, 85};
        TableViewerColumn colIp = this.createTableViewerColumn(titles[0], bounds[0]);
        colIp.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                HostData elt = (HostData)element;
                return elt.getIp();
            }
        });
        TableViewerColumn colName = this.createTableViewerColumn(titles[1], bounds[1]);
        colName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                HostData elt = (HostData)element;
                return elt.getName();
            }
        });
        TableViewerColumn colLastAccess = this.createTableViewerColumn(titles[2], bounds[2]);
        colLastAccess.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                HostData elt = (HostData)element;
                return elt.getLastAcces();
            }
        });
    }

    private void createThreadTreeColumns(Composite comp, TreeViewer viewer) {
        String[] titles = new String[]{"Name", "Session Id", "Iteration", "Technology", "Consumed CPU Time"};
        int[] bounds = new int[]{200, 260, 65, 200, 140};
        TreeViewerColumn colName = this.createTreeViewerColumn(titles[0], bounds[0]);
        colName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Level elt = (Level)element;
                return elt.getName();
            }

            public Image getImage(Object element) {
                Level level = (Level)element;
                return null;
            }
        });
        TreeViewerColumn colId = this.createTreeViewerColumn(titles[1], bounds[1]);
        colId.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Level elt;
                if (element instanceof SessionThreadsData && (elt = (Level)element).isRoot()) {
                    return elt.getSessionId();
                }
                return null;
            }
        });
        TreeViewerColumn colIter = this.createTreeViewerColumn(titles[2], bounds[2]);
        colIter.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof SessionThreadsData) {
                    SessionThreadsData elt = (SessionThreadsData)element;
                    return elt.getIteration();
                }
                return null;
            }
        });
        TreeViewerColumn colTech = this.createTreeViewerColumn(titles[3], bounds[3]);
        colTech.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof SessionThreadsData) {
                    SessionThreadsData elt = (SessionThreadsData)element;
                    return elt.getShortTechnology();
                }
                return null;
            }
        });
        TreeViewerColumn colCpu = this.createTreeViewerColumn(titles[4], bounds[4]);
        colCpu.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof SessionThreadsData) {
                    SessionThreadsData elt = (SessionThreadsData)element;
                    return elt.getConsumedCpuTime();
                }
                return null;
            }
        });
    }

    private TreeViewerColumn createTreeViewerColumn(String title, int bound) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this.threadTreeViewer, 0);
        TreeColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(false);
        return viewerColumn;
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.hostTableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(false);
        column.setMoveable(false);
        return viewerColumn;
    }

    class HostData {
        private String ip;
        private String name;
        private String lastAcces;

        public HostData(String ip, String name, String lastAcces) {
            this.ip = ip;
            this.name = name;
            this.lastAcces = lastAcces;
        }

        public String getIp() {
            return this.ip;
        }

        public String getName() {
            return this.name;
        }

        public String getLastAcces() {
            return this.lastAcces;
        }
    }

    class Level {
        private String path;
        private String sessionId;
        private String sessionName;

        public String getSessionName() {
            return this.sessionName;
        }

        public Level(String sessionId, String sessionName, String path) {
            this.path = path != null && path.startsWith(sessionId) ? path.substring(sessionId.length() + 1) : path;
            this.sessionName = sessionName;
            this.sessionId = sessionId;
        }

        public String getPath() {
            if (this.path != null) {
                return String.valueOf(this.sessionId) + "/" + this.path;
            }
            return this.sessionId;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public boolean isRoot() {
            return this.path == null;
        }

        public String getName() {
            if (this.path == null) {
                return this.getSessionName();
            }
            int index = this.path.lastIndexOf("/");
            if (index > -1) {
                return this.path.substring(index + 1);
            }
            return this.path;
        }
    }

    class SessionThreadContentProvider
    implements ITreeContentProvider {
        private SessionThreadList sessThreadList;

        SessionThreadContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null) {
                this.sessThreadList = new SessionThreadList((List)newInput);
            }
        }

        public Object[] getElements(Object inputElement) {
            return this.sessThreadList.getRoots().toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return this.sessThreadList.getChildren(parentElement).toArray();
        }

        public Object getParent(Object element) {
            return this.sessThreadList.getParent(element);
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }

    class SessionThreadList {
        private Map<String, SessionThreadsData> roots = new HashMap<String, SessionThreadsData>();
        private Map<String, Level> all = new HashMap<String, Level>();
        private Map<String, Set<String>> childrens = new HashMap<String, Set<String>>();

        private void addParents(String path, String sessionId, String sessionName) {
            int index = path.lastIndexOf("/");
            Level current = this.all.get(path);
            if (current == null) {
                current = new Level(sessionId, sessionName, path);
                this.all.put(path, current);
            }
            if (index > -1) {
                String _parent = path.substring(0, index);
                Set<String> paths = this.childrens.get(_parent);
                if (paths == null) {
                    paths = new HashSet<String>();
                    this.childrens.put(_parent, paths);
                }
                paths.add(path);
                this.addParents(_parent, sessionId, sessionName);
            } else {
                this.roots.put(path, (SessionThreadsData)current);
            }
        }

        public SessionThreadList(List<SessionThreadsData> threads) {
            for (SessionThreadsData thread : threads) {
                this.all.put(thread.getPath(), thread);
            }
            for (SessionThreadsData thread : threads) {
                this.addParents(thread.getPath(), thread.getSessionId(), thread.getSessionName());
            }
        }

        public Collection<SessionThreadsData> getRoots() {
            return this.roots.values();
        }

        public SessionThreadsData getParent(Object element) {
            return null;
        }

        public List<Level> getChildren(Object element) {
            Set<String> list = this.childrens.get(((Level)element).getPath());
            if (list != null) {
                ArrayList<Level> _list = new ArrayList<Level>();
                for (String key : list) {
                    Level level = this.all.get(key);
                    if (level == null) continue;
                    _list.add(level);
                }
                return _list;
            }
            return Collections.emptyList();
        }
    }

    class SessionThreadsData
    extends Level {
        private String iteration;
        private String technologie;
        private String consumedCpuTime;

        public SessionThreadsData(String sessionId, String sessionName, String iteration, String path, String technologie, String consumedCpuTime) {
            super(sessionId, sessionName, path);
            this.iteration = iteration;
            this.technologie = technologie;
            this.consumedCpuTime = consumedCpuTime;
        }

        public String getIteration() {
            return this.iteration;
        }

        public String getTechnology() {
            return this.technologie;
        }

        public String getConsumedCpuTime() {
            return this.consumedCpuTime;
        }

        public String getShortTechnology() {
            if (this.technologie != null) {
                String[] tech = this.technologie.split("\\.");
                return tech[tech.length - 1];
            }
            return null;
        }
    }
}

