/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.runtime.editor.page;

import com.indy.engine.log.engine.AnalyticsEngineWrapper;
import com.indy.engine.log.engine.EngineRegistry;
import com.indy.quartz.cron.editor.editor.input.PurgeEditorInput;
import com.indy.ui.common.editor.input.RuntimeEditorInput;
import com.indy.ui.runtime.editor.RuntimeEditorBundle;
import com.indy.ui.runtime.editor.page.Messages;
import com.indy.ui.runtime.editor.page.PurgeDetailsPage;
import com.stambia.app.authorization.AuthManager;
import com.stambia.quartz.cron.IntervalUnit;
import com.stambia.quartz.cron.RuntimeStatus;
import com.stambia.quartz.cron.TriggerState;
import com.stambia.quartz.cron.croneditor.PurgeEditor;
import com.stambia.quartz.cron.util.CronUtils;
import com.stambia.ui.tools.IPartListener2Adapter;
import com.stambia.ui.tools.pages.TablePage;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.Form;

public class PurgePage
extends TablePage {
    private String host;
    private int port;
    private List<Purge> purges;
    private IPageChangedListener pageChangedListener;
    private IPartListener2Adapter partListener;
    private String user;
    private String password;
    private RuntimeEditorInput editorInput;
    private String partName;

    public PurgePage(final FormEditor editor, RuntimeEditorInput editorInput) {
        super(editor, Messages.PurgePage_0);
        this.editorInput = editorInput;
        this.host = editorInput.getHost();
        this.port = editorInput.getPort();
        this.user = editorInput.getUser();
        this.password = editorInput.getPassword();
        this.purges = new ArrayList<Purge>();
        this.partName = editor.getPartName();
        this.refreshPurges();
        this.pageChangedListener = new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                if (((FormPage)event.getSelectedPage()).getId().equals(PurgePage.this.getId())) {
                    PurgePage.this.refreshPurges();
                }
            }
        };
        this.partListener = new IPartListener2Adapter(){

            public void partVisible(IWorkbenchPartReference partRef) {
                if (partRef.getPartName().equals(PurgePage.this.partName) && ((FormPage)editor.getSelectedPage()).getId().equals(PurgePage.this.getId())) {
                    PurgePage.this.refreshPurges();
                }
            }
        };
        editor.addPageChangedListener(this.pageChangedListener);
    }

    public void refreshPurges() {
        AnalyticsEngineWrapper engine = this.editorInput.getEngine();
        if (engine != null) {
            try {
                this.purges.clear();
                for (String purgeName : EngineRegistry.getDefault().getAllPurge(this.host, Integer.valueOf(this.port), this.user, this.password)) {
                    Map purgeDetail;
                    if (EngineRegistry.getDefault().isRuntimes17_1_16(this.host, Integer.valueOf(this.port))) {
                        purgeDetail = EngineRegistry.getDefault().getTriggerDetails(this.host, Integer.valueOf(this.port), this.user, this.password, purgeName, "Purge");
                        if (purgeDetail == null) {
                            purgeDetail = EngineRegistry.getDefault().getTriggerDetails(this.host, Integer.valueOf(this.port), this.user, this.password, purgeName, "Cron Expression");
                        }
                    } else {
                        purgeDetail = engine.getTriggerDetail(purgeName);
                    }
                    if (purgeDetail == null) continue;
                    this.purges.add(new Purge(purgeDetail));
                }
                this.refresh();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        Form form = managedForm.getForm().getForm();
        managedForm.getToolkit().decorateFormHeading(form);
        form.getToolBarManager().add((IAction)new Action(Messages.PurgePage_1, ExtendedImageRegistry.INSTANCE.getImageDescriptor((Object)RuntimeEditorBundle.getDefault().getImage("refresh16x16.gif"))){

            public void run() {
                PurgePage.this.refreshPurges();
            }
        });
        form.getHead().setBackground(null);
        super.createFormContent(managedForm);
        if (!AuthManager.isAuthorized((com.stambia.app.authorization.Action)com.stambia.app.authorization.Action.RUNTIME_PURGE_SCHEDULE_CREATE)) {
            this.addBtn.setEnabled(false);
        }
        if (!AuthManager.isAuthorized((com.stambia.app.authorization.Action)com.stambia.app.authorization.Action.RUNTIME_PURGE_SCHEDULE_UPDATE)) {
            this.editBtn.setEnabled(false);
        }
        if (!AuthManager.isAuthorized((com.stambia.app.authorization.Action)com.stambia.app.authorization.Action.RUNTIME_PURGE_SCHEDULE_DELETE)) {
            this.removeBtn.setEnabled(false);
        }
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener2)this.partListener);
    }

    protected void initTableViewer() {
        this.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setViewerInput(this.purges);
    }

    protected Object addItem() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = window.getActivePage();
        try {
            URI uri = CronUtils.createDefaultTmpPurgeCronFile((String)"new Purge", (String)this.host, (int)this.port);
            activePage.openEditor((IEditorInput)new PurgeEditorInput(uri, "New Purge", this.host, this.port, this.user, this.password, UUID.randomUUID().toString(), true), PurgeEditor.class.getName());
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void removeItem(Object selectedItem) {
        MessageDialog dialog;
        if (AuthManager.isAuthorized((com.stambia.app.authorization.Action)com.stambia.app.authorization.Action.RUNTIME_PURGE_SCHEDULE_DELETE) && selectedItem instanceof Purge && (dialog = new MessageDialog(Display.getCurrent().getActiveShell(), Messages.PurgePage_5, null, Messages.bind((String)Messages.PurgePage_10, (Object)((Purge)selectedItem).getJobName()), 5, new String[]{Messages.PurgePage_8, Messages.PurgePage_9}, 0)).open() == 0) {
            EngineRegistry.getDefault().removeJobTrigger(this.host, Integer.valueOf(this.port), this.user, this.password, ((Purge)selectedItem).getTriggerName(), "Purge");
            this.refreshPurges();
        }
    }

    public void dispose() {
        this.getEditor().removePageChangedListener(this.pageChangedListener);
        this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener2)this.partListener);
    }

    protected void editItem(Object selectedItem) {
        this.editPurge(selectedItem);
    }

    protected void onTableItemDoubleClick(Object selectedItem) {
        this.editPurge(selectedItem);
    }

    private void editPurge(Object selectedItem) {
        if (AuthManager.isAuthorized((com.stambia.app.authorization.Action)com.stambia.app.authorization.Action.RUNTIME_PURGE_SCHEDULE_UPDATE) && selectedItem instanceof Purge) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            IWorkbenchPage activePage = window.getActivePage();
            try {
                URI uri = CronUtils.createTemporaryPurgeCronFile((String)((Purge)selectedItem).getTriggerName(), (String)this.host, (int)this.port, (String)this.user, (String)this.password);
                String purgeTriggerName = ((Purge)selectedItem).getTriggerName();
                activePage.openEditor((IEditorInput)new PurgeEditorInput(uri, purgeTriggerName, this.host, this.port, this.user, this.password, purgeTriggerName), PurgeEditor.class.getName());
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    protected void registerPages(DetailsPart detailsPart) {
        detailsPart.registerPage(Purge.class, (IDetailsPage)new PurgeDetailsPage());
    }

    class Purge {
        private Date startTime;
        private Date endTime;
        private Date nextExecution;
        private String triggerName;
        private String purgeSize;
        private String purgeUnit;
        private Integer repeatCount;
        private String cronExpression;
        private String jobName;
        private String status;
        private String sessionNames;
        private String triggerState;
        private Date lastExecution;
        private String triggerType;
        private Long repeatInterval;
        private IntervalUnit intervalUnit;
        private Set<Integer> dayOfWeek;
        private Map<String, Object> purgeDetails;

        public Purge(Map<String, Object> purgeParams) {
            block37: {
                Map params;
                block38: {
                    this.purgeDetails = purgeParams;
                    if (purgeParams.containsKey("intervalUnit")) {
                        this.intervalUnit = (IntervalUnit)purgeParams.get("intervalUnit");
                    }
                    this.triggerType = purgeParams.containsKey("triggerType") ? (String)purgeParams.get("triggerType") : "CRON_TRIGGER";
                    if (purgeParams.containsKey("dayOfWeek")) {
                        this.dayOfWeek = (Set)purgeParams.get("dayOfWeek");
                    }
                    if (purgeParams.containsKey("startTime")) {
                        this.startTime = (Date)purgeParams.get("startTime");
                    }
                    if (purgeParams.containsKey("endTime")) {
                        this.endTime = (Date)purgeParams.get("endTime");
                    }
                    if (purgeParams.containsKey("purgeSize")) {
                        this.purgeSize = (String)purgeParams.get("purgeSize");
                    }
                    if (purgeParams.containsKey("purgeUnit")) {
                        this.purgeUnit = (String)purgeParams.get("purgeUnit");
                    }
                    if (purgeParams.containsKey("repeatCount")) {
                        this.repeatCount = (Integer)purgeParams.get("repeatCount");
                    }
                    if (purgeParams.containsKey("cronExpression")) {
                        this.cronExpression = (String)purgeParams.get("cronExpression");
                    }
                    if (purgeParams.containsKey("jobName")) {
                        this.jobName = (String)purgeParams.get("jobName");
                    }
                    if (purgeParams.containsKey("nextExecution")) {
                        this.nextExecution = (Date)purgeParams.get("nextExecution");
                    }
                    if (purgeParams.containsKey("lastExecution")) {
                        this.lastExecution = (Date)purgeParams.get("lastExecution");
                    }
                    if (purgeParams.containsKey("triggerName")) {
                        this.triggerName = (String)purgeParams.get("triggerName");
                    }
                    if (purgeParams.containsKey("triggerState")) {
                        Object o = purgeParams.get("triggerState");
                        if (o instanceof String) {
                            for (TriggerState ts : TriggerState.VALUES) {
                                if (!((String)o).equalsIgnoreCase(ts.name())) continue;
                                this.triggerState = ts.getLiteral();
                            }
                        }
                        if (o instanceof Integer) {
                            int state = (Integer)o;
                            switch (state) {
                                case -1: {
                                    this.triggerState = TriggerState.NONE.getLiteral();
                                    break;
                                }
                                case 0: {
                                    this.triggerState = TriggerState.NORMAL.getLiteral();
                                    break;
                                }
                                case 1: {
                                    this.triggerState = TriggerState.PAUSED.getLiteral();
                                    break;
                                }
                                case 2: {
                                    this.triggerState = TriggerState.COMPLETE.getLiteral();
                                    break;
                                }
                                case 3: {
                                    this.triggerState = TriggerState.ERROR.getLiteral();
                                    break;
                                }
                                case 4: {
                                    this.triggerState = TriggerState.BLOCKED.getLiteral();
                                }
                                default: {
                                    break;
                                }
                            }
                        }
                    } else {
                        this.triggerState = TriggerState.UNKNOWN.getLiteral();
                    }
                    if (purgeParams.containsKey("repeatInterval")) {
                        Object interval = purgeParams.get("repeatInterval");
                        this.repeatInterval = interval instanceof Integer ? Long.valueOf(((Integer)interval).intValue()) : (Long)interval;
                    }
                    if (!purgeParams.containsKey("mapParameters") || (params = (Map)purgeParams.get("mapParameters")) == null || params.isEmpty()) break block37;
                    if (params.containsKey("purgeStatusList")) {
                        Map statusList = (Map)params.get("purgeStatusList");
                        this.status = "";
                        if (statusList != null) {
                            for (Object o : statusList.values()) {
                                if (!(o instanceof Integer)) continue;
                                switch ((Integer)o) {
                                    case 1: {
                                        this.status = String.valueOf(this.status) + RuntimeStatus.DONE.getLiteral() + " ";
                                        break;
                                    }
                                    case -1: {
                                        this.status = String.valueOf(this.status) + RuntimeStatus.ERROR.getLiteral() + " ";
                                        break;
                                    }
                                    case -2: {
                                        this.status = String.valueOf(this.status) + RuntimeStatus.KILLED.getLiteral() + " ";
                                        break;
                                    }
                                    case -4: {
                                        this.status = String.valueOf(this.status) + RuntimeStatus.DEAD.getLiteral() + " ";
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    if (!params.containsKey("purgeSessionName")) break block38;
                    Map sessionList = (Map)params.get("purgeSessionName");
                    this.sessionNames = "";
                    if (sessionList == null) break block37;
                    for (Object sessionMap : sessionList.values()) {
                        if (!(sessionMap instanceof HashMap) || !((Map)sessionMap).containsKey("filter")) continue;
                        this.sessionNames = String.valueOf(this.sessionNames) + (String)((Map)sessionMap).get("filter") + " ";
                    }
                    break block37;
                }
                this.sessionNames = "";
                for (Object sessionMap : params.values()) {
                    if (!(sessionMap instanceof HashMap) || !((Map)sessionMap).containsKey("filter")) continue;
                    this.sessionNames = String.valueOf(this.sessionNames) + (String)((Map)sessionMap).get("filter") + " ";
                }
            }
        }

        public Map<String, Object> getPurgeDetails() {
            return this.purgeDetails;
        }

        public String getSessionNames() {
            if (this.sessionNames == null || this.sessionNames.isEmpty()) {
                return "";
            }
            return this.sessionNames;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public String getCronExpression() {
            return this.cronExpression;
        }

        public String getJobName() {
            return this.jobName;
        }

        public Date getNextExecution() {
            return this.nextExecution;
        }

        public String getPurgeSize() {
            return this.purgeSize;
        }

        public String getPurgeUnit() {
            return this.purgeUnit;
        }

        public Integer getRepeatCount() {
            return this.repeatCount;
        }

        public Long getRepeatInterval() {
            return this.repeatInterval;
        }

        public String getTriggerName() {
            return this.triggerName;
        }

        public String getStatus() {
            if (this.status == null || this.status.isEmpty()) {
                return "All";
            }
            return this.status;
        }

        public String toString() {
            return this.triggerName;
        }

        public String getTriggerState() {
            return this.triggerState;
        }

        public Date getLastExecution() {
            return this.lastExecution;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public Set<Integer> getDayOfWeek() {
            return this.dayOfWeek;
        }

        public IntervalUnit getIntervalUnit() {
            return this.intervalUnit;
        }

        public String getTriggerType() {
            return this.triggerType;
        }
    }
}

