/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.runtime.editor.page;

import com.indy.engine.core.common.FunctionType;
import com.indy.engine.log.engine.AnalyticsEngineWrapper;
import com.indy.ui.common.editor.input.RuntimeEditorInput;
import com.indy.ui.runtime.editor.RuntimeEditorBundle;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class VirtualMachineEditorPage
extends FormPage {
    private FormToolkit toolkit;
    private ScrolledForm form;
    private Map<String, String> mapParams;
    private RuntimeEditorInput editorInput;

    public VirtualMachineEditorPage(FormEditor editor, RuntimeEditorInput editorInput) {
        super(editor, UUID.randomUUID().toString(), "");
        this.editorInput = editorInput;
        this.mapParams = new HashMap<String, String>();
    }

    private void createHeaderSection() {
        this.toolkit.decorateFormHeading(this.form.getForm());
        this.form.setText("Virtual Machine");
        Action refresh = new Action("Refresh", ExtendedImageRegistry.INSTANCE.getImageDescriptor((Object)RuntimeEditorBundle.getDefault().getImage("refresh16x16.gif"))){

            public void run() {
                Control[] controlArray = VirtualMachineEditorPage.this.form.getBody().getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control ctrl = controlArray[n2];
                    ctrl.dispose();
                    ++n2;
                }
                VirtualMachineEditorPage.this.createBodySection();
                VirtualMachineEditorPage.this.form.getBody().layout();
            }
        };
        this.form.getToolBarManager().add((IAction)refresh);
        this.form.getToolBarManager().update(true);
        this.form.getForm().getHead().setBackground(null);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.form = this.getManagedForm().getForm();
        this.toolkit = this.getManagedForm().getToolkit();
        Composite body = this.form.getBody();
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        body.setLayout((Layout)layout);
        this.createHeaderSection();
        this.createBodySection();
    }

    private void createBodySection() {
        try {
            AnalyticsEngineWrapper engine = this.editorInput.getEngine();
            if (engine != null) {
                HashMap<String, Object> mapQuestion = new HashMap<String, Object>();
                mapQuestion.put(FunctionType.getMonitoringSummary.name(), null);
                Map mapAnswer = engine.get(mapQuestion);
                this.mapParams = (Map)mapAnswer.get(FunctionType.getMonitoringSummary.name());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.createVirtualMachineParametersComposite(this.form.getBody());
    }

    private Composite createSectionClient() {
        TableWrapData wd = new TableWrapData();
        TableWrapLayout layout = new TableWrapLayout();
        Section section = this.toolkit.createSection(this.form.getBody(), 256);
        wd = new TableWrapData(256);
        section.setLayoutData((Object)wd);
        Composite sectionClient = this.toolkit.createComposite((Composite)section);
        layout = new TableWrapLayout();
        layout.numColumns = 2;
        sectionClient.setLayout((Layout)layout);
        section.setClient((Control)sectionClient);
        return sectionClient;
    }

    private void createVirtualMachineParametersComposite(Composite parent) {
        Composite client = this.createSectionClient();
        this.addLabelAndValue(client, "Virtual Machine");
        this.addLabelAndValue(client, "Uptime");
        this.addLabelAndValue(client, "Vendor");
        this.addLabelAndValue(client, "Process CPU Time");
        this.addLabelAndValue(client, "Name");
        this.addLabelAndValue(client, "JIT Compiler");
        this.addLabelAndValue(client, "Total compile time");
        Composite client2 = this.createSectionClient();
        this.addLabelAndValue(client2, "Live threads");
        this.addLabelAndValue(client2, "Total threads started");
        this.addLabelAndValue(client2, "Peak");
        this.addLabelAndValue(client2, "Total compile time");
        this.addLabelAndValue(client2, "Daemon threads");
        this.addLabelAndValue(client2, "Total classes loaded");
        this.addLabelAndValue(client2, "Current classes loaded");
        Composite client3 = this.createSectionClient();
        this.addLabelAndValue(client3, "Current heap size");
        this.addLabelAndValue(client3, "Committed memory");
        this.addLabelAndValue(client3, "Maximum heap size");
        this.addLabelAndValue(client3, "Pending finalization");
        this.addLabelAndValue(client3, "Garbage collector 1");
        this.addLabelAndValue(client3, "Garbage collector 2");
        Composite client4 = this.createSectionClient();
        this.addLabelAndValue(client4, "Operating system");
        this.addLabelAndValue(client4, "Committed virtual memory");
        this.addLabelAndValue(client4, "Architecture");
        this.addLabelAndValue(client4, "Total physical memory");
        this.addLabelAndValue(client4, "Number of processors");
        this.addLabelAndValue(client4, "Free physical memory");
        this.addLabelAndValue(client4, "Free swap space");
        this.addLabelAndValue(client4, "Total swap space");
        TableWrapData wd = new TableWrapData();
        TableWrapLayout layout = new TableWrapLayout();
        Section section = this.toolkit.createSection(this.form.getBody(), 256);
        wd = new TableWrapData(256);
        wd.colspan = 2;
        section.setLayoutData((Object)wd);
        Composite sectionClient = this.toolkit.createComposite((Composite)section);
        layout = new TableWrapLayout();
        layout.numColumns = 4;
        sectionClient.setLayout((Layout)layout);
        section.setClient((Control)sectionClient);
        Hyperlink vmArgs = this.toolkit.createHyperlink(sectionClient, "VM arguments", 64);
        vmArgs.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ArgsTrayDialog dialog = new ArgsTrayDialog(Display.getCurrent().getActiveShell(), (String)VirtualMachineEditorPage.this.mapParams.get("VM arguments"));
                dialog.open();
            }
        });
        Hyperlink classPath = this.toolkit.createHyperlink(sectionClient, "Class path", 64);
        classPath.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ArgsTrayDialog dialog = new ArgsTrayDialog(Display.getCurrent().getActiveShell(), (String)VirtualMachineEditorPage.this.mapParams.get("Class path"));
                dialog.open();
            }
        });
        Hyperlink libPath = this.toolkit.createHyperlink(sectionClient, "Library path", 64);
        libPath.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ArgsTrayDialog dialog = new ArgsTrayDialog(Display.getCurrent().getActiveShell(), (String)VirtualMachineEditorPage.this.mapParams.get("Library path"));
                dialog.open();
            }
        });
        Hyperlink bootClassPath = this.toolkit.createHyperlink(sectionClient, "Boot class path", 64);
        bootClassPath.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ArgsTrayDialog dialog = new ArgsTrayDialog(Display.getCurrent().getActiveShell(), (String)VirtualMachineEditorPage.this.mapParams.get("Boot class path"));
                dialog.open();
            }
        });
    }

    private void addLabelAndValue(Composite parent, String key) {
        if (this.mapParams.containsKey(key)) {
            Text textLabel = new Text(parent, 8);
            textLabel.setText(key);
            Text textValue = new Text(parent, 72);
            textValue.setText(this.mapParams.get(key));
        }
    }

    public class ArgsTrayDialog
    extends TrayDialog {
        String args;

        protected boolean isResizable() {
            return true;
        }

        public ArgsTrayDialog(Shell parentShell, String args) {
            super(parentShell);
            this.args = args;
        }

        public void create() {
            super.create();
        }

        protected Control createDialogArea(Composite parent) {
            Text labelText = new Text(parent, 584);
            GridData gd = new GridData(1808);
            gd.heightHint = 400;
            gd.widthHint = 500;
            labelText.setLayoutData((Object)gd);
            labelText.setText(this.args);
            return parent;
        }
    }
}

