/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.common.editor.input;

import com.indy.engine.log.engine.EngineRegistry;
import com.indy.engine.log.exchange.DeliveryMapWrapper;
import com.indy.engine.log.object.impl.EngineRuntimeHeader;
import com.indy.ui.common.editor.input.ConfigurationNode;
import com.indy.ui.common.editor.input.ConnectionData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class DeliveryEditorInput
implements IEditorInput {
    private String deliveryName;
    private String deliveryEditorId;
    private List<EngineRuntimeHeader> runtimes;
    private Map<String, DeliveryMapWrapper> deliveryWrapper = new HashMap<String, DeliveryMapWrapper>();
    private boolean showOnlyConnectionTab;
    private List<ConnectionData> connections;
    private String repoDir;
    private List<ConfigurationNode> configurations;

    public Object getAdapter(Class adapter) {
        return null;
    }

    public DeliveryEditorInput(String name, String id, List<EngineRuntimeHeader> runtimes, List<ConnectionData> connections, boolean showOnlyConnectionTab, String repoDir) {
        this.deliveryName = name;
        this.deliveryEditorId = id;
        this.runtimes = runtimes;
        this.showOnlyConnectionTab = showOnlyConnectionTab;
        this.connections = connections;
        this.repoDir = repoDir;
    }

    public DeliveryEditorInput(String deliveryName, String deliveryEditorId, String runtimeName, int port, String host, String user, String password, String repoDir, Boolean isNoSessionAccess) {
        this.deliveryName = deliveryName;
        this.deliveryEditorId = deliveryEditorId;
        this.repoDir = repoDir;
        this.runtimes = new ArrayList<EngineRuntimeHeader>();
        this.runtimes.add(new EngineRuntimeHeader(runtimeName, host, Integer.valueOf(port), user, password, isNoSessionAccess));
        this.showOnlyConnectionTab = false;
        try {
            DeliveryMapWrapper deliv = EngineRegistry.getDefault().getDelivery(host, Integer.valueOf(port), user, password, deliveryName, repoDir);
            this.deliveryWrapper.put(deliv.getConfigurationCode() != null ? deliv.getConfigurationCode() : "default", deliv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DeliveryEditorInput(String resourceName, String resourceId, List<EngineRuntimeHeader> runtimes, List<ConfigurationNode> configurations) {
        this.deliveryName = resourceName;
        this.deliveryEditorId = resourceId;
        this.runtimes = runtimes;
        this.showOnlyConnectionTab = true;
        this.configurations = configurations;
    }

    public List<ConfigurationNode> getConfigurations() {
        return this.configurations;
    }

    public boolean isShowOnlyConnectionTab() {
        return this.showOnlyConnectionTab;
    }

    public List<EngineRuntimeHeader> getRuntimes() {
        return this.runtimes;
    }

    public Map<String, DeliveryMapWrapper> getDeliveryWrapper() {
        return this.deliveryWrapper;
    }

    public String getDeliveryEditorId() {
        return this.deliveryEditorId;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.deliveryName;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.deliveryName;
    }

    public List<ConnectionData> getConnections() {
        return this.connections;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeliveryEditorInput other = (DeliveryEditorInput)obj;
        return this.getDeliveryEditorId().equals(other.getDeliveryEditorId());
    }

    public String getRepoDir() {
        return this.repoDir;
    }
}

