/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.common.editor.input;

import com.indy.engine.log.engine.AnalyticsEngineWrapper;
import com.indy.engine.log.engine.EngineRegistry;
import com.indy.ui.common.editor.input.RuntimeEditorInputFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class RuntimeEditorInput
implements IEditorInput,
IPersistableElement {
    private String host;
    private int port;
    private String runtimeId;
    private String runtimeName;
    private String user;
    private String password;
    private boolean engineInit = false;
    private AnalyticsEngineWrapper engine = null;

    public Object getAdapter(Class adapter) {
        return null;
    }

    public RuntimeEditorInput(IMemento memento) {
        this.loadState(memento);
    }

    static RuntimeEditorInput create(IMemento memento) {
        return new RuntimeEditorInput(memento);
    }

    public RuntimeEditorInput(String host, int port, String runtimeId, String runtimeName, String user, String password) {
        this.host = host;
        this.port = port;
        this.runtimeId = runtimeId;
        this.runtimeName = runtimeName;
        this.user = user;
        this.password = password;
    }

    public void saveState(IMemento memento) {
        memento.putString("host", this.host);
        memento.putInteger("port", this.port);
        memento.putString("runtimeId", this.runtimeId);
        memento.putString("runtimeName", this.runtimeName);
        memento.putString("user", this.user);
        memento.putString("password", this.password);
        memento.putString("bundle", "com.indy.ui.runtime.editor");
        memento.putString("class", "com.indy.ui.tools.editor.input.RuntimeEditorInput");
    }

    private void loadState(IMemento memento) {
        this.host = memento.getString("host");
        this.port = memento.getInteger("port");
        this.runtimeId = memento.getString("runtimeId");
        this.runtimeName = memento.getString("runtimeName");
        this.user = memento.getString("user");
        this.password = memento.getString("password");
    }

    public String getFactoryId() {
        return RuntimeEditorInputFactory.ID;
    }

    public AnalyticsEngineWrapper getEngine() {
        if (!this.engineInit) {
            Job currentJob = new Job("Connecting to " + this.host + ":" + this.port){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.setTaskName("Connecting to " + RuntimeEditorInput.this.host + ":" + RuntimeEditorInput.this.port);
                    monitor.beginTask("Connecting", -1);
                    try {
                        RuntimeEditorInput.this.engine = EngineRegistry.getDefault().getEngine(RuntimeEditorInput.this.host, Integer.valueOf(RuntimeEditorInput.this.port), RuntimeEditorInput.this.user, RuntimeEditorInput.this.password);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    RuntimeEditorInput.this.engineInit = true;
                    return Status.OK_STATUS;
                }
            };
            currentJob.setUser(true);
            currentJob.schedule();
        }
        return this.engine;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRuntimeId() {
        return this.runtimeId;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.runtimeName;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return "";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuntimeEditorInput other = (RuntimeEditorInput)obj;
        return other.runtimeId != null && this.runtimeId != null && this.runtimeId.equals(other.runtimeId);
    }
}

