/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.common.editor.input;

import com.indy.ui.common.resource.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class ScheduleEditorInput
implements IEditorInput {
    private String host;
    private IResource delivery;
    private int port;
    private String triggerName;
    private URI uri;
    private String deliveryId;
    private String ScheduleEditorId;
    private String scheduleName;
    private boolean isNew;
    private IResource schedule;
    private String user;
    private String password;
    private String repoDir;
    private String logLevel;

    public ScheduleEditorInput(URI uri, String triggerName, IResource resource, String host, int port, String user, String password, String deliveryId, String repoDir, String logLevel) {
        this.uri = uri;
        this.triggerName = triggerName;
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.delivery = resource.getParent();
        this.schedule = resource;
        this.isNew = false;
        this.ScheduleEditorId = String.valueOf(this.delivery.getResourceId()) + "/" + triggerName;
        this.deliveryId = deliveryId;
        this.repoDir = repoDir;
        this.scheduleName = resource.getName();
        this.logLevel = logLevel;
    }

    public String getRepoDir() {
        return this.repoDir;
    }

    public ScheduleEditorInput(URI uri, String triggerName, IResource parent, String host, int port, String user, String password, String deliveryId, boolean isNew, String repoDir, String logLevel) {
        this.uri = uri;
        this.triggerName = triggerName;
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.delivery = parent;
        this.schedule = null;
        this.isNew = isNew;
        this.repoDir = repoDir;
        this.ScheduleEditorId = String.valueOf(this.delivery.getResourceId()) + "/" + triggerName;
        this.deliveryId = deliveryId;
        this.logLevel = logLevel;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScheduleEditorInput other = (ScheduleEditorInput)obj;
        return this.ScheduleEditorId.equals(other.ScheduleEditorId);
    }

    public String getdeliveryId() {
        return this.deliveryId;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public IResource getDelivery() {
        return this.delivery;
    }

    public IResource getSchedule() {
        return this.schedule;
    }

    public void setScheduleEditorId(String scheduleEditorId) {
        this.ScheduleEditorId = scheduleEditorId;
    }

    public URI getUri() {
        return this.uri;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.scheduleName != null ? this.scheduleName : this.triggerName;
    }

    public String getScheduleEditorId() {
        return this.ScheduleEditorId;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.triggerName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUser() {
        return this.user;
    }

    public String getLogLevel() {
        return this.logLevel;
    }
}

