/*
 * Decompiled with CFR 0.152.
 */
package com.indy.product.core.analytics.support;

import com.indy.administration.AdministrationHelper;
import com.indy.administration.AdministrationListener;
import com.indy.product.core.analytics.support.NavigatorRuntime;
import com.indy.ui.common.editor.input.RuntimeEditorInput;
import com.indy.ui.common.listener.NotificationManager;
import com.indy.ui.common.resource.IStambiaRuntime;
import com.indy.ui.conf.custom.tool.ConfUtil;
import com.indy.ui.engine.Activator;
import com.indy.ui.engine.EventDispatcher;
import com.indy.ui.runtime.editor.RuntimeEditor;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.registry.RuntimeEngine;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.app.authorization.Action;
import com.stambia.egc.EgcPackage;
import com.stambia.egc.Engine;
import com.stambia.egc.util.EgcResourceFactoryImpl;
import com.stambia.ui.navigator.NavigatorFacade;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class FragmentStartClass
implements IStartup,
BundleListener {
    private static final Collection<String> SCHEDULER_ACTIVITIES_ID = Arrays.asList(Action.RUNTIME_DELIVERY_SCHEDULE_ACCESS.getActivityId(), Action.RUNTIME_DELIVERY_SCHEDULE_CREATE.getActivityId(), Action.RUNTIME_DELIVERY_SCHEDULE_DELETE.getActivityId(), Action.RUNTIME_PURGE_SCHEDULE_ACCESS.getActivityId(), Action.RUNTIME_PURGE_SCHEDULE_CREATE.getActivityId(), Action.RUNTIME_PURGE_SCHEDULE_UPDATE.getActivityId(), Action.RUNTIME_PURGE_SCHEDULE_DELETE.getActivityId(), Action.RUNTIME_DELIVERY_SCHEDULE_UPDATE.getActivityId());
    private static final Collection<String> NAVIGATOR_ACTIVITIES_ID = Arrays.asList(Action.RUNTIME_DELIVERY_DELETE.getActivityId(), Action.RUNTIME_SESSION_THREAD_ACCESS.getActivityId(), Action.RUNTIME_HOST_ACCESS.getActivityId(), Action.RUNTIME_COMMAND_EXECUTE.getActivityId(), Action.RUNTIME_DELIVERY_EXECUTE.getActivityId(), Action.RUNTIME_FOLDER_TEST.getActivityId(), Action.RUNTIME_SERVER_TEST.getActivityId());
    private boolean supportScheduler = false;
    IResourceChangeListener listener = new IResourceChangeListener(){
        protected ArrayList<URI> changedResources = new ArrayList();

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                this.changedResources.clear();
                if (event == null || event.getDelta() == null) {
                    return;
                }
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getResource().getType() == 1 && (delta.getKind() == 1 || delta.getKind() == 2 || delta.getKind() == 4 && delta.getFlags() != 131072)) {
                            IPath path = delta.getMovedToPath() != null ? delta.getMovedToPath() : delta.getFullPath();
                            URI uri1 = URI.createURI((String)path.toString());
                            URI uri2 = ConfUtil.getEgcURI();
                            if (uri1 != null && uri2 != null && uri1.toString().equals("/" + uri2.toString())) {
                                changedResources.add(uri1);
                            }
                        }
                        return true;
                    }
                });
                if (this.changedResources.size() > 0) {
                    FragmentStartClass.this.handledInputChanges(this.changedResources);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    };
    EventDispatcher.RuntimeListener rl = new EventDispatcher.RuntimeListener(){

        public void handleEvent(EventDispatcher.RuntimeEvent event) {
            if (event.type == EventDispatcher.RuntimeEventType.open && event.host != null) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                IWorkbenchPage activePage = window.getActivePage();
                try {
                    String id = "engineIdEditor:" + event.host + event.port;
                    activePage.openEditor((IEditorInput)new RuntimeEditorInput(event.host, Integer.valueOf(event.port).intValue(), id, event.name, event.user, event.password), RuntimeEditor.class.getName());
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        }
    };
    List<IStambiaRuntime> runtimes = new ArrayList<IStambiaRuntime>();
    IRegistryService.IRegistryItemEventListener runtimeEngineItemListener = new IRegistryService.IRegistryItemEventListener(){

        public void handleItemAdded(IRegistryService.IRegistryKey key, Object item) {
            if (item instanceof RuntimeEngine) {
                try {
                    RuntimeEngine engine = (RuntimeEngine)item;
                    String engineId = engine.getKey().toString();
                    NavigatorRuntime runtime = new NavigatorRuntime.RuntimeBuilder(engine.getName(), engine.getHost(), Integer.valueOf(engine.getPort()), engineId).password(engine.getPassword()).user(engine.getUser()).build();
                    FragmentStartClass.this.runtimes.add(runtime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void handleItemRemoved(IRegistryService.IRegistryKey key, Object item) {
            if (item instanceof RuntimeEngine) {
                IStambiaRuntime runtime = null;
                for (IStambiaRuntime r : FragmentStartClass.this.runtimes) {
                    if (!r.getUUID().equals(key.toString())) continue;
                    runtime = r;
                    break;
                }
                FragmentStartClass.this.runtimes.remove(runtime);
            }
        }

        public void handleItemUpdated(IRegistryService.IRegistryKey registrationKey, Object item) {
            this.handleItemRemoved(registrationKey, item);
            this.handleItemAdded(registrationKey, item);
        }
    };
    Comparator<IStambiaRuntime> runtimeComparator = new Comparator<IStambiaRuntime>(){

        @Override
        public int compare(IStambiaRuntime a, IStambiaRuntime b) {
            String name1 = a.getName().toLowerCase();
            String name2 = b.getName().toLowerCase();
            return name1.compareTo(name2);
        }
    };
    IRegistryService.IRegistryBatchEventListener runtimeEngineBatchListener = new IRegistryService.IRegistryBatchEventListener(){

        public void handleBatchedEvent() {
            Collections.sort(FragmentStartClass.this.runtimes, FragmentStartClass.this.runtimeComparator);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    NavigatorFacade.setRuntimes((this).FragmentStartClass.this.runtimes);
                    NotificationManager.getInstance().notifyRuntimesRefreshListeners();
                }
            });
        }
    };

    public void earlyStartup() {
        this.initResourceListener();
        this.initRuntimeListener();
        Bundle bundle = Platform.getBundle((String)"com.indy.product.core");
        BundleContext ctx = bundle.getBundleContext();
        if (ctx != null) {
            ctx.addBundleListener((BundleListener)this);
        }
        this.supportScheduler = AdministrationHelper.supportScheduler();
        this.enableSchedulerActivities(this.supportScheduler);
        AdministrationHelper.addListener((AdministrationListener)new AdministrationListener(){

            public void handleRoleChanged() {
                boolean newSupportSchedulerStatus = AdministrationHelper.supportScheduler();
                if (newSupportSchedulerStatus != FragmentStartClass.this.supportScheduler) {
                    boolean bl = newSupportSchedulerStatus;
                    FragmentStartClass.this.supportScheduler = bl;
                    FragmentStartClass.this.enableSchedulerActivities(bl);
                }
            }
        });
    }

    private void enableSchedulerActivities(boolean enable) {
        final IWorkbenchActivitySupport support = PlatformUI.getWorkbench().getActivitySupport();
        final HashSet<String> currentActivities = new HashSet<String>(support.getActivityManager().getEnabledActivityIds());
        if (enable) {
            currentActivities.addAll(SCHEDULER_ACTIVITIES_ID);
        } else {
            currentActivities.removeAll(SCHEDULER_ACTIVITIES_ID);
        }
        currentActivities.addAll(NAVIGATOR_ACTIVITIES_ID);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                support.setEnabledActivityIds(currentActivities);
                NotificationManager.getInstance().notifyRuntimesRefreshListeners();
            }
        });
    }

    private void initResourceListener() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IRegistryService.IRegistry reg = ((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(RuntimeEngine.class);
        reg.addRegistryBatchEventListener(this.runtimeEngineBatchListener);
        reg.addRegistryItemEventListener(this.runtimeEngineItemListener);
        for (RuntimeEngine runtime : reg.getAll()) {
            this.runtimeEngineItemListener.handleItemAdded((IRegistryService.IRegistryKey)runtime.getKey(), (Object)runtime);
        }
        this.runtimeEngineBatchListener.handleBatchedEvent();
        try {
            final ArrayList<URI> changedResources = new ArrayList<URI>();
            workspace.getRoot().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.getFileExtension() != null && resource.getFileExtension().equals("egc")) {
                        URI uri1 = URI.createURI((String)resource.getFullPath().toString());
                        URI uri2 = ConfUtil.getEgcURI();
                        if (uri1 != null && uri2 != null && uri1.toString().equals("/" + uri2.toString())) {
                            changedResources.add(uri1);
                        }
                    }
                    return true;
                }
            });
            this.handledInputChanges(changedResources);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        workspace.addResourceChangeListener(this.listener);
    }

    private void initRuntimeListener() {
        Activator.getDefault().getDispatcher().addRuntimeListeners(this.rl);
    }

    private void handledInputChanges(List<URI> list) {
        for (URI uri : list) {
            ResourceSetImpl rs = new ResourceSetImpl();
            rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new EgcResourceFactoryImpl());
            rs.getPackageRegistry().put((Object)"http://www.stambia.com/egc", (Object)EgcPackage.eINSTANCE);
            try {
                Resource resource = rs.getResource(uri, true);
                resource.load(null);
                EcoreUtil.resolveAll((Resource)resource);
                if (resource != null && resource.getContents().size() != 0 && ((EObject)resource.getContents().get(0)).eContents().size() != 0) {
                    for (Engine engine : ((EObject)((EObject)resource.getContents().get(0)).eContents().get(0)).eContents()) {
                        NavigatorRuntime runtime = null;
                        String engineId = resource.getURIFragment((EObject)engine);
                        if (runtime == null) {
                            runtime = new NavigatorRuntime.RuntimeBuilder(engineId).build();
                            this.runtimes.add(runtime);
                        }
                        if (!(engine.getServer() == null || engine.getServer().isEmpty() || engine.getPort() == null || engine.getPort().isEmpty() || engine.getName() == null || engine.getName().isEmpty())) {
                            runtime.setHost(engine.getServer());
                            runtime.setPort(Integer.valueOf(engine.getPort()));
                            runtime.setName(engine.getName());
                            runtime.setUser(engine.getUser());
                            runtime.setPassword(engine.getPassword());
                            continue;
                        }
                        this.runtimes.remove(runtime);
                    }
                }
                resource.unload();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                NavigatorFacade.setRuntimes(FragmentStartClass.this.runtimes);
                NotificationManager.getInstance().notifyRuntimesRefreshListeners();
            }
        });
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 256 && event.getBundle() != null && event.getBundle().getSymbolicName().equals("com.indy.product.core")) {
            try {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                if (workspace != null) {
                    workspace.removeResourceChangeListener(this.listener);
                    IRegistryService.IRegistry reg = ((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(RuntimeEngine.class);
                    reg.removeRegistryItemEventListener(this.runtimeEngineItemListener);
                    reg.removeRegistryBatchEventListener(this.runtimeEngineBatchListener);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                Activator.getDefault().getDispatcher().removeRuntimeListeners(this.rl);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

