/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.tech.util.custom;

import com.semarchy.xdi.designer.core.models.IndyXMLResource;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.services.registry.LevelCodeInfo;
import com.semarchy.xdi.designer.core.services.registry.RegistrationDescriptor;
import com.semarchy.xdi.designer.core.services.registry.TechExtension;
import com.stambia.tech.DocumentRoot;
import com.stambia.tech.Level;
import com.stambia.tech.Tech;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public class StbTechResourceImpl
extends IndyXMLResource
implements IRegistryService.IRegistrationContribution {
    public static String LOAD_TECH_MESSAGE_PROVIDER = "com.stambia.tech.util.custom.StbTechResourceImpl.TechMessageProvider";
    private static List<Class> contributedRegistries = Arrays.asList(LevelCodeInfo.class);

    public StbTechResourceImpl(URI uri) {
        super(uri);
    }

    public List<Class> getContributedRegistries() {
        if (!this.getContents().isEmpty()) {
            Tech tech = ((DocumentRoot)this.getContents().get(0)).getTech();
            if (!tech.getContributedRegistryID().isEmpty()) {
                ArrayList<Class> l = new ArrayList<Class>(contributedRegistries);
                l.add(RegistrationDescriptor.class);
                if (this.getURI() != null && "tech_ext".equals(this.getURI().fileExtension())) {
                    l.add(TechExtension.class);
                }
                return l;
            }
            ArrayList<Class> l = new ArrayList<Class>(contributedRegistries);
            if (this.getURI() != null && "tech_ext".equals(this.getURI().fileExtension())) {
                l.add(TechExtension.class);
            }
            return l;
        }
        return contributedRegistries;
    }

    public List<Object> createRegistryItemsFor(Class c) {
        if (this.getContents().isEmpty()) {
            return null;
        }
        Tech tech = ((DocumentRoot)this.getContents().get(0)).getTech();
        if (c == LevelCodeInfo.class) {
            ArrayList<Object> res = new ArrayList<Object>();
            for (Level l : tech.getLevel()) {
                if (l.getIcon() == null || l.getIcon().isEmpty()) continue;
                res.add(new LevelCodeInfo(this.getId(), tech.getId(), l.getCode(), l.getDisplayName(), URI.createURI((String)l.getIconURL().toString())));
            }
            return res;
        }
        if (c == RegistrationDescriptor.class) {
            ArrayList<Object> res = new ArrayList<Object>();
            RegistrationDescriptor desc = new RegistrationDescriptor(this.getId());
            if (!tech.getContributedRegistryID().isEmpty()) {
                for (String itemName : tech.getContributedRegistryID()) {
                    try {
                        desc.addItemClassName(IRegistryService.extractRegistryIdFromContribution((String)itemName));
                    }
                    catch (ClassNotFoundException e) {
                        try {
                            desc.addItemClassName(IRegistryService.extractRegistryIdFromContribution((String)itemName.replace("com.indy.ui.custom.out.services.registry.", "com.semarchy.xdi.designer.core.services.registry.")));
                        }
                        catch (ClassNotFoundException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                res.add(desc);
            }
            return res;
        }
        if (c == TechExtension.class) {
            ArrayList<Object> res = new ArrayList<Object>();
            for (EObject o : tech.getExtendedRefs()) {
                String refId;
                if (o == null || (refId = CacheHelper.extractFileID((EObject)o)) == null) continue;
                res.add(new TechExtension(refId, this.getId(), tech.getExtensionPriority()));
            }
            return res;
        }
        return null;
    }
}

