/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.compare.integration.handler;

import com.indy.emf.compare.integration.handler.Messages;
import com.indy.emf.compare.integration.internal.XdiConflictDetector;
import com.indy.emf.compare.integration.internal.XdiDiffEngine;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class EnableEMFCompareHandler
extends AbstractHandler {
    public static final String ID = "com.indy.emf.compare.integration.enableEMFComparecommand";
    public static final String BUNDLE_EGIT_CORE = "org.eclipse.egit.core";
    public static final String PREF_MERGE_STRATEGY = "core_preferredMergeStrategy";
    public static final String XDI_MERGE_STRATEGY = "com.indy.emf.compare.integration.egit.jgit.StbThreeWayMergeStrategy";

    public static void enableEMFCompare(boolean toggle) throws ExecutionException {
        try {
            IContentType[] iContentTypeArray = ContentTypeManager.getInstance().getAllContentTypes();
            int n = iContentTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContentType ct = iContentTypeArray[n2];
                if (ct.getId().startsWith("com.indy.emf.compare.integration.contenttype")) {
                    String extension = ct.getId().substring(ct.getId().lastIndexOf(".") + 1);
                    EnableEMFCompareHandler.enableContentType(ct, toggle, extension);
                    if (extension.equals("tech")) {
                        EnableEMFCompareHandler.enableContentType(ct, toggle, String.valueOf(extension) + "_ext");
                    }
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            throw new ExecutionException(Messages.EnableEMFCompareHandler_5, (Throwable)ex);
        }
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, BUNDLE_EGIT_CORE);
        store.setSearchContexts(new IScopeContext[]{InstanceScope.INSTANCE});
        if (toggle) {
            store.setValue(PREF_MERGE_STRATEGY, XDI_MERGE_STRATEGY);
        } else {
            store.setToDefault(PREF_MERGE_STRATEGY);
        }
        EnableEMFCompareHandler.configureEMFComparePreferences(toggle);
    }

    public static void configureEMFComparePreferences(boolean emfCompareEnabled) {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.emf.compare.rcp");
        store.setSearchContexts(new IScopeContext[]{InstanceScope.INSTANCE});
        if (emfCompareEnabled) {
            store.setValue("org.eclipse.emf.compare.preference.diff.engine", XdiDiffEngine.class.getName());
            store.setValue("org.eclipse.emf.compare.preference.conflict.detector", XdiConflictDetector.class.getName());
        } else {
            store.setToDefault("org.eclipse.emf.compare.preference.diff.engine");
            store.setToDefault("org.eclipse.emf.compare.preference.conflict.detector");
        }
    }

    private static void enableContentType(IContentType ct, boolean enabled, String extension) throws Exception {
        if (enabled) {
            ct.addFileSpec(extension, 8);
        } else {
            ct.removeFileSpec(extension, 8);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Command command = event.getCommand();
        boolean toggle = HandlerUtil.toggleCommandState((Command)command);
        EnableEMFCompareHandler.enableEMFCompare(!toggle);
        return null;
    }
}

